/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public interface ValidationResult {
    public boolean isSuccessful();

    public ValidationResult merge(ValidationResult var1);

    public boolean isBlocking();

    default public Set<String> getFormatedMessages(Locale locale) {
        return Collections.emptySet();
    }

    public static class FailedValidationResult
    implements ValidationResult,
    Serializable {
        private final Exception exception;

        public FailedValidationResult(Exception exception) {
            this.exception = exception;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public ValidationResult merge(ValidationResult toBeMergedWith) {
            return toBeMergedWith;
        }

        @Override
        public boolean isBlocking() {
            return true;
        }

        public String toString() {
            String localizedMessage = this.exception.getLocalizedMessage();
            Throwable cause = this.exception.getCause();
            return "Validation failed because of a " + this.exception.getClass().getSimpleName() + (String)(localizedMessage == null ? " " : " with message '" + localizedMessage + "'") + (String)(cause == null ? "" : " caused by '" + cause.getLocalizedMessage() + "'");
        }
    }
}

