/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.jcr.RepositoryException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.JahiaCndReader;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.modulemanager.BundleChecker;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsBundleChecker
implements BundleChecker {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionsBundleChecker.class);

    @Override
    public void check(PersistentBundle bundle) {
        try (InputStream is = new URL(bundle.getLocation()).openConnection().getInputStream();){
            JarInputStream zip = new JarInputStream(is);
            ZipEntry zipEntry = zip.getNextEntry();
            long lastModified = 0L;
            HashMap<String, String> cnds = new HashMap<String, String>();
            while (zipEntry != null) {
                String name = zipEntry.getName();
                if (name.startsWith("META-INF/") && name.endsWith(".cnd")) {
                    logger.info("Found definitions file {}", (Object)name);
                    long l = zipEntry.getLastModifiedTime().toMillis();
                    if (l > lastModified) {
                        lastModified = l;
                    }
                    cnds.put(name, IOUtils.toString((InputStream)zip, (Charset)StandardCharsets.UTF_8));
                }
                zipEntry = zip.getNextEntry();
            }
            if (cnds.isEmpty()) {
                return;
            }
            Manifest mf = zip.getManifest();
            String systemId = mf.getMainAttributes().getValue("Bundle-SymbolicName");
            String versionString = mf.getMainAttributes().getValue("Implementation-Version");
            if (versionString == null) {
                return;
            }
            ModuleVersion moduleVersion = new ModuleVersion(versionString);
            logger.info("Definitions checks for module {}", (Object)systemId);
            boolean latestDefinitions = JCRStoreService.getInstance().isLatestDefinitions(systemId, moduleVersion, lastModified);
            if (latestDefinitions) {
                for (Map.Entry entry : cnds.entrySet()) {
                    this.checkCnd(systemId, (String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (IOException | RepositoryException e) {
            logger.error("Error", e);
        }
    }

    private void checkCnd(String systemId, String filename, String content) throws RepositoryException {
        JahiaCndReader r = new JahiaCndReader(new StringReader(content), filename, systemId, NodeTypeRegistry.getInstance());
        r.setDoCheckConsistency(false);
        try {
            r.parse();
        }
        catch (ParseException e) {
            logger.error("Error", (Throwable)e);
        }
        r.setDeclaredSuperTypes();
        for (ExtendedNodeType newNt : r.getNodeTypesList()) {
            NodeTypeRegistry registry = NodeTypeRegistry.getInstance();
            if (!registry.hasNodeType(newNt.getName())) continue;
            ExtendedNodeType regNt = registry.getNodeType(newNt.getName());
            if (!regNt.getSystemId().equals(newNt.getSystemId())) {
                throw new ModuleManagementException(Messages.format("Definition {0} was already deployed in {1}", newNt.getName(), regNt.getSystemId()));
            }
            NodeTypeDefDiff diff = NodeTypeDefDiff.create(regNt, newNt);
            if (!diff.isModified() || !diff.isMajor()) continue;
            logger.error("Major changes detected: \n{}", (Object)diff);
            throw new ModuleManagementException(Messages.format("Major change in definition : {0}, cancel module deployment", diff));
        }
    }

    public static class NodeTypeDefDiff {
        private final ExtendedNodeType oldDef;
        private final ExtendedNodeType newDef;
        private DiffType type;
        private final List<PropDefDiff> propDefDiffs = new ArrayList<PropDefDiff>();
        private final List<ChildNodeDefDiff> childNodeDefDiffs = new ArrayList<ChildNodeDefDiff>();

        private NodeTypeDefDiff(ExtendedNodeType oldDef, ExtendedNodeType newDef) {
            this.oldDef = oldDef;
            this.newDef = newDef;
            this.type = DiffType.NONE;
            DiffType tmpType = this.supertypesDiff();
            if (tmpType.compareTo(this.type) > 0) {
                this.type = tmpType;
            }
            if ((tmpType = this.mixinFlagDiff()).compareTo(this.type) > 0) {
                this.type = tmpType;
            }
            if ((tmpType = this.abstractFlagDiff()).compareTo(this.type) > 0) {
                this.type = tmpType;
            }
            PropDefDiffBuilder propDefDiffBuilder = new PropDefDiffBuilder(CollectionUtils.union(oldDef.getRawProperties().values(), oldDef.getRawUnstructuredProperties().values()), CollectionUtils.union(newDef.getRawProperties().values(), newDef.getRawUnstructuredProperties().values()));
            Map<String, ExtendedPropertyDefinition> propDefsMap = Arrays.stream(newDef.getPropertyDefinitions()).collect(Collectors.toMap(NodeTypeDefDiff::getPropertyName, p -> p));
            List childItemDefDiffs = propDefDiffBuilder.getChildItemDefDiffs().stream().map(propDefDiff -> {
                if (!propDefDiff.isRemoved()) {
                    return propDefDiff;
                }
                ExtendedPropertyDefinition oldProp = (ExtendedPropertyDefinition)propDefDiff.getOldDef();
                ExtendedPropertyDefinition movedProp = (ExtendedPropertyDefinition)propDefsMap.get(NodeTypeDefDiff.getPropertyName(oldProp));
                return movedProp != null ? new PropDefDiff(oldProp, movedProp) : propDefDiff;
            }).collect(Collectors.toList());
            this.propDefDiffs.addAll(childItemDefDiffs);
            tmpType = ChildItemDefDiffBuilder.getMaxType(childItemDefDiffs);
            if (tmpType.compareTo(this.type) > 0) {
                this.type = tmpType;
            }
            ChildNodeDefDiffBuilder childNodeDefDiffBuilder = new ChildNodeDefDiffBuilder(CollectionUtils.union(oldDef.getRawNodes().values(), oldDef.getRawUnstructuredNodes().values()), CollectionUtils.union(newDef.getRawNodes().values(), newDef.getRawUnstructuredNodes().values()));
            this.childNodeDefDiffs.addAll(childNodeDefDiffBuilder.getChildItemDefDiffs());
            tmpType = childNodeDefDiffBuilder.getMaxType();
            if (tmpType.compareTo(this.type) > 0) {
                this.type = tmpType;
            }
        }

        private static String getPropertyName(ExtendedPropertyDefinition p) {
            return "*".equals(p.getName()) ? p.getName() + p.getRequiredType() + p.isMultiple() : p.getName();
        }

        public static NodeTypeDefDiff create(ExtendedNodeType oldDef, ExtendedNodeType newDef) {
            if (oldDef == null || newDef == null) {
                throw new IllegalArgumentException("arguments can not be null");
            }
            if (!oldDef.getName().equals(newDef.getName())) {
                throw new IllegalArgumentException("at least node type names must be matching");
            }
            return new NodeTypeDefDiff(oldDef, newDef);
        }

        public boolean isModified() {
            return this.type != DiffType.NONE;
        }

        public boolean isTrivial() {
            return this.type == DiffType.TRIVIAL;
        }

        public boolean isMajor() {
            return this.type == DiffType.MAJOR;
        }

        public DiffType getType() {
            return this.type;
        }

        public DiffType mixinFlagDiff() {
            return this.oldDef.isMixin() != this.newDef.isMixin() ? DiffType.MAJOR : DiffType.NONE;
        }

        public DiffType abstractFlagDiff() {
            return this.oldDef.isAbstract() && !this.newDef.isAbstract() ? DiffType.MAJOR : DiffType.NONE;
        }

        public DiffType supertypesDiff() {
            HashSet<String> oldSupertypes = new HashSet<String>(Arrays.asList(this.oldDef.getDeclaredSupertypeNames()));
            oldSupertypes.remove("mix:referenceable");
            HashSet<String> newSupertypes = new HashSet<String>(Arrays.asList(this.newDef.getDeclaredSupertypeNames()));
            newSupertypes.remove("mix:referenceable");
            ArrayList result = new ArrayList();
            SetUtils.SetView addedSupertypes = SetUtils.difference(newSupertypes, oldSupertypes);
            Arrays.stream(this.newDef.getPropertyDefinitions()).filter(arg_0 -> NodeTypeDefDiff.lambda$supertypesDiff$2((Set)addedSupertypes, arg_0)).map(propDef -> new PropDefDiff(null, (ExtendedPropertyDefinition)propDef)).forEach(result::add);
            SetUtils.SetView removedSupertypes = SetUtils.difference(oldSupertypes, newSupertypes);
            Arrays.stream(this.oldDef.getPropertyDefinitions()).filter(arg_0 -> NodeTypeDefDiff.lambda$supertypesDiff$4((Set)removedSupertypes, arg_0)).map(propDef -> new PropDefDiff((ExtendedPropertyDefinition)propDef, null)).forEach(result::add);
            return ChildItemDefDiffBuilder.getMaxType(result);
        }

        public String toString() {
            Object[] childNodeDefDiffsArray;
            Object[] propDefDiffsArray;
            ToStringBuilder stringBuilder = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("nodeTypeName", (Object)this.oldDef.getName()).append("type", (Object)this.type);
            if (this.supertypesDiff() != DiffType.NONE) {
                stringBuilder.append("supertypesDiff", (Object)this.supertypesDiff());
            }
            if (this.mixinFlagDiff() != DiffType.NONE) {
                stringBuilder.append("mixinFlagDiff", (Object)this.mixinFlagDiff());
            }
            if (this.abstractFlagDiff() != DiffType.NONE) {
                stringBuilder.append("abstractFlagDiff", (Object)this.abstractFlagDiff());
            }
            if ((propDefDiffsArray = this.propDefDiffs.stream().filter(p -> p.getType() != DiffType.NONE).toArray()).length > 0) {
                stringBuilder.append("propDefDiffs", propDefDiffsArray, true);
            }
            if ((childNodeDefDiffsArray = this.childNodeDefDiffs.stream().filter(p -> p.getType() != DiffType.NONE).toArray()).length > 0) {
                stringBuilder.append("childNodeDefDiffs", childNodeDefDiffsArray, true);
            }
            return stringBuilder.toString();
        }

        private static /* synthetic */ boolean lambda$supertypesDiff$4(Set removedSupertypes, ExtendedPropertyDefinition propDef) {
            return removedSupertypes.contains(propDef.getDeclaringNodeType().getName());
        }

        private static /* synthetic */ boolean lambda$supertypesDiff$2(Set addedSupertypes, ExtendedPropertyDefinition propDef) {
            return addedSupertypes.contains(propDef.getDeclaringNodeType().getName());
        }

        private static class PropDefDiffBuilder
        extends ChildItemDefDiffBuilder<ExtendedPropertyDefinition, PropDefDiff> {
            private PropDefDiffBuilder(Collection<ExtendedPropertyDefinition> defs1, Collection<ExtendedPropertyDefinition> defs2) {
                super(defs1, defs2);
            }

            @Override
            Object createItemDefinitionId(ExtendedPropertyDefinition def) {
                return new PropertyDefinitionId(def);
            }

            @Override
            PropDefDiff createChildItemDefDiff(ExtendedPropertyDefinition def1, ExtendedPropertyDefinition def2) {
                return new PropDefDiff(def1, def2);
            }
        }

        private static class ChildNodeDefDiffBuilder
        extends ChildItemDefDiffBuilder<ExtendedNodeDefinition, ChildNodeDefDiff> {
            private ChildNodeDefDiffBuilder(Collection<ExtendedNodeDefinition> defs1, Collection<ExtendedNodeDefinition> defs2) {
                super(defs1, defs2);
            }

            @Override
            Object createItemDefinitionId(ExtendedNodeDefinition def) {
                return new NodeDefinitionId(def);
            }

            @Override
            ChildNodeDefDiff createChildItemDefDiff(ExtendedNodeDefinition def1, ExtendedNodeDefinition def2) {
                return new ChildNodeDefDiff(def1, def2);
            }
        }

        private static class NodeDefinitionId {
            private final ExtendedNodeType declaringNodeType;
            private final String name;

            private NodeDefinitionId(ExtendedNodeDefinition def) {
                this.declaringNodeType = def.getDeclaringNodeType();
                this.name = def.getName();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof NodeDefinitionId) {
                    NodeDefinitionId other = (NodeDefinitionId)obj;
                    return this.declaringNodeType.equals(other.declaringNodeType) && this.name.equals(other.name);
                }
                return false;
            }

            public int hashCode() {
                int h = 17;
                h = 37 * h + this.declaringNodeType.hashCode();
                h = 37 * h + this.name.hashCode();
                return h;
            }
        }

        private static class PropertyDefinitionId {
            private final ExtendedNodeType declaringNodeType;
            private final String name;

            private PropertyDefinitionId(ExtendedPropertyDefinition def) {
                this.declaringNodeType = def.getDeclaringNodeType();
                this.name = def.getName();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof PropertyDefinitionId) {
                    PropertyDefinitionId other = (PropertyDefinitionId)obj;
                    return this.declaringNodeType.equals(other.declaringNodeType) && this.name.equals(other.name);
                }
                return false;
            }

            public int hashCode() {
                int h = 17;
                h = 37 * h + this.declaringNodeType.hashCode();
                h = 37 * h + this.name.hashCode();
                return h;
            }
        }

        private static class ChildNodeDefDiff
        extends ChildItemDefDiff<ExtendedNodeDefinition> {
            private ChildNodeDefDiff(ExtendedNodeDefinition oldDef, ExtendedNodeDefinition newDef) {
                super(oldDef, newDef);
            }

            @Override
            protected void init() {
                super.init();
                if (this.isModified() && this.type == DiffType.TRIVIAL) {
                    boolean b2;
                    boolean b1 = ((ExtendedNodeDefinition)this.getOldDef()).allowsSameNameSiblings();
                    if (b1 != (b2 = ((ExtendedNodeDefinition)this.getNewDef()).allowsSameNameSiblings()) && !b2) {
                        this.type = DiffType.MAJOR;
                    }
                    if (this.type == DiffType.TRIVIAL) {
                        HashSet<String> s1 = new HashSet<String>(Arrays.asList(((ExtendedNodeDefinition)this.getOldDef()).getRequiredPrimaryTypeNames()));
                        HashSet<String> s2 = new HashSet<String>(Arrays.asList(((ExtendedNodeDefinition)this.getNewDef()).getRequiredPrimaryTypeNames()));
                        s1.remove("nt:base");
                        s2.remove("nt:base");
                        if (!s1.equals(s2)) {
                            this.type = s1.containsAll(s2) ? DiffType.TRIVIAL : DiffType.MAJOR;
                        }
                    }
                }
            }
        }

        private static class PropDefDiff
        extends ChildItemDefDiff<ExtendedPropertyDefinition> {
            private PropDefDiff(ExtendedPropertyDefinition oldDef, ExtendedPropertyDefinition newDef) {
                super(oldDef, newDef);
            }

            @Override
            protected void init() {
                super.init();
                if (this.isModified() && this.type == DiffType.TRIVIAL) {
                    HashSet<String> set2;
                    HashSet<String> set1 = new HashSet<String>(Arrays.asList(((ExtendedPropertyDefinition)this.getOldDef()).getValueConstraints()));
                    if (!set1.equals(set2 = new HashSet<String>(Arrays.asList(((ExtendedPropertyDefinition)this.getNewDef()).getValueConstraints())))) {
                        this.type = set2.isEmpty() ? DiffType.TRIVIAL : (set1.isEmpty() ? DiffType.MAJOR : (set2.containsAll(set1) ? DiffType.TRIVIAL : DiffType.MAJOR));
                    }
                    if (((ExtendedPropertyDefinition)this.getOldDef()).getRequiredType() != ((ExtendedPropertyDefinition)this.getNewDef()).getRequiredType() || ((ExtendedPropertyDefinition)this.getOldDef()).isInternationalized() != ((ExtendedPropertyDefinition)this.getNewDef()).isInternationalized()) {
                        this.type = DiffType.MAJOR;
                        return;
                    }
                    if (this.type == DiffType.TRIVIAL) {
                        boolean b2;
                        boolean b1;
                        int t2;
                        int t1 = ((ExtendedPropertyDefinition)this.getOldDef()).getRequiredType();
                        if (t1 != (t2 = ((ExtendedPropertyDefinition)this.getNewDef()).getRequiredType())) {
                            this.type = t2 == 0 ? DiffType.TRIVIAL : DiffType.MAJOR;
                        }
                        if ((b1 = ((ExtendedPropertyDefinition)this.getOldDef()).isMultiple()) != (b2 = ((ExtendedPropertyDefinition)this.getNewDef()).isMultiple())) {
                            this.type = b2 ? DiffType.TRIVIAL : DiffType.MAJOR;
                        }
                    }
                }
            }

            @Override
            boolean isModified() {
                if (this.oldDef != null && this.newDef != null) {
                    HashSet<String> set1 = new HashSet<String>(Arrays.asList(((ExtendedPropertyDefinition)this.getOldDef()).getValueConstraints()));
                    HashSet<String> set2 = new HashSet<String>(Arrays.asList(((ExtendedPropertyDefinition)this.getNewDef()).getValueConstraints()));
                    return super.isModified() || ((ExtendedPropertyDefinition)this.getOldDef()).getRequiredType() != ((ExtendedPropertyDefinition)this.getNewDef()).getRequiredType() || ((ExtendedPropertyDefinition)this.getOldDef()).isMultiple() != ((ExtendedPropertyDefinition)this.getNewDef()).isMultiple() || ((ExtendedPropertyDefinition)this.getOldDef()).isInternationalized() != ((ExtendedPropertyDefinition)this.getNewDef()).isInternationalized() || !set1.equals(set2);
                }
                return false;
            }
        }

        private static abstract class ChildItemDefDiff<T extends ExtendedItemDefinition> {
            protected final T oldDef;
            protected final T newDef;
            protected DiffType type;

            private ChildItemDefDiff(T oldDef, T newDef) {
                this.oldDef = oldDef;
                this.newDef = newDef;
                this.init();
            }

            protected void init() {
                this.type = DiffType.NONE;
                if (this.isAdded()) {
                    this.type = ((ExtendedItemDefinition)this.newDef).isMandatory() ? DiffType.MAJOR : DiffType.TRIVIAL;
                } else if (this.isRemoved()) {
                    this.type = DiffType.MAJOR;
                } else if (this.isModified()) {
                    this.type = ((ExtendedItemDefinition)this.oldDef).isMandatory() != ((ExtendedItemDefinition)this.newDef).isMandatory() && ((ExtendedItemDefinition)this.newDef).isMandatory() ? DiffType.MAJOR : (!((ExtendedItemDefinition)this.oldDef).getName().equals("*") && ((ExtendedItemDefinition)this.newDef).getName().equals("*") ? DiffType.TRIVIAL : (!((ExtendedItemDefinition)this.oldDef).getName().equals(((ExtendedItemDefinition)this.newDef).getName()) ? DiffType.MAJOR : DiffType.TRIVIAL));
                }
            }

            T getOldDef() {
                return this.oldDef;
            }

            T getNewDef() {
                return this.newDef;
            }

            DiffType getType() {
                return this.type;
            }

            boolean isAdded() {
                return this.oldDef == null && this.newDef != null;
            }

            boolean isRemoved() {
                return this.oldDef != null && this.newDef == null;
            }

            boolean isModified() {
                return this.oldDef != null && this.newDef != null && (!((ExtendedItemDefinition)this.oldDef).equals(this.newDef) || ((ExtendedItemDefinition)this.oldDef).isMandatory() != ((ExtendedItemDefinition)this.newDef).isMandatory());
            }

            public String toString() {
                String operationString = this.isAdded() ? "ADDED" : (this.isModified() ? "MODIFIED" : (this.isRemoved() ? "REMOVED" : "NONE"));
                return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("itemName", (Object)(this.newDef != null ? ((ExtendedItemDefinition)this.newDef).getName() : ((ExtendedItemDefinition)this.oldDef).getName())).append("type", (Object)this.type).append("operation", (Object)operationString).toString();
            }
        }

        private static abstract class ChildItemDefDiffBuilder<T extends ExtendedItemDefinition, V extends ChildItemDefDiff<T>> {
            private final List<V> childItemDefDiffs = new ArrayList<V>();

            private ChildItemDefDiffBuilder(Collection<T> oldDefs, Collection<T> newDefs) {
                this.buildChildItemDefDiffs(this.collectChildNodeDefs(oldDefs), this.collectChildNodeDefs(newDefs));
            }

            private void buildChildItemDefDiffs(Map<Object, List<T>> oldDefs, Map<Object, List<T>> newDefs) {
                for (Object defId : oldDefs.keySet()) {
                    this.childItemDefDiffs.addAll(this.getChildItemDefDiffs(oldDefs.get(defId), newDefs.get(defId)));
                    newDefs.remove(defId);
                }
                for (Object defId : newDefs.keySet()) {
                    this.childItemDefDiffs.addAll(this.getChildItemDefDiffs(null, newDefs.get(defId)));
                }
            }

            private Map<Object, List<T>> collectChildNodeDefs(Collection<T> defs) {
                HashMap<Object, List<T>> result = new HashMap<Object, List<T>>();
                for (ExtendedItemDefinition def : defs) {
                    Object defId = this.createItemDefinitionId(def);
                    List list = result.computeIfAbsent(defId, k -> new ArrayList());
                    list.add(def);
                }
                return result;
            }

            abstract Object createItemDefinitionId(T var1);

            abstract V createChildItemDefDiff(T var1, T var2);

            Collection<V> getChildItemDefDiffs(List<T> defs1, List<T> defs2) {
                defs1 = defs1 != null ? defs1 : Collections.emptyList();
                defs2 = defs2 != null ? defs2 : Collections.emptyList();
                ArrayList<Object> diffs = new ArrayList<Object>();
                for (ExtendedItemDefinition def1 : defs1) {
                    for (ExtendedItemDefinition def2 : defs2) {
                        diffs.add(this.createChildItemDefDiff(def1, def2));
                    }
                }
                if (defs2.size() < defs1.size()) {
                    for (ExtendedItemDefinition def1 : defs1) {
                        diffs.add(this.createChildItemDefDiff(def1, null));
                    }
                }
                if (defs1.size() < defs2.size()) {
                    for (ExtendedItemDefinition def2 : defs2) {
                        diffs.add(this.createChildItemDefDiff(null, def2));
                    }
                }
                diffs.sort(Comparator.comparing(ChildItemDefDiff::getType));
                int size = Math.max(defs1.size(), defs2.size());
                int allowedNewNull = defs1.size() - defs2.size();
                int allowedOldNull = defs2.size() - defs1.size();
                ArrayList<ChildItemDefDiff> results = new ArrayList<ChildItemDefDiff>();
                for (ChildItemDefDiff childItemDefDiff : diffs) {
                    if (!this.alreadyMatched(results, childItemDefDiff.getNewDef(), childItemDefDiff.getOldDef(), allowedNewNull, allowedOldNull)) {
                        results.add(childItemDefDiff);
                        if (childItemDefDiff.getNewDef() == null) {
                            --allowedNewNull;
                        }
                        if (childItemDefDiff.getOldDef() == null) {
                            --allowedOldNull;
                        }
                    }
                    if (results.size() != size) continue;
                    break;
                }
                return results;
            }

            private boolean alreadyMatched(List<V> result, T newDef, T oldDef, int allowedNewNull, int allowedOldNull) {
                boolean containsNewDef = false;
                boolean containsOldDef = false;
                for (ChildItemDefDiff d : result) {
                    if (d.getNewDef() != null && ((ExtendedItemDefinition)d.getNewDef()).equals(newDef)) {
                        containsNewDef = true;
                        break;
                    }
                    if (d.getOldDef() == null || !((ExtendedItemDefinition)d.getOldDef()).equals(oldDef)) continue;
                    containsOldDef = true;
                    break;
                }
                if (oldDef == null && allowedOldNull < 1) {
                    containsOldDef = true;
                }
                if (newDef == null && allowedNewNull < 1) {
                    containsNewDef = true;
                }
                return containsNewDef || containsOldDef;
            }

            List<V> getChildItemDefDiffs() {
                return this.childItemDefDiffs;
            }

            DiffType getMaxType() {
                return ChildItemDefDiffBuilder.getMaxType(this.childItemDefDiffs);
            }

            static DiffType getMaxType(List<? extends ChildItemDefDiff> childItemDefDiffs) {
                return childItemDefDiffs.stream().map(ChildItemDefDiff::getType).max(Comparator.naturalOrder()).orElse(DiffType.NONE);
            }
        }
    }

    public static enum DiffType {
        NONE,
        TRIVIAL,
        MAJOR;

    }
}

