/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.spi.impl;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.jahia.osgi.BundleUtils;

public class CallableProxy<T>
implements Callable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final String bundleKey;
    private final Serializable data;

    public CallableProxy(String className, String bundleKey, Serializable data) {
        this.className = className;
        this.bundleKey = bundleKey;
        this.data = data;
    }

    @Override
    public T call() throws Exception {
        ClassLoader classLoader = BundleUtils.createBundleClassLoader(BundleUtils.getBundleBySymbolicName(this.bundleKey, null));
        if (this.data != null) {
            Callable c = (Callable)classLoader.loadClass(this.className).getConstructors()[0].newInstance(this.data);
            return (T)c.call();
        }
        Callable c = (Callable)classLoader.loadClass(this.className).newInstance();
        return (T)c.call();
    }
}

