/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.cookie.IgnoreCookieSpecFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.taglibs.standard.util.UrlUtil;
import org.jahia.services.notification.ProxyAddressSelector;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.StringResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class HttpClientService
implements ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientService.class);
    private static final String URL_NOT_PROVIDED = "Provided URL is null";
    private PoolingHttpClientConnectionManager connManager;
    private CloseableHttpClient fallbackHttpClient;
    private Map<String, CloseableHttpClient> httpClients = new HashMap<String, CloseableHttpClient>(3);
    private ServletContext servletContext;

    public void init() {
        CloseableHttpClient client;
        this.connManager = new PoolingHttpClientConnectionManager();
        this.connManager.setMaxTotal(20);
        this.connManager.setDefaultMaxPerRoute(2);
        this.httpClients.put(null, this.getNewHttpClientBuilder().build());
        if (StringUtils.isNotEmpty((String)System.getProperty("https.proxyHost"))) {
            this.fallbackHttpClient = client = this.initHttpClient(this.getNewHttpClientBuilder(), "https");
        }
        if (StringUtils.isNotEmpty((String)System.getProperty("http.proxyHost"))) {
            client = this.initHttpClient(this.getNewHttpClientBuilder(), "http");
            if (this.fallbackHttpClient == null) {
                this.fallbackHttpClient = client;
            }
        }
    }

    private CloseableHttpClient initHttpClient(HttpClientBuilder builder, String protocol) {
        String host = System.getProperty(protocol + ".proxyHost");
        int port = Integer.getInteger(protocol + ".proxyPort", -1);
        HttpHost proxy = new HttpHost(protocol, host, port);
        builder.setProxy(proxy);
        String key = host + ":" + port;
        BasicCredentialsProvider credsProvider = null;
        String user = System.getProperty(protocol + ".proxyUser");
        if (StringUtils.isNotEmpty((String)user)) {
            credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(user, System.getProperty(protocol + ".proxyPassword").toCharArray()));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Initialized HttpClient for {} protocol using proxy {} {} credentials", new Object[]{protocol.toUpperCase(), key, credsProvider != null ? "with" : "without"});
        }
        CloseableHttpClient client = builder.build();
        this.httpClients.put(key, client);
        return client;
    }

    private HttpClientBuilder getNewHttpClientBuilder() {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setDefaultCookieSpecRegistry(name -> new IgnoreCookieSpecFactory());
        builder.setConnectionManager((HttpClientConnectionManager)this.connManager);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(15000L, TimeUnit.MILLISECONDS).setResponseTimeout(60000L, TimeUnit.MILLISECONDS).build();
        builder.setDefaultRequestConfig(config);
        return builder;
    }

    public static boolean isAbsoluteUrl(String url) {
        return UrlUtil.isAbsoluteUrl((String)url);
    }

    public String executeGet(String url) throws IllegalArgumentException {
        return this.executeGet(url, null);
    }

    public String executeGet(String url, Map<String, String> headers) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException(URL_NOT_PROVIDED);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the URL {} using GET method", (Object)url);
        }
        String content = null;
        HttpGet httpMethod = new HttpGet(url);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpMethod.addHeader(header.getKey(), (Object)header.getValue());
            }
        }
        try (CloseableHttpResponse response = this.getHttpClient(url).execute((ClassicHttpRequest)httpMethod);){
            if (response.getCode() == 200) {
                content = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.warn("Connection to URL: {} failed with status {}", (Object)url, (Object)response.getCode());
            }
        }
        catch (IOException | ParseException e) {
            logger.error("Unable to get the content of the URL: {}. Cause: {}", new Object[]{url, e.getMessage(), e});
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved {} characters as a response", (Object)(content != null ? content.length() : 0));
            if (logger.isTraceEnabled()) {
                logger.trace("Content: {}", (Object)content);
            }
        }
        return content;
    }

    public String executePost(String url, Map<String, String> parameters, Map<String, String> headers) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException(URL_NOT_PROVIDED);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the URL {} using POST method with parameters {}", (Object)url, parameters);
        }
        String content = null;
        HttpPost httpMethod = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                nvps.add(new BasicNameValuePair(param.getKey(), param.getValue()));
            }
        }
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpMethod.addHeader(header.getKey(), (Object)header.getValue());
            }
        }
        httpMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        try (CloseableHttpResponse response = this.getHttpClient(url).execute((ClassicHttpRequest)httpMethod);){
            if (response.getCode() == 200) {
                content = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.warn("Connection to URL: {} failed with status {}", (Object)url, (Object)response.getCode());
            }
        }
        catch (IOException | ParseException e) {
            logger.error("Unable to get the content of the URL: {}. Cause: {}", new Object[]{url, e.getMessage(), e});
        }
        this.logContent(content);
        return content;
    }

    public String getAbsoluteResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException(URL_NOT_PROVIDED);
        }
        if (!HttpClientService.isAbsoluteUrl(url)) {
            throw new IllegalArgumentException("Cannot handle non-absolute URL: " + url);
        }
        return this.executeGet(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContextResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException(URL_NOT_PROVIDED);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the context resource: {}", (Object)url);
        }
        String content = null;
        InputStream is = this.servletContext.getResourceAsStream(url);
        if (is != null) {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)is, (Writer)writer, (String)SettingsBean.getInstance().getCharacterEncoding());
                content = writer.toString();
            }
            catch (IOException e) {
                logger.warn("Error reading content of the resource {}. Cause: {}", new Object[]{url, e.getMessage(), e});
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        } else {
            logger.warn("Unable to find context resource at path {}", (Object)url);
        }
        this.logContent(content);
        return content;
    }

    @Deprecated(since="7.1.2.3", forRemoval=true)
    public HttpClient getHttpClient() {
        return this.getHttpClient(null);
    }

    public CloseableHttpClient getHttpClient(String url) {
        CloseableHttpClient selectedClient = null;
        if (url == null) {
            selectedClient = this.fallbackHttpClient;
        } else if (this.httpClients.size() > 1) {
            try {
                String key = ProxyAddressSelector.getProxyForUrl(url);
                logger.debug("Using proxy address {} for URL {}", (Object)key, (Object)url);
                selectedClient = this.httpClients.get(key);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (selectedClient == null) {
            selectedClient = this.httpClients.get(null);
        }
        return selectedClient;
    }

    public RequestConfig.Builder getRequestConfigBuilder(HttpClient httpClient) {
        if (httpClient instanceof Configurable) {
            RequestConfig config = ((Configurable)httpClient).getConfig();
            return RequestConfig.copy((RequestConfig)config);
        }
        return RequestConfig.custom();
    }

    public String getResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException(URL_NOT_PROVIDED);
        }
        return HttpClientService.isAbsoluteUrl(url) ? this.getAbsoluteResourceAsString(url) : this.getContextResourceAsString(url);
    }

    public String getResourceAsString(String url, HttpServletRequest request, HttpServletResponse response) throws IllegalArgumentException {
        String content;
        block9: {
            if (StringUtils.isEmpty((String)url)) {
                throw new IllegalArgumentException(URL_NOT_PROVIDED);
            }
            if (HttpClientService.isAbsoluteUrl(url)) {
                return this.getAbsoluteResourceAsString(url);
            }
            if (!url.startsWith("/")) {
                throw new IllegalArgumentException("Provided relative URL does not start with a '/'");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Asked to get content from the URL: {}", (Object)url);
            }
            content = null;
            RequestDispatcher rd = request.getRequestDispatcher(url);
            if (rd != null) {
                StringResponseWrapper wrapper = new StringResponseWrapper(response);
                try {
                    rd.include((ServletRequest)request, (ServletResponse)wrapper);
                    if (wrapper.getStatus() < 200 || wrapper.getStatus() > 299) {
                        logger.warn("Unable to get the content of the resource {}. Got response status code: {}", (Object)url, (Object)wrapper.getStatus());
                        break block9;
                    }
                    content = wrapper.getString();
                }
                catch (Exception e) {
                    logger.warn("Unable to get the content of the resource {}. Cause: {}", new Object[]{url, e.getMessage(), e});
                }
            } else {
                logger.warn("Unable to get a RequestDispatcher for the path {}", (Object)url);
            }
        }
        this.logContent(content);
        return content;
    }

    private void logContent(String content) {
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved {} characters as a response", (Object)(content != null ? content.length() : 0));
            if (logger.isTraceEnabled()) {
                logger.trace("Content: {}", (Object)content);
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void shutdown() {
        logger.info("Shutting down HttpClient...");
        try {
            this.connManager.close();
        }
        catch (Exception e) {
            logger.warn("Error shutting down HttpClient. Cause: " + e.getMessage(), (Throwable)e);
        }
        logger.info("...done");
    }
}

