/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.observation;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jahia.services.observation.JahiaEventListener;
import org.jahia.services.observation.JahiaEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaEventServiceImpl
implements JahiaEventService {
    private static final Logger logger = LoggerFactory.getLogger(JahiaEventServiceImpl.class);
    private final Set<JahiaEventListener<? extends EventObject>> allEventListeners = ConcurrentHashMap.newKeySet();
    private final Map<Class<? extends EventObject>, Set<JahiaEventListener<? extends EventObject>>> listenersByTypeCache = new ConcurrentHashMap<Class<? extends EventObject>, Set<JahiaEventListener<? extends EventObject>>>();

    @Override
    public void addEventListener(JahiaEventListener<? extends EventObject> listener) {
        if (listener == null) {
            return;
        }
        this.allEventListeners.add(listener);
        this.listenersByTypeCache.clear();
    }

    @Override
    public void removeEventListener(JahiaEventListener<? extends EventObject> listener) {
        if (listener == null) {
            return;
        }
        this.allEventListeners.remove(listener);
        this.listenersByTypeCache.clear();
    }

    Set<JahiaEventListener<? extends EventObject>> getApplicationListeners(EventObject event) {
        return this.listenersByTypeCache.computeIfAbsent(event.getClass(), this::resolveTypeListeners);
    }

    private Set<JahiaEventListener<? extends EventObject>> resolveTypeListeners(Class<? extends EventObject> eventClass) {
        return this.allEventListeners.stream().filter(listener -> {
            Class<E>[] acceptedEventTypes = listener.getEventTypes();
            return Stream.of(acceptedEventTypes).anyMatch(eventType -> eventType.isAssignableFrom(eventClass));
        }).collect(Collectors.toSet());
    }

    @Override
    public void publishEvent(EventObject event) {
        this.getApplicationListeners(event).forEach(listener -> {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                logger.error("Error thrown in listener", (Throwable)e);
            }
        });
    }
}

