/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.preferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaPreferencesQueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(JahiaPreferencesQueryHelper.class);

    public static String getSimpleSQL(String prefName) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("j:prefName", prefName);
        return JahiaPreferencesQueryHelper.convertToSQL(properties);
    }

    public static String convertToSQL(Map<String, Object> propertiesMap) {
        StringBuilder prefPath = new StringBuilder();
        if (propertiesMap != null && !propertiesMap.isEmpty()) {
            Iterator<String> propertiesIterator = propertiesMap.keySet().iterator();
            boolean isFirstProperty = true;
            while (propertiesIterator.hasNext()) {
                String propertyName = propertiesIterator.next();
                Object propertyValue = propertiesMap.get(propertyName);
                if (propertyValue == null) continue;
                if (isFirstProperty) {
                    isFirstProperty = false;
                } else {
                    prefPath.append(" and ");
                }
                prefPath.append("p.[").append(propertyName).append("]='").append(propertyValue.toString()).append("'");
            }
        }
        return prefPath.toString();
    }

    public static String convertToSQLPureStringProperties(Map<String, String> propertiesMap) {
        StringBuilder prefPath = new StringBuilder();
        if (propertiesMap != null && !propertiesMap.isEmpty()) {
            Iterator<String> propertiesIterator = propertiesMap.keySet().iterator();
            boolean isFirstProperty = true;
            while (propertiesIterator.hasNext()) {
                String propertyName = propertiesIterator.next();
                String propertyvalue = propertiesMap.get(propertyName);
                if (propertyvalue == null) continue;
                if (isFirstProperty) {
                    isFirstProperty = false;
                } else {
                    prefPath.append(" and ");
                }
                prefPath.append("p.[").append(propertyName).append("]='").append(propertyvalue).append("'");
            }
        }
        return prefPath.toString();
    }
}

