/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.preferences.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.preferences.JahiaPreference;
import org.jahia.services.preferences.JahiaPreferencesProvider;
import org.jahia.services.preferences.JahiaPreferencesQueryHelper;
import org.jahia.services.preferences.exception.JahiaPreferenceNotDefinedAttributeException;
import org.jahia.services.preferences.exception.JahiaPreferenceNotDefinedPropertyException;
import org.jahia.services.preferences.exception.JahiaPreferencesNotValidException;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaPreferencesJCRProviders<T extends JCRNodeWrapper>
implements JahiaPreferencesProvider<T> {
    private static final Logger logger = LoggerFactory.getLogger(JahiaPreferencesJCRProviders.class);
    private static final String PREFERENCE = "preference";
    private String type;
    private String nodeType;
    private JCRSessionFactory sessionFactory;

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public JCRSessionFactory getJCRStoreService() {
        return this.sessionFactory;
    }

    public void setJCRSessionFactory(JCRSessionFactory jcrStoreService) {
        this.sessionFactory = jcrStoreService;
    }

    @Override
    public JahiaPreference createJahiaPreferenceNode(Principal principal) {
        try {
            Node preferencesNode;
            if (logger.isDebugEnabled()) {
                logger.debug("Create Jahia Preference Node [" + String.valueOf(principal) + "]");
            }
            if ((preferencesNode = this.getProviderPreferencesNode(principal)) != null) {
                Node newChildNode = preferencesNode.addNode(PREFERENCE, this.nodeType);
                return this.createJahiaPreference(principal, newChildNode);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Preferences node not found for user [" + String.valueOf(principal) + "]");
            }
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private JahiaPreference createJahiaPreference(Principal p, Node node) {
        try {
            JahiaPreference<JCRNodeWrapper> pref = new JahiaPreference<JCRNodeWrapper>((JCRNodeWrapper)node);
            pref.setPrincipal(p);
            return pref;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean validate(JahiaPreference jahiaPreference) throws JahiaPreferencesNotValidException {
        return true;
    }

    @Override
    public JahiaPreference getJahiaPreference(Principal principal, String sqlConstraint) {
        return this.getJahiaPreference(principal, sqlConstraint, false);
    }

    @Override
    public JahiaPreference getJahiaPreference(Principal principal, String sqlConstraint, boolean notNull) {
        List<JahiaPreference<T>> jahiaPreferences;
        if (logger.isDebugEnabled()) {
            logger.debug("Get preference -" + this.getType() + " - " + principal.getName() + " - " + sqlConstraint + "- ");
        }
        if ((jahiaPreferences = this.findJahiaPreferences(principal, sqlConstraint)) != null && !jahiaPreferences.isEmpty()) {
            return jahiaPreferences.get(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Preference - " + sqlConstraint + "- not found.");
        }
        if (notNull) {
            return this.createJahiaPreferenceNode(principal);
        }
        return null;
    }

    @Override
    public List<JahiaPreference<T>> getJahiaAllPreferences(Principal principal) {
        return this.findJahiaPreferences(principal, null);
    }

    @Override
    public List<JahiaPreference<T>> findJahiaPreferences(Principal principal, String sqlConstraint) {
        NodeIterator ni = this.findPreferenceNodeByJahiaPreferenceSQL(principal, sqlConstraint);
        if (ni == null) {
            return new ArrayList<JahiaPreference<T>>();
        }
        ArrayList<JahiaPreference<T>> jahiaPreferenceList = new ArrayList<JahiaPreference<T>>();
        while (ni.hasNext()) {
            Node currentPrefNode = ni.nextNode();
            jahiaPreferenceList.add(this.createJahiaPreference(principal, currentPrefNode));
        }
        return jahiaPreferenceList;
    }

    @Override
    public void deleteJahiaPreference(Principal principal, String sqlConstraint) throws JahiaPreferenceNotDefinedAttributeException {
        NodeIterator ni = this.findPreferenceNodeByJahiaPreferenceSQL(principal, sqlConstraint);
        while (ni.hasNext()) {
            try {
                Node next = ni.nextNode();
                next.remove();
            }
            catch (RepositoryException e) {
                logger.error("Error while deleting preference " + sqlConstraint, (Throwable)e);
            }
        }
        try {
            this.getProviderPreferencesNode(principal).save();
        }
        catch (RepositoryException e) {
            logger.error("Error while deleting preference " + sqlConstraint, (Throwable)e);
        }
    }

    @Override
    public void deleteJahiaPreference(JahiaPreference jahiaPreference) {
        if (logger.isDebugEnabled()) {
            logger.debug("Delete Jahia Preference");
        }
        if (jahiaPreference == null) {
            return;
        }
        try {
            JCRNodeWrapper parentNode = jahiaPreference.getNode().getParent();
            jahiaPreference.getNode().remove();
            parentNode.save();
        }
        catch (RepositoryException re) {
            logger.error("Error while deleting preference " + String.valueOf(jahiaPreference), (Throwable)re);
        }
    }

    @Override
    public void setJahiaPreference(JahiaPreference jahiaPreference) {
        if (jahiaPreference == null) {
            logger.warn("Can't set a null jahia preference");
            return;
        }
        try {
            Object node = jahiaPreference.getNode();
            node.getParent().save();
            if (logger.isDebugEnabled()) {
                logger.debug("Jahia preference [" + String.valueOf(jahiaPreference) + "] saved.");
                logger.debug("[" + node.getPath() + JahiaPreferencesQueryHelper.convertToSQLPureStringProperties(node.getPropertiesAsString()) + "] saved.");
            }
        }
        catch (RepositoryException re) {
            logger.error("Error while setting preference " + String.valueOf(jahiaPreference), (Throwable)re);
        }
    }

    @Override
    public void setJahiaPreferenceByMaps(Map<String, String> jahiaPreferenceAttributes) throws JahiaPreferenceNotDefinedAttributeException, JahiaPreferenceNotDefinedPropertyException, JahiaPreferencesNotValidException {
    }

    @Override
    public void deleteAllPreferencesByPrincipal(Principal principal) {
        try {
            JCRNodeWrapper preferencesNode = this.getPreferencesNode(principal);
            if (preferencesNode != null) {
                JCRNodeWrapper ppNode = this.getPreferencesNode(principal).getNode(this.getType());
                if (ppNode != null) {
                    ppNode.remove();
                }
                preferencesNode.save();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private JCRNodeWrapper getPreferencesNode(Principal principal) {
        String nodePath = this.getPreferencesNodePath(principal);
        try {
            return this.sessionFactory.getCurrentUserSession().getNode(nodePath);
        }
        catch (Exception e) {
            logger.error("Node path = [" + nodePath + "]");
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Node getProviderPreferencesNode(Principal principal) {
        try {
            JCRNodeWrapper preferences = this.getPreferencesNode(principal);
            if (!preferences.hasNode(this.getType())) {
                if (!preferences.isCheckedOut()) {
                    preferences.checkout();
                }
                JCRNodeWrapper p = preferences.addNode(this.getType(), "jnt:preferenceProvider");
                preferences.save();
                return p;
            }
            return preferences.getNode(this.getType());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getPreferenceProviderNodePath(Principal principal) {
        return this.getPreferencesNodePath(principal) + "/" + this.getType();
    }

    private String getPreferencesNodePath(Principal principal) {
        if (principal instanceof JahiaUser) {
            String principalName = ((JahiaUser)principal).getLocalPath();
            return principalName + "/preferences";
        }
        return "";
    }

    private NodeIterator findPreferenceNodeByJahiaPreferenceSQL(Principal p, String sqlConstraint) {
        String path = this.getPreferenceProviderNodePath(p);
        return this.findNodeIteratorBySQL(p, "select * from [" + this.getNodeType() + "] as p where ischildnode(p,[" + JCRContentUtils.sqlEncode(path) + "])" + (String)(sqlConstraint != null ? " and " + sqlConstraint : ""));
    }

    private NodeIterator findNodeIteratorBySQL(Principal p, String sqlRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug("Find node by xpath[ " + sqlRequest + " ]");
        }
        if (p instanceof JahiaGroup) {
            logger.warn("Preference provider not implemented for Group");
            return null;
        }
        try {
            QueryManagerWrapper queryManager = this.sessionFactory.getCurrentUserSession().getWorkspace().getQueryManager();
            if (queryManager != null) {
                Query q = queryManager.createQuery(sqlRequest, "JCR-SQL2");
                QueryResult queryResult = q.execute();
                NodeIterator ni = queryResult.getNodes();
                if (ni.hasNext()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Path[" + sqlRequest + "] --> found [" + ni.getSize() + "] values.");
                    }
                    return ni;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Path[" + sqlRequest + "] --> empty result.");
                }
            }
        }
        catch (PathNotFoundException e) {
            logger.debug("javax.jcr.PathNotFoundException: Path[" + sqlRequest + "]");
        }
        catch (ItemNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (InvalidQueryException e) {
            logger.error("InvalidQueryException ---> [" + sqlRequest + "] is not valid.", (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

