/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.query;

import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ConstraintImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.SourceImpl;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.query.ModificationInfo;
import org.jahia.services.query.QueryModifierAndOptimizerVisitor;
import org.jahia.services.query.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceImpl
extends QueryService {
    static final Logger logger = LoggerFactory.getLogger(QueryService.class);
    static int INITIALIZE_MODE = 1;
    static int CHECK_FOR_MODIFICATION_MODE = 2;
    static int MODIFY_MODE = 3;
    private ValueFactory valueFactory = ValueFactoryImpl.getInstance();

    private QueryServiceImpl() {
    }

    public static QueryService getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public QueryObjectModel modifyAndOptimizeQuery(QueryObjectModel qom, QueryObjectModelFactory qomFactory, JCRSessionWrapper session) throws RepositoryException {
        ModificationInfo info = this.getModificationInfo(qom.getSource(), qom.getConstraint(), qom.getOrderings(), qom.getColumns(), qomFactory, session);
        return info.getNewQueryObjectModel() != null ? info.getNewQueryObjectModel() : qom;
    }

    @Override
    public QueryObjectModel modifyAndOptimizeQuery(Source source, Constraint constraint, Ordering[] orderings, Column[] columns, QueryObjectModelFactory qomFactory, JCRSessionWrapper session) throws RepositoryException {
        ModificationInfo info = this.getModificationInfo(source, constraint, orderings, columns, qomFactory, session);
        return info.getNewQueryObjectModel() != null ? info.getNewQueryObjectModel() : qomFactory.createQuery(source, constraint, orderings, columns);
    }

    protected ModificationInfo getModificationInfo(Source source, Constraint constraint, Ordering[] orderings, Column[] columns, QueryObjectModelFactory qomFactory, JCRSessionWrapper session) throws RepositoryException {
        ModificationInfo info = new ModificationInfo(qomFactory);
        QueryModifierAndOptimizerVisitor visitor = new QueryModifierAndOptimizerVisitor(this.getValueFactory(), info, source, session);
        try {
            info.setMode(QueryModifierAndOptimizerVisitor.TraversingMode.INITIALIZE_MODE);
            ((SourceImpl)source).accept((QOMTreeVisitor)visitor, null);
            if (constraint != null) {
                ((ConstraintImpl)constraint).accept((QOMTreeVisitor)visitor, null);
            }
            if (orderings != null) {
                for (Ordering ordering : orderings) {
                    ((OrderingImpl)ordering).accept((QOMTreeVisitor)visitor, null);
                }
            }
            if (columns != null) {
                for (Ordering ordering : columns) {
                    ((ColumnImpl)ordering).accept((QOMTreeVisitor)visitor, null);
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        try {
            info.setMode(QueryModifierAndOptimizerVisitor.TraversingMode.CHECK_FOR_MODIFICATION_MODE);
            ((SourceImpl)source).accept((QOMTreeVisitor)visitor, null);
            if (constraint != null) {
                ((ConstraintImpl)constraint).accept((QOMTreeVisitor)visitor, null);
            }
            if (orderings != null) {
                for (Ordering ordering : orderings) {
                    ((OrderingImpl)ordering).accept((QOMTreeVisitor)visitor, null);
                }
            }
            if (columns != null) {
                for (Ordering ordering : columns) {
                    ((ColumnImpl)ordering).accept((QOMTreeVisitor)visitor, null);
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        if (info.isModificationNecessary()) {
            this.makeModifications(source, constraint, orderings, columns, info, (QOMTreeVisitor)visitor, qomFactory);
        }
        return info;
    }

    protected void makeModifications(Source source, Constraint constraint, Ordering[] orderings, Column[] columns, ModificationInfo info, QOMTreeVisitor visitor, QueryObjectModelFactory qomFactory) throws RepositoryException {
        info.setMode(QueryModifierAndOptimizerVisitor.TraversingMode.MODIFY_MODE);
        try {
            int n;
            int i = 0;
            Ordering[] newOrderings = null;
            if (orderings != null) {
                newOrderings = new Ordering[orderings.length];
                Ordering[] orderingArray = orderings;
                int n2 = orderingArray.length;
                for (n = 0; n < n2; ++n) {
                    Ordering ordering;
                    Ordering newOrdering = ordering = orderingArray[n];
                    newOrdering = (Ordering)((OrderingImpl)ordering).accept(visitor, null);
                    newOrderings[i++] = newOrdering;
                }
            }
            Column[] newColumns = null;
            if (columns != null) {
                newColumns = new Column[columns.length];
                i = 0;
                Column[] columnArray = columns;
                n = columnArray.length;
                for (int ordering = 0; ordering < n; ++ordering) {
                    Column column;
                    Column newColumn = column = columnArray[ordering];
                    newColumn = (Column)((ColumnImpl)column).accept(visitor, null);
                    newColumns[i++] = newColumn;
                }
            }
            Constraint newConstraint = null;
            if (constraint != null) {
                newConstraint = (Constraint)((ConstraintImpl)constraint).accept(visitor, null);
            }
            for (Constraint constraintToAdd : info.getNewConstraints()) {
                if (newConstraint == null) {
                    newConstraint = constraintToAdd;
                    continue;
                }
                newConstraint = info.getQueryObjectModelFactory().and(newConstraint, constraintToAdd);
            }
            Source newSource = (Source)((SourceImpl)info.getModifiedSource(source)).accept(visitor, null);
            if (newSource == null) {
                logger.error("New source is null! Old source: " + Arrays.toString(((SourceImpl)source).getSelectors()) + " - Modified source: " + Arrays.toString(((SourceImpl)info.getModifiedSource(source)).getSelectors()) + "- Modification mode: " + String.valueOf((Object)info.getMode()));
            }
            info.setNewQueryObjectModel(info.getQueryObjectModelFactory().createQuery(newSource, newConstraint, newOrderings, newColumns));
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    private static class Holder {
        static final QueryServiceImpl INSTANCE = new QueryServiceImpl();

        private Holder() {
        }
    }
}

