/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.render.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseView
implements View,
Comparable<View> {
    private static final Logger logger = LoggerFactory.getLogger(BaseView.class);
    private Properties defaultProperties;
    private String displayName;
    private String fileExtension;
    private String key;
    private JahiaTemplatesPackage module;
    private String path;
    private Properties properties;

    protected BaseView(String path, String key, JahiaTemplatesPackage module) {
        this.path = path;
        this.key = key;
        this.module = module;
        this.fileExtension = StringUtils.defaultIfEmpty((String)StringUtils.substringAfterLast((String)path, (String)"."), null);
    }

    protected BaseView(String path, String key, JahiaTemplatesPackage module, String displayName) {
        this(path, key, module);
        this.displayName = displayName;
    }

    @Override
    public int compareTo(View otherView) {
        if (this.module == null) {
            if (otherView.getModule() != null) {
                return 1;
            }
            return this.key.compareTo(otherView.getKey());
        }
        if (otherView.getModule() == null) {
            return -1;
        }
        if (!this.module.equals(otherView.getModule())) {
            return this.module.getName().compareTo(otherView.getModule().getName());
        }
        return this.key.compareTo(otherView.getKey());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseView other = (BaseView)o;
        if (this.path != null ? !this.path.equals(other.path) : other.path != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(other.key) : other.key != null) {
            return false;
        }
        if (this.module != null ? !this.module.equals(other.module) : other.module != null) {
            return false;
        }
        if (this.fileExtension != null ? !this.fileExtension.equals(other.fileExtension) : other.fileExtension != null) {
            return false;
        }
        return !(this.displayName != null ? !this.displayName.equals(other.displayName) : other.displayName != null);
    }

    @Override
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public String getInfo() {
        String modulePath = this.module.getSourcesFolder() != null ? this.getModule().getSourcesFolder().getPath() + "/src/main/resources" : "/modules/" + this.module.getIdWithVersion();
        return "Path dispatch: " + modulePath + this.path;
    }

    protected abstract InputStream getInputStream(String var1) throws IOException;

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public JahiaTemplatesPackage getModule() {
        return this.module;
    }

    @Override
    public String getModuleVersion() {
        return this.module != null && this.module.getVersion() != null ? this.module.getVersion().toString() : null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    protected abstract URL getResource(String var1);

    protected abstract String getResourcePath(String var1);

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.module.hashCode();
        result = 31 * result + (this.fileExtension != null ? this.fileExtension.hashCode() : 0);
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(String path, String thumbnailPath) {
        Properties p = new Properties();
        InputStream is = null;
        try {
            is = this.getInputStream(path);
            if (is != null) {
                p.load(is);
            }
        }
        catch (IOException e) {
            logger.warn("Unable to read associated properties file under " + path, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        String thumbnailURL = this.getResourcePath(thumbnailPath);
        if (thumbnailURL != null) {
            this.properties.put("image", thumbnailURL);
        }
        return p;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public String toString() {
        return this.getInfo();
    }
}

