/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.utils.Patterns;

public abstract class ConditionalExecution {
    private List<AbstractFilter.ExecutionCondition> conditions = new LinkedList<AbstractFilter.ExecutionCondition>();

    public ConditionalExecution() {
    }

    public ConditionalExecution(AbstractFilter.ExecutionCondition ... conditions) {
        this();
        for (AbstractFilter.ExecutionCondition cond : conditions) {
            this.addCondition(cond);
        }
    }

    public void addCondition(AbstractFilter.ExecutionCondition condition) {
        this.conditions.add(condition);
    }

    public void addCondition(int index, AbstractFilter.ExecutionCondition condition) {
        this.conditions.add(index, condition);
    }

    public boolean areConditionsMatched(RenderContext renderContext, Resource resource) {
        boolean matches = true;
        for (AbstractFilter.ExecutionCondition condition : this.conditions) {
            if (condition.matches(renderContext, resource)) continue;
            matches = false;
            break;
        }
        return matches;
    }

    public String getConditionsSummary() {
        StringBuilder out = new StringBuilder();
        if (this.conditions.isEmpty()) {
            out.append("<none>");
        }
        boolean first = true;
        for (AbstractFilter.ExecutionCondition cond : this.conditions) {
            if (!first) {
                out.append(" && ");
            } else {
                first = false;
            }
            out.append("(").append(cond).append(")");
        }
        return out.toString();
    }

    public void setApplyOnConfigurations(String configurations) {
        if (configurations.contains(",")) {
            AbstractFilter.AnyOfCondition condition = new AbstractFilter.AnyOfCondition();
            for (String conf : Patterns.COMMA.split(configurations)) {
                condition.add(new AbstractFilter.ConfigurationCondition(conf.trim()));
            }
            this.addCondition(0, condition);
        } else if (StringUtils.isNotBlank((String)configurations)) {
            this.addCondition(0, new AbstractFilter.ConfigurationCondition(configurations));
        }
    }

    public void setApplyOnMainResource(boolean bool) {
        if (bool) {
            this.addCondition(new AbstractFilter.MainResourceCondition());
        }
    }

    public void setApplyOnModes(String modes) {
        if (modes.contains(",")) {
            AbstractFilter.AnyOfCondition condition = new AbstractFilter.AnyOfCondition();
            for (String mode : Patterns.COMMA.split(modes)) {
                condition.add(new AbstractFilter.ModeCondition(mode.trim()));
            }
            this.addCondition(0, condition);
        } else if (StringUtils.isNotBlank((String)modes)) {
            this.addCondition(0, new AbstractFilter.ModeCondition(modes));
        }
    }

    public void setApplyOnEditMode(Boolean applyOnEditMode) {
        if (applyOnEditMode.booleanValue()) {
            this.addCondition(0, new AbstractFilter.EditModeCondition());
        }
    }

    public void setApplyOnModules(String modules) {
        if (modules.contains(",")) {
            AbstractFilter.AnyOfCondition condition = new AbstractFilter.AnyOfCondition();
            for (String module : Patterns.COMMA.split(modules)) {
                condition.add(new AbstractFilter.ModuleCondition(module.trim()));
            }
            this.addCondition(condition);
        } else if (StringUtils.isNotBlank((String)modules)) {
            this.addCondition(new AbstractFilter.ModuleCondition(modules));
        }
    }

    public void setApplyOnNodeTypes(String nodeTypes) {
        if (nodeTypes.contains(",")) {
            AbstractFilter.AnyOfCondition condition = new AbstractFilter.AnyOfCondition();
            for (String nodeType : Patterns.COMMA.split(nodeTypes)) {
                condition.add(new AbstractFilter.NodeTypeCondition(nodeType.trim()));
            }
            this.addCondition(condition);
        } else if (StringUtils.isNotBlank((String)nodeTypes)) {
            this.addCondition(new AbstractFilter.NodeTypeCondition(nodeTypes));
        }
    }

    public void setApplyOnTemplates(String templates) {
        if (templates.contains(",")) {
            AbstractFilter.AnyOfCondition condition = new AbstractFilter.AnyOfCondition();
            for (String template : Patterns.COMMA.split(templates)) {
                condition.add(new AbstractFilter.TemplateCondition(template.trim()));
            }
            this.addCondition(condition);
        } else if (StringUtils.isNotBlank((String)templates)) {
            this.addCondition(new AbstractFilter.TemplateCondition(templates));
        }
    }

    public void setApplyOnTemplateTypes(String templateTypes) {
        if (templateTypes.contains(",")) {
            AbstractFilter.AnyOfCondition condition = new AbstractFilter.AnyOfCondition();
            for (String templateType : Patterns.COMMA.split(templateTypes)) {
                condition.add(new AbstractFilter.TemplateTypeCondition(templateType.trim(), true));
            }
            this.addCondition(condition);
        } else if (StringUtils.isNotBlank((String)templateTypes)) {
            this.addCondition(new AbstractFilter.TemplateTypeCondition(templateTypes, true));
        }
    }

    public void setApplyOnSiteTemplateSets(String templateSets) {
        if (templateSets.contains(",")) {
            AbstractFilter.AnyOfCondition condition = new AbstractFilter.AnyOfCondition();
            for (String templateSet : Patterns.COMMA.split(templateSets)) {
                condition.add(new AbstractFilter.SiteTemplateSetCondition(templateSet.trim()));
            }
            this.addCondition(condition);
        } else if (StringUtils.isNotBlank((String)templateSets)) {
            this.addCondition(new AbstractFilter.SiteTemplateSetCondition(templateSets));
        }
    }

    public void setConditions(Set<AbstractFilter.ExecutionCondition> conditions) {
        this.conditions.addAll(conditions);
    }

    public void setSkipOnAjaxRequest(Boolean skip) {
        if (skip.booleanValue()) {
            this.addCondition(new AbstractFilter.NotCondition(new AbstractFilter.AjaxRequestCondition()));
        }
    }

    @Deprecated(since="7.2.1.0", forRemoval=true)
    public void setSkipOnConfiguration(String configurations) {
        this.setSkipOnConfigurations(configurations);
    }

    public void setSkipOnConfigurations(String configurations) {
        AbstractFilter.ExecutionCondition condition = null;
        if (configurations.contains(",")) {
            AbstractFilter.AnyOfCondition anyOf = new AbstractFilter.AnyOfCondition();
            for (String configuration : Patterns.COMMA.split(configurations)) {
                anyOf.add(new AbstractFilter.ConfigurationCondition(configuration.trim()));
            }
            condition = anyOf;
        } else if (StringUtils.isNotBlank((String)configurations)) {
            condition = new AbstractFilter.ConfigurationCondition(configurations);
        }
        if (condition != null) {
            this.addCondition(0, new AbstractFilter.NotCondition(condition));
        }
    }

    public void setSkipOnMainResource(boolean bool) {
        if (bool) {
            this.addCondition(new AbstractFilter.NotCondition(new AbstractFilter.MainResourceCondition()));
        }
    }

    public void setSkipOnModes(String modes) {
        AbstractFilter.ExecutionCondition condition = null;
        if (modes.contains(",")) {
            AbstractFilter.AnyOfCondition anyOf = new AbstractFilter.AnyOfCondition();
            for (String mode : Patterns.COMMA.split(modes)) {
                anyOf.add(new AbstractFilter.ModeCondition(mode.trim()));
            }
            condition = anyOf;
        } else if (StringUtils.isNotBlank((String)modes)) {
            condition = new AbstractFilter.ModeCondition(modes);
        }
        if (condition != null) {
            this.addCondition(0, new AbstractFilter.NotCondition(condition));
        }
    }

    public void setSkipOnEditMode(Boolean skipOnEditMode) {
        if (skipOnEditMode.booleanValue()) {
            this.addCondition(new AbstractFilter.NotCondition(new AbstractFilter.EditModeCondition()));
        }
    }

    public void setSkipOnModules(String modules) {
        AbstractFilter.ExecutionCondition condition = null;
        if (modules.contains(",")) {
            AbstractFilter.AnyOfCondition anyOf = new AbstractFilter.AnyOfCondition();
            for (String module : Patterns.COMMA.split(modules)) {
                anyOf.add(new AbstractFilter.ModuleCondition(module.trim()));
            }
            condition = anyOf;
        } else if (StringUtils.isNotBlank((String)modules)) {
            condition = new AbstractFilter.ModuleCondition(modules);
        }
        if (condition != null) {
            this.addCondition(new AbstractFilter.NotCondition(condition));
        }
    }

    public void setSkipOnNodeTypes(String nodeTypes) {
        AbstractFilter.ExecutionCondition condition = null;
        if (nodeTypes.contains(",")) {
            AbstractFilter.AnyOfCondition anyOf = new AbstractFilter.AnyOfCondition();
            for (String nodeType : Patterns.COMMA.split(nodeTypes)) {
                anyOf.add(new AbstractFilter.NodeTypeCondition(nodeType.trim()));
            }
            condition = anyOf;
        } else if (StringUtils.isNotBlank((String)nodeTypes)) {
            condition = new AbstractFilter.NodeTypeCondition(nodeTypes);
        }
        if (condition != null) {
            this.addCondition(new AbstractFilter.NotCondition(condition));
        }
    }

    public void setSkipOnTemplates(String templates) {
        AbstractFilter.ExecutionCondition condition = null;
        if (templates.contains(",")) {
            AbstractFilter.AnyOfCondition anyOf = new AbstractFilter.AnyOfCondition();
            for (String template : Patterns.COMMA.split(templates)) {
                anyOf.add(new AbstractFilter.TemplateCondition(template.trim()));
            }
            condition = anyOf;
        } else if (StringUtils.isNotBlank((String)templates)) {
            condition = new AbstractFilter.TemplateCondition(templates);
        }
        if (condition != null) {
            this.addCondition(new AbstractFilter.NotCondition(condition));
        }
    }

    public void setSkipOnTemplateTypes(String templateTypes) {
        AbstractFilter.ExecutionCondition condition = null;
        if (templateTypes.contains(",")) {
            AbstractFilter.AnyOfCondition anyOf = new AbstractFilter.AnyOfCondition();
            for (String templateType : Patterns.COMMA.split(templateTypes)) {
                anyOf.add(new AbstractFilter.TemplateTypeCondition(templateType.trim(), true));
            }
            condition = anyOf;
        } else if (StringUtils.isNotBlank((String)templateTypes)) {
            condition = new AbstractFilter.TemplateTypeCondition(templateTypes, true);
        }
        if (condition != null) {
            this.addCondition(new AbstractFilter.NotCondition(condition));
        }
    }

    public void setSkipOnWebflowRequest(Boolean skipOnWebflowRequest) {
        if (skipOnWebflowRequest.booleanValue()) {
            this.addCondition(new AbstractFilter.NotCondition(new AbstractFilter.WebflowRequestCondition()));
        }
    }
}

