/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PrincipalAcl
implements Serializable {
    private static final long serialVersionUID = -9194400174386788272L;
    private Map<String, Map<String, SortedSet<String>>> grantAceByPath = new ConcurrentHashMap<String, Map<String, SortedSet<String>>>();
    private Set<String> allPaths = new HashSet<String>();

    public PrincipalAcl(Map<String, Set<String>> mapGranted, Map<String, Set<String>> mapDenied) {
        for (Map.Entry<String, Set<String>> entry : mapGranted.entrySet()) {
            this.grantAceByPath.put(entry.getKey(), new HashMap());
            for (String role : entry.getValue()) {
                this.grantAceByPath.get(entry.getKey()).put(role, null);
            }
        }
        for (Map.Entry<String, Set<String>> entry : mapDenied.entrySet()) {
            String path;
            String grantedPath = path = entry.getKey();
            while (grantedPath.length() > 0) {
                if (!this.grantAceByPath.containsKey(grantedPath = StringUtils.substringBeforeLast((String)grantedPath, (String)"/"))) continue;
                Map<String, SortedSet<String>> rolesMap = this.grantAceByPath.get(grantedPath);
                Collection intersection = CollectionUtils.intersection(rolesMap.keySet(), (Collection)entry.getValue());
                for (String s : intersection) {
                    if (rolesMap.get(s) == null) {
                        rolesMap.put(s, new TreeSet());
                    }
                    rolesMap.get(s).add(path);
                }
            }
        }
        this.allPaths.addAll(mapGranted.keySet());
        this.allPaths.addAll(mapDenied.keySet());
    }

    public void fillMatchingPaths(Pattern pattern, Set<String> results) {
        for (String path : this.allPaths) {
            if (!pattern.matcher(path).matches()) continue;
            results.add(path);
        }
    }

    public void fillRolesForPath(String nodePath, Map<String, Set<String>> rolesForPath) {
        String unambiguosNodePath = nodePath + "/";
        for (Map.Entry<String, Map<String, SortedSet<String>>> entry : this.grantAceByPath.entrySet()) {
            String grantPath = entry.getKey() + "/";
            if (!unambiguosNodePath.startsWith(grantPath)) continue;
            this.fillRolesForPath(unambiguosNodePath, rolesForPath, entry.getValue());
        }
    }

    private void fillRolesForPath(String nodePath, Map<String, Set<String>> rolesForPath, Map<String, SortedSet<String>> rolesAndDeniedPaths) {
        if (!rolesForPath.containsKey(nodePath)) {
            rolesForPath.put(nodePath, new TreeSet());
        }
        this.fillValidRoles(nodePath, rolesAndDeniedPaths, rolesForPath.get(nodePath));
    }

    private void fillValidRoles(String nodePath, Map<String, SortedSet<String>> roles, Set<String> validRoles) {
        for (Map.Entry<String, SortedSet<String>> entry : roles.entrySet()) {
            SortedSet<String> s;
            if (entry.getValue() == null) {
                validRoles.add(entry.getKey());
                continue;
            }
            if (entry.getValue().contains(nodePath) || !(s = entry.getValue().headSet(nodePath)).isEmpty() && nodePath.startsWith(s.last())) continue;
            validRoles.add(entry.getKey());
        }
    }
}

