/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.ClientCachePolicy;
import org.jahia.utils.Patterns;

public class QueryStringCacheKeyPartGenerator
implements CacheKeyPartGenerator {
    protected static final Pattern QUERYSTRING_REGEXP = Pattern.compile("(.*)(_qs\\[([^\\]]+)\\]_)(.*)");

    @Override
    public String getKey() {
        return "queryString";
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        String property = properties.getProperty("cache.requestParameters");
        if (!StringUtils.isEmpty((String)property)) {
            try {
                property = property.replace("${currentNode.identifier}", resource.getNode().getIdentifier());
            }
            catch (RepositoryException e) {
                property = property.replace("${currentNode.identifier}", "*");
            }
            Object[] params = Patterns.COMMA.split(property);
            return "_qs" + Arrays.toString(params) + "_";
        }
        return "";
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        Map parameterMap = renderContext.getRequest().getParameterMap();
        if (!parameterMap.isEmpty()) {
            Matcher m = QUERYSTRING_REGEXP.matcher(keyPart);
            if (m.matches()) {
                String qsString = m.group(2);
                String[] params = Patterns.COMMA.split(m.group(3));
                TreeMap<String, String> qs = new TreeMap<String, String>();
                for (String param : params) {
                    if ((param = param.trim()).endsWith("*")) {
                        param = param.substring(0, param.length() - 1);
                        for (Map.Entry entry : parameterMap.entrySet()) {
                            String k = (String)entry.getKey();
                            if (!k.startsWith(param)) continue;
                            qs.put(k, Arrays.toString((String[])entry.getValue()));
                        }
                        continue;
                    }
                    if (!parameterMap.containsKey(param)) continue;
                    qs.put(param, Arrays.toString((String[])parameterMap.get(param)));
                }
                keyPart = keyPart.replace(qsString, ((Object)qs).toString());
            }
            return keyPart;
        }
        return "{}";
    }

    @Override
    public ClientCachePolicy getClientCachePolicy(Resource resource, RenderContext renderContext, Properties properties, String key) {
        return ClientCachePolicy.DEFAULT;
    }
}

