/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.Properties;
import javax.jcr.RepositoryException;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.ClientCachePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceIDCacheKeyPartGenerator
implements CacheKeyPartGenerator {
    private static Logger logger = LoggerFactory.getLogger(ResourceIDCacheKeyPartGenerator.class);

    @Override
    public String getKey() {
        return "resourceID";
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        try {
            return resource.getNode().getIdentifier();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        return keyPart;
    }

    @Override
    public ClientCachePolicy getClientCachePolicy(Resource resource, RenderContext renderContext, Properties properties, String key) {
        return ClientCachePolicy.DEFAULT;
    }
}

