/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.scripting.bundle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.PomUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleSourceResourceResolver {
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private static Logger logger = LoggerFactory.getLogger(BundleSourceResourceResolver.class);
    private final URL[] sourceURLs;

    public BundleSourceResourceResolver(Bundle bundle) {
        URL[] sourceURLs = BundleSourceResourceResolver.getSourceURLs(bundle);
        this.sourceURLs = sourceURLs != null && sourceURLs.length == 0 ? null : sourceURLs;
    }

    public URL[] getSourceURLs() {
        return this.sourceURLs;
    }

    public boolean hasSourceURLs() {
        return this.sourceURLs != null && this.sourceURLs.length > 0;
    }

    private static URL[] getSourceURLs(Bundle bundle) {
        URL[] urls = EMPTY_URL_ARRAY;
        String sourceFolder = (String)bundle.getHeaders().get("Jahia-Source-Folders");
        if (StringUtils.isNotEmpty((String)sourceFolder)) {
            File webappFolderFile;
            File pomFile = new File(sourceFolder = BundleSourceResourceResolver.getRealSourceFolder(sourceFolder), "pom.xml");
            if (!pomFile.exists()) {
                return null;
            }
            try {
                Model model = PomUtils.read(pomFile);
                String s = model.getVersion();
                if (s == null) {
                    s = model.getParent().getVersion();
                } else if (s.matches("\\$\\{.*\\}")) {
                    logger.warn("'version' contains an expression but should be a constant. Stopping mount of source folder.");
                    return null;
                }
                if (!s.equals(bundle.getHeaders().get("Implementation-Version"))) {
                    logger.warn("pom.xml 'version' is not matching the Manifest Implementation-Version. Stopping mount of source folder.");
                    return null;
                }
            }
            catch (Exception e) {
                logger.warn("Invalid source folder " + sourceFolder + ", cannot read pom file", (Object)e.getMessage());
                return null;
            }
            ArrayList<URL> sourceURLs = new ArrayList<URL>();
            File resourceFolderFile = new File(sourceFolder, "src/main/resources");
            if (resourceFolderFile.exists()) {
                try {
                    sourceURLs.add(resourceFolderFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warn("Invalid source folder " + sourceFolder + ", cannot convert to URL", (Throwable)e);
                }
            }
            if ((webappFolderFile = new File(sourceFolder, "src/main/webapp")).exists()) {
                try {
                    sourceURLs.add(webappFolderFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warn("Invalid source folder " + sourceFolder + ", cannot convert to URL", (Throwable)e);
                }
            }
            urls = sourceURLs.toArray(new URL[sourceURLs.size()]);
            logger.debug("Detected {} source folders for bundle {}", (Object)sourceURLs.size(), (Object)bundle.getSymbolicName());
        }
        return urls;
    }

    private static String getRealSourceFolder(String sourceFolder) {
        File sourceDirectoryHeader = new File((String)sourceFolder);
        if (!Files.exists(sourceDirectoryHeader.toPath(), new LinkOption[0])) {
            String sourceProjectName = sourceDirectoryHeader.getName();
            String containerSourceRoot = SettingsBean.getInstance().getModulesSourcesDiskPath();
            if (Files.exists(new File(containerSourceRoot + File.separator + sourceProjectName).toPath(), new LinkOption[0])) {
                sourceFolder = containerSourceRoot + File.separator + sourceProjectName;
            }
        }
        return sourceFolder;
    }

    public URL getResource(String name) {
        if (name != null && name.charAt(0) == '/' && name.length() > 1) {
            name = name.substring(1);
        }
        for (URL sourceURL : this.sourceURLs) {
            try {
                URL resourceURL = new URL(sourceURL, name);
                if (!this.urlExists(resourceURL)) continue;
                return resourceURL;
            }
            catch (MalformedURLException e) {
                logger.error("Error in resource URL " + name, (Throwable)e);
            }
        }
        return null;
    }

    private boolean urlExists(URL url) {
        try {
            HttpURLConnection httpCon;
            URLConnection con = null;
            con = url.openConnection();
            con.setUseCaches(false);
            HttpURLConnection httpURLConnection = httpCon = con instanceof HttpURLConnection ? (HttpURLConnection)con : null;
            if (httpCon != null) {
                httpCon.setRequestMethod("HEAD");
                if (httpCon.getResponseCode() == 200) {
                    return true;
                }
            }
            if (con.getContentLength() > 0) {
                return true;
            }
            if (httpCon != null) {
                httpCon.disconnect();
                return false;
            }
            InputStream is = this.getInputStream(url);
            is.close();
            return true;
        }
        catch (IOException e) {
            logger.debug("Testing existence of resource " + String.valueOf(url), (Throwable)e);
            return false;
        }
    }

    private InputStream getInputStream(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.setUseCaches(false);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }
}

