/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.Resource;
import org.jahia.services.render.View;
import org.jahia.services.render.filter.AggregateFilter;
import org.jahia.services.render.scripting.RequestDispatcherScript;
import org.jahia.utils.StringResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;

public class WebflowDispatcherScript
extends RequestDispatcherScript {
    private static final Pattern MODULE_PREFIX_PATTERN = Pattern.compile("/modules/[^/]*/");
    private static final Logger logger = LoggerFactory.getLogger(WebflowDispatcherScript.class);
    private String flowPath;
    private boolean xssFilteringEnabled = true;

    public WebflowDispatcherScript(View view) {
        super(view);
    }

    public WebflowDispatcherScript(View view, boolean xssFilteringEnabled) {
        this(view);
        this.xssFilteringEnabled = xssFilteringEnabled;
    }

    @Override
    public String execute(Resource resource, RenderContext context) throws RenderException {
        StringResponseWrapper responseWrapper;
        boolean aggregationSkippedForWebflow;
        WebflowHttpServletRequestWrapper request;
        block24: {
            String identifier;
            final View view = this.getView();
            if (view == null) {
                throw new RenderException("View not found for : " + String.valueOf(resource));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("View '" + String.valueOf(view) + "' resolved for resource: " + String.valueOf(resource));
            }
            try {
                identifier = resource.getNode().getIdentifier();
            }
            catch (RepositoryException e) {
                throw new RenderException(e);
            }
            Object identifierNoDashes = StringUtils.replace((String)identifier, (String)"-", (String)"_");
            if (!view.getKey().equals("default")) {
                identifierNoDashes = (String)identifierNoDashes + "__" + view.getKey();
            }
            HttpServletResponse response = context.getResponse();
            Map parameters = (Map)context.getRequest().getAttribute("actionParameters");
            if (this.xssFilteringEnabled && parameters != null) {
                Map m = Maps.transformEntries((Map)parameters, (Maps.EntryTransformer)new Maps.EntryTransformer<String, List<String>, String[]>(){

                    public String[] transformEntry(@Nullable String key, @Nullable List<String> value) {
                        return value != null ? value.toArray(new String[value.size()]) : null;
                    }
                });
                request = new WebflowHttpServletRequestWrapper(context.getRequest(), m, (String)identifierNoDashes);
            } else {
                request = new WebflowHttpServletRequestWrapper(context.getRequest(), new HashMap<String, String[]>(context.getRequest().getParameterMap()), (String)identifierNoDashes);
            }
            String s = (String)request.getSession().getAttribute("webflowResponse" + (String)identifierNoDashes);
            if (s != null) {
                request.getSession().removeAttribute("webflowResponse" + (String)identifierNoDashes);
                return s;
            }
            aggregationSkippedForWebflow = false;
            if (!AggregateFilter.skipAggregation((ServletRequest)context.getRequest())) {
                aggregationSkippedForWebflow = true;
                context.getRequest().setAttribute("aggregateFilter.skip", (Object)true);
            }
            this.flowPath = MODULE_PREFIX_PATTERN.matcher(view.getPath()).replaceFirst("");
            RequestDispatcher rd = request.getRequestDispatcher("/flow/" + this.flowPath);
            Object oldModule = request.getAttribute("currentModule");
            request.setAttribute("currentModule", view.getModule());
            if (logger.isDebugEnabled()) {
                WebflowDispatcherScript.dumpRequestAttributes((HttpServletRequest)request);
            }
            responseWrapper = new StringResponseWrapper(response);
            try {
                FlowDefinitionRegistry reg = (FlowDefinitionRegistry)view.getModule().getContext().getBean("jahiaFlowRegistry");
                final GenericApplicationContext applicationContext = (GenericApplicationContext)reg.getFlowDefinition(this.flowPath).getApplicationContext();
                applicationContext.setClassLoader(view.getModule().getClassLoader());
                applicationContext.setResourceLoader(new ResourceLoader(){

                    public org.springframework.core.io.Resource getResource(String location) {
                        return applicationContext.getParent().getResource("/" + WebflowDispatcherScript.this.flowPath + "/" + location);
                    }

                    public ClassLoader getClassLoader() {
                        return view.getModule().getClassLoader();
                    }
                });
                rd.include((ServletRequest)request, (ServletResponse)responseWrapper);
                String redirect = responseWrapper.getRedirect();
                if (redirect == null || context.getRedirect() != null) break block24;
                if (redirect.startsWith("http:/") || redirect.startsWith("https://")) {
                    context.setRedirect(responseWrapper.getRedirect());
                    break block24;
                }
                while (redirect != null) {
                    final String qs = StringUtils.substringAfter((String)responseWrapper.getRedirect(), (String)"?");
                    final HashMap<String, String[]> params = new HashMap<String, String[]>();
                    if (!StringUtils.isEmpty((String)qs)) {
                        String[] pairs;
                        for (String pair : pairs = qs.split("&")) {
                            int idx = pair.indexOf("=");
                            params.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), new String[]{URLDecoder.decode(pair.substring(idx + 1), "UTF-8")});
                        }
                    }
                    HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper((HttpServletRequest)request){

                        public String getMethod() {
                            return "GET";
                        }

                        public Map getParameterMap() {
                            return params;
                        }

                        public String getParameter(String name) {
                            return params.containsKey(name) ? ((String[])params.get(name))[0] : null;
                        }

                        public Enumeration getParameterNames() {
                            return new Vector(params.keySet()).elements();
                        }

                        public String[] getParameterValues(String name) {
                            return (String[])params.get(name);
                        }

                        public Object getAttribute(String name) {
                            if ("javax.servlet.forward.query_string".equals(name)) {
                                return qs;
                            }
                            return super.getAttribute(name);
                        }

                        public String getQueryString() {
                            return qs;
                        }
                    };
                    rd = requestWrapper.getRequestDispatcher("/flow/" + this.flowPath + "?" + qs);
                    responseWrapper = new StringResponseWrapper(response);
                    rd.include((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
                    String oldRedirect = redirect;
                    redirect = responseWrapper.getRedirect();
                    if (redirect != null) {
                        if (!redirect.startsWith("http://") && !redirect.startsWith("https://")) continue;
                        context.setRedirect(redirect);
                        break;
                    }
                    if (!request.getMethod().equals("POST")) continue;
                    request.getSession().setAttribute("webflowResponse" + (String)identifierNoDashes, (Object)responseWrapper.getString());
                    context.setRedirect(oldRedirect);
                }
            }
            catch (ServletException e) {
                throw new RenderException(e.getRootCause() != null ? e.getRootCause() : e);
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
            finally {
                request.setAttribute("currentModule", oldModule);
            }
        }
        try {
            if (aggregationSkippedForWebflow) {
                request.removeAttribute("aggregateFilter.skip");
            }
            return responseWrapper.getString();
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    public String getFlowPath() {
        return "/flow/" + this.flowPath;
    }

    public boolean isMultipartRequest(HttpServletRequest req) {
        String contentType = req.getHeader("Content-Type");
        return contentType != null && contentType.indexOf("multipart/form-data") >= 0;
    }

    private static class WebflowHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, String[]> m;
        private final String identifierNoDashes;

        public WebflowHttpServletRequestWrapper(HttpServletRequest request, Map<String, String[]> m, String identifierNoDashes) {
            super(request);
            this.m = m;
            this.identifierNoDashes = identifierNoDashes;
            m.remove("webflowexecution" + identifierNoDashes);
        }

        public String[] getParameterValues(String name) {
            return this.m.get(name);
        }

        public String getParameter(String name) {
            if (name.equals("webflowexecution" + this.identifierNoDashes)) {
                return super.getParameter(name);
            }
            return this.m.get(name) != null && this.m.get(name).length > 0 ? this.m.get(name)[0] : null;
        }

        public Map<String, String[]> getParameterMap() {
            return this.m;
        }

        public Enumeration<String> getParameterNames() {
            return new Vector<String>(this.m.keySet()).elements();
        }
    }
}

