/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.settings.SettingsBean;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JobSchedulingBean
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulingBean.class);
    private boolean disabled;
    private boolean isRamJob;
    private JobDetail jobDetail;
    private Boolean overwriteExisting;
    private SchedulerService schedulerService;
    private SettingsBean settingsBean;
    private List<Trigger> triggers = new LinkedList<Trigger>();

    public void afterPropertiesSet() throws Exception {
        if (this.disabled || !this.isEligibleToManageJob()) {
            return;
        }
        if (this.overwriteExisting == null) {
            this.overwriteExisting = this.settingsBean.isDevelopmentMode();
        }
        if (this.jobDetail == null) {
            LOGGER.info("No JobDetail data was specified. Skip scheduling job.");
            return;
        }
        JobDetail existingJobDetail = this.getScheduler().getJobDetail(this.jobDetail.getName(), this.jobDetail.getGroup());
        if (this.overwriteExisting.booleanValue() || existingJobDetail == null) {
            LOGGER.info("Overwrite existing job: {} or job detail does not exists: {}", (Object)this.overwriteExisting, (Object)(existingJobDetail == null ? 1 : 0));
            this.deleteJob();
            this.createJob(true);
            this.scheduleJob(true);
        } else {
            LOGGER.info("Job {} already exists. Syncing triggers.", (Object)this.jobDetail.getFullName());
            this.syncJobTriggers();
        }
    }

    public void destroy() throws Exception {
        LOGGER.info("Destroying job scheduling bean{}", (Object)this.jobDetail.getFullName());
        if (!this.isEligibleToManageJob()) {
            return;
        }
        if (JahiaContextLoaderListener.isRunning()) {
            if (this.isRamJob) {
                this.deleteJob();
            } else {
                this.unscheduleJob();
            }
        }
    }

    protected Scheduler getScheduler() {
        return this.isRamJob ? this.schedulerService.getRAMScheduler() : this.schedulerService.getScheduler();
    }

    protected String getTriggerInfo(Trigger trigger) {
        return trigger instanceof CronTrigger && ((CronTrigger)trigger).getCronExpression() != null ? "CronTrigger [" + ((CronTrigger)trigger).getCronExpression() + "]" : trigger.toString();
    }

    protected void syncJobTriggers() throws SchedulerException {
        JobDetail detail;
        LOGGER.info("Syncing triggers for job {}", (Object)this.jobDetail.getFullName());
        if (this.isRamJob && (detail = this.schedulerService.getScheduler().getJobDetail(this.jobDetail.getName(), this.jobDetail.getGroup())) != null) {
            LOGGER.debug("Job {} was found in the persistent scheduler but is RAM now. Deleting it.", (Object)this.jobDetail.getFullName());
            this.schedulerService.getScheduler().deleteJob(this.jobDetail.getName(), this.jobDetail.getGroup());
        }
        Map<String, Trigger> existingTriggers = this.mapByName(this.getScheduler().getTriggersOfJob(this.jobDetail.getName(), this.jobDetail.getGroup()));
        Map<String, Trigger> newTriggers = this.mapByName(this.triggers.toArray(new Trigger[0]));
        for (Map.Entry<String, Trigger> newTrigger : newTriggers.entrySet()) {
            if (existingTriggers.containsKey(newTrigger.getKey())) continue;
            this.createTrigger(newTrigger.getValue());
        }
        for (Map.Entry<String, Trigger> existingTrigger : existingTriggers.entrySet()) {
            Trigger newTrigger = newTriggers.get(existingTrigger.getKey());
            if (newTrigger != null) {
                LOGGER.debug("Trigger {} already exists. Checking if it needs to be updated.", (Object)existingTrigger.getKey());
                if (newTrigger instanceof CronTrigger) {
                    String existingCron;
                    String newCron = ((CronTrigger)newTrigger).getCronExpression();
                    if (newCron.equals(existingCron = ((CronTrigger)existingTrigger.getValue()).getCronExpression())) continue;
                    newTrigger.setJobName(existingTrigger.getValue().getJobName());
                    newTrigger.setJobGroup(existingTrigger.getValue().getJobGroup());
                    this.updateTrigger(newTrigger);
                    continue;
                }
                this.updateTrigger(newTrigger);
                continue;
            }
            this.removeTrigger(existingTrigger.getValue());
        }
    }

    protected void createJob(boolean deleteFirst) throws SchedulerException {
        this.getScheduler().addJob(this.jobDetail, deleteFirst);
    }

    protected void scheduleJob(boolean deleteFirst) throws SchedulerException {
        if (deleteFirst) {
            this.unscheduleJob();
        }
        if (this.triggers.isEmpty()) {
            LOGGER.info("Job has no triggers configured. Only the JobDetail data will be stored.");
        }
        for (Trigger trigger : this.triggers) {
            this.createTrigger(trigger);
        }
    }

    protected void deleteJob() throws SchedulerException {
        LOGGER.info("Deleting job {}", (Object)this.jobDetail.getFullName());
        this.getScheduler().deleteJob(this.jobDetail.getName(), this.jobDetail.getGroup());
    }

    protected void unscheduleJob() throws SchedulerException {
        Trigger[] triggers;
        LOGGER.info("Unscheduling job {}", (Object)this.jobDetail.getFullName());
        for (Trigger trigger : triggers = this.getScheduler().getTriggersOfJob(this.jobDetail.getName(), this.jobDetail.getGroup())) {
            this.removeTrigger(trigger);
        }
    }

    private void createTrigger(Trigger trigger) throws SchedulerException {
        trigger.setJobName(this.jobDetail.getName());
        trigger.setJobGroup(this.jobDetail.getGroup());
        LOGGER.info("Create trigger for {} job {} using {}", (Object[])new String[]{this.isRamJob ? "RAM" : "persistent", this.jobDetail.getFullName(), this.getTriggerInfo(trigger)});
        this.getScheduler().scheduleJob(trigger);
    }

    private void removeTrigger(Trigger trigger) throws SchedulerException {
        LOGGER.info("Remove trigger for {} job {} using {}", (Object[])new String[]{this.isRamJob ? "RAM" : "persistent", this.jobDetail.getFullName(), this.getTriggerInfo(trigger)});
        this.getScheduler().unscheduleJob(trigger.getName(), trigger.getGroup());
    }

    private void updateTrigger(Trigger trigger) throws SchedulerException {
        LOGGER.info("Update trigger for {} job {} using {}", (Object[])new String[]{this.isRamJob ? "RAM" : "persistent", this.jobDetail.getFullName(), this.getTriggerInfo(trigger)});
        this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
    }

    private boolean isEligibleToManageJob() {
        return this.isRamJob || this.settingsBean.isProcessingServer();
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void setOverwriteExisting(boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    public void setRamJob(boolean ramJob) {
        this.isRamJob = ramJob;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }

    public void setTrigger(Trigger trigger) {
        if (trigger != null) {
            this.triggers.add(trigger);
        }
    }

    public void setTriggers(List<Trigger> triggers) {
        if (triggers != null) {
            this.triggers.addAll(triggers);
        }
    }

    protected Map<String, Trigger> mapByName(Trigger[] triggers) {
        if (triggers == null || triggers.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Trigger> map = new HashMap<String, Trigger>(triggers.length);
        for (Trigger trg : triggers) {
            map.put(trg.getFullName(), trg);
        }
        return map;
    }
}

