/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.jcr;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Render;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.utils.Url;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanityUrlMapper {
    private static final Logger logger = LoggerFactory.getLogger(VanityUrlMapper.class);
    public static final String VANITY_KEY = "org.jahia.services.seo.jcr.VanityUrl";

    private static String encode(String fullUrl) {
        return fullUrl.replaceAll("\\$", "\\\\\\$");
    }

    public void checkVanityUrl(HttpServletRequest hsRequest, String outboundContext, String outboundUrl) {
        block20: {
            hsRequest.removeAttribute(VANITY_KEY);
            URLResolverFactory urlResolverFactory = (URLResolverFactory)SpringContextSingleton.getBean("urlResolverFactory");
            VanityUrlService vanityUrlService = (VanityUrlService)SpringContextSingleton.getBean("org.jahia.services.seo.jcr.VanityUrlService");
            String ctx = StringUtils.defaultIfEmpty((String)hsRequest.getContextPath(), (String)"");
            String fullUrl = ctx + Render.getRenderServletPath() + outboundUrl;
            hsRequest.setAttribute(VANITY_KEY, (Object)VanityUrlMapper.encode(fullUrl));
            if (StringUtils.isNotEmpty((String)outboundUrl) && !Url.isLocalhost(hsRequest.getServerName())) {
                String serverName = null;
                String siteKey = null;
                String contextToCheck = outboundContext;
                int schemaDelimiterIndex = outboundContext.indexOf("://");
                if (schemaDelimiterIndex != -1) {
                    try {
                        URI uri = new URI(outboundContext);
                        siteKey = VanityUrlMapper.lookupSiteKeyByServerName(uri.getHost());
                        if (siteKey != null) {
                            contextToCheck = uri.getPath();
                            serverName = Url.getServer(uri.getScheme(), uri.getHost(), uri.getPort());
                        }
                    }
                    catch (URISyntaxException uri) {}
                } else if (StringUtils.isNotEmpty((String)((String)hsRequest.getAttribute("jahiaSeoServernameForLink")))) {
                    String host = (String)hsRequest.getAttribute("jahiaSeoServernameForLink");
                    host = StringUtils.substringBefore((String)StringUtils.substringAfter((String)host, (String)"://"), (String)":");
                    siteKey = VanityUrlMapper.lookupSiteKeyByServerName(host);
                }
                if (StringUtils.equals((String)ctx, (String)contextToCheck)) {
                    Object path = "/render";
                    int queryIndex = outboundUrl.indexOf(63);
                    path = queryIndex < 0 ? (String)path + outboundUrl : (String)path + outboundUrl.substring(0, queryIndex);
                    try {
                        path = URLDecoder.decode((String)path, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new JahiaRuntimeException(e);
                    }
                    URLResolver urlResolver = urlResolverFactory.createURLResolver((String)path, hsRequest.getServerName(), hsRequest);
                    try {
                        JCRNodeWrapper node = urlResolver.getNode();
                        if (urlResolver.isMapped()) {
                            VanityUrl vanityUrl;
                            RenderContext context = (RenderContext)hsRequest.getAttribute("renderContext");
                            if (siteKey == null) {
                                String string = siteKey = context != null ? context.getSite().getSiteKey() : node.getResolveSite().getSiteKey();
                            }
                            if ((!StringUtils.isNotEmpty((String)urlResolver.getSiteKeyByServerName()) || urlResolver.getSiteKeyByServerName().equals(siteKey)) && (vanityUrl = vanityUrlService.getVanityUrlForWorkspaceAndLocale(node, urlResolver.getWorkspace(), urlResolver.getLocale(), siteKey)) != null && vanityUrl.isActive() && this.checkForVanityUrlAmbiguousMapping(vanityUrl, urlResolver, hsRequest, vanityUrlService)) {
                                Object extension = "";
                                if (fullUrl.matches("(.?)*##[a-zA-Z]*##$")) {
                                    extension = "##" + StringUtils.substringBetween((String)fullUrl, (String)"##") + "##";
                                } else if (queryIndex >= 0) {
                                    extension = outboundUrl.substring(queryIndex);
                                }
                                hsRequest.setAttribute(VANITY_KEY, (Object)VanityUrlMapper.encode(ctx + Render.getRenderServletPath() + "/" + urlResolver.getWorkspace() + vanityUrl.getUrl() + (String)extension));
                                if (serverName != null) {
                                    hsRequest.setAttribute("jahiaSeoServernameForLink", (Object)serverName);
                                }
                            }
                        }
                    }
                    catch (RepositoryException e) {
                        logger.debug("Error when trying to obtain vanity url", (Throwable)e);
                        if (serverName == null) break block20;
                        hsRequest.setAttribute("jahiaSeoServernameForLink", (Object)serverName);
                    }
                }
            }
        }
    }

    public void checkFileVanityUrl(HttpServletRequest hsRequest, String outboundUrl) {
        hsRequest.removeAttribute(VANITY_KEY);
        URLResolverFactory urlResolverFactory = (URLResolverFactory)SpringContextSingleton.getBean("urlResolverFactory");
        VanityUrlService vanityUrlService = (VanityUrlService)SpringContextSingleton.getBean("org.jahia.services.seo.jcr.VanityUrlService");
        RenderContext context = (RenderContext)hsRequest.getAttribute("renderContext");
        String ctx = StringUtils.defaultIfEmpty((String)hsRequest.getContextPath(), (String)"");
        String fullUrl = ctx + "/files/live" + outboundUrl;
        hsRequest.setAttribute(VANITY_KEY, (Object)VanityUrlMapper.encode(fullUrl));
        if (StringUtils.isNotEmpty((String)outboundUrl) && !Url.isLocalhost(hsRequest.getServerName()) && context != null) {
            String siteKey = context.getSite().getSiteKey();
            try {
                VanityUrl vanityUrl = vanityUrlService.getVanityUrlForWorkspaceAndLocale(outboundUrl, "live", context.getMainResource().getLocale(), siteKey);
                if (vanityUrl != null && vanityUrl.isActive()) {
                    hsRequest.setAttribute(VANITY_KEY, (Object)VanityUrlMapper.encode(ctx + vanityUrl.getUrl()));
                }
            }
            catch (RepositoryException e) {
                logger.debug("Error when trying to obtain vanity url", (Throwable)e);
            }
        }
    }

    private boolean checkForVanityUrlAmbiguousMapping(VanityUrl vanityUrlToTest, URLResolver urlResolver, HttpServletRequest hsRequest, VanityUrlService vanityUrlService) throws RepositoryException {
        if (StringUtils.isEmpty((String)urlResolver.getSiteKeyByServerName())) {
            List<VanityUrl> foundVanityUrls = vanityUrlService.findExistingVanityUrls(vanityUrlToTest.getUrl(), "", urlResolver.getWorkspace());
            for (VanityUrl foundVanityUrl : foundVanityUrls) {
                if (foundVanityUrl.getSite().equals(vanityUrlToTest.getSite())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Ambiguous vanity URL resolution: current server name '{}' does not allow to resolve the appropriate site, and multiple vanity urls exist with the exact same url mapping '{}' in different sites {}", new Object[]{hsRequest.getServerName(), vanityUrlToTest.getUrl(), Arrays.toString(new String[]{vanityUrlToTest.getSite(), foundVanityUrl.getSite()})});
                }
                return false;
            }
        }
        return true;
    }

    private static String lookupSiteKeyByServerName(String host) {
        JahiaSite site = null;
        if (SpringContextSingleton.getInstance().isInitialized()) {
            try {
                site = JahiaSitesService.getInstance().getSiteByServerName(host);
            }
            catch (JahiaException e) {
                logger.error("Error resolving site by server name '" + host + "'", (Throwable)e);
            }
        }
        return site != null ? site.getSiteKey() : "";
    }
}

