/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.jahia.osgi.BundleResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.tuckey.web.filters.urlrewrite.Conf;

public class Configuration
extends Conf {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);

    private Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration(ServletContext context, InputStream is, Resource[] confLocations, ClassLoader mainClassLoader) {
        super(context, is, confLocations[0].getFilename(), confLocations[0].getDescription(), mainClassLoader);
        IOUtils.closeQuietly((InputStream)is);
        for (int i = 1; i < confLocations.length; ++i) {
            Resource resource = confLocations[i];
            InputStream stream = null;
            try {
                stream = resource.getInputStream();
                this.loadDom(stream, Configuration.getClassLoader(resource));
                continue;
            }
            catch (Exception e) {
                logger.error("Error loading URL rewrite rules from {}", (Object)resource.getDescription(), (Object)e);
                continue;
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        super.initialise();
    }

    public void initialise() {
    }

    static Configuration createConfiguration(ServletContext context, Resource[] confLocations) throws IOException {
        return new Configuration(context, confLocations[0].getInputStream(), confLocations, Configuration.getClassLoader(confLocations[0]));
    }

    static Configuration createEmptyConfiguration() {
        return new Configuration();
    }

    private static ClassLoader getClassLoader(Resource resource) {
        if (resource instanceof BundleResource) {
            Bundle bundle = ((BundleResource)resource).getBundle();
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (bundleWiring == null) {
                logger.warn("Unable to get the bundle wiring for bundle {}", (Object)bundle.getSymbolicName());
                return null;
            }
            return bundleWiring.getClassLoader();
        }
        return null;
    }
}

