/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jahia.settings.SettingsBean;

public class SessionidRemovalResponseWrapper
extends HttpServletResponseWrapper {
    private HttpServletRequest request;
    private static Pattern cleanPattern = Pattern.compile(";" + SettingsBean.getInstance().getJsessionIdParameterName() + "=[^\\?#]*");

    public SessionidRemovalResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this.request = request;
    }

    public String encodeURL(String url) {
        return this.clean(super.encodeURL(url));
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    private String clean(String url) {
        if (SettingsBean.getInstance().isDisableJsessionIdParameter() || this.isInRender()) {
            url = SessionidRemovalResponseWrapper.removeJsessionId((String)url);
            if (this.isInRender() && !SettingsBean.getInstance().isDisableJsessionIdParameter() && !((String)url).contains("##sessionid##")) {
                url = (String)url + "##sessionid##";
            }
        }
        return url;
    }

    public static String removeJsessionId(String url) {
        String s = ";" + SettingsBean.getInstance().getJsessionIdParameterName();
        if (url.contains(s)) {
            url = cleanPattern.matcher(url).replaceFirst("");
        }
        return url;
    }

    private boolean isInRender() {
        return this.request.getAttribute("currentNode") != null;
    }
}

