/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.templates.SourceControlException;
import org.jahia.services.templates.SourceControlManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitSourceControlManagement
extends SourceControlManagement {
    private static final Logger logger = LoggerFactory.getLogger(GitSourceControlManagement.class);

    public GitSourceControlManagement(String executable) {
        super(executable);
    }

    @Override
    public void add(List<File> files) throws IOException {
        if (files.isEmpty()) {
            return;
        }
        String rootPath = this.rootFolder.getPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add("add");
        for (File file : files) {
            if (file.getPath().equals(rootPath)) {
                args.add(".");
                continue;
            }
            args.add(file.getPath().substring(rootPath.length() + 1));
        }
        this.executeCommand(this.executable, args.toArray(new String[args.size()]));
        this.invalidateStatusCache();
    }

    @Override
    public boolean commit(String message) throws IOException {
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"symbolic-ref", "--short", "HEAD"});
        boolean needRebaseContinue = result.exitValue > 0;
        String branch = needRebaseContinue ? null : result.out.trim();
        boolean commitRequired = this.checkCommit();
        if (commitRequired) {
            this.checkExecutionResult(this.executeCommand(this.executable, new String[]{"commit", "-a", "-m", message}));
        }
        boolean didWeDoAnything = commitRequired;
        if (needRebaseContinue) {
            result = this.executeCommand(this.executable, new String[]{"status"});
            if (result.exitValue == 0 && result.out.contains("all conflicts fixed")) {
                result = this.executeCommand(this.executable, new String[]{"rebase", "--continue"});
                if (result.exitValue > 0 && result.out.contains("No changes")) {
                    result = this.executeCommand(this.executable, new String[]{"rebase", "--skip"});
                }
                this.checkExecutionResult(result);
                result = this.executeCommand(this.executable, new String[]{"symbolic-ref", "--short", "HEAD"});
                this.checkExecutionResult(result);
                branch = result.out.trim();
                didWeDoAnything = true;
            } else {
                this.checkExecutionResult(result);
            }
        }
        result = this.executeCommand(this.executable, new String[]{"log", "--branches", "--not", "--remotes", "--simplify-by-decoration", "--decorate", "--oneline"});
        if (result.out.contains(branch)) {
            result = this.executeCommand(this.executable, new String[]{"-c", "core.askpass=true", "push", "--porcelain", "-u", "origin", branch});
            this.checkExecutionResult(result);
            didWeDoAnything = true;
        }
        this.invalidateStatusCache();
        return didWeDoAnything;
    }

    @Override
    protected Map<String, SourceControlManagement.Status> createStatusMap() throws IOException {
        return this.createStatusMap(true);
    }

    private Map<String, SourceControlManagement.Status> createStatusMap(boolean folder) throws IOException {
        HashMap<String, SourceControlManagement.Status> newMap = new HashMap<String, SourceControlManagement.Status>();
        List<String> paths = GitSourceControlManagement.readLines(this.executeCommand((String)this.executable, (String[])new String[]{"rev-parse", "--show-prefix"}).out);
        String relPath = paths.isEmpty() ? "" : paths.get(0);
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"status", "--porcelain"});
        for (String line : GitSourceControlManagement.readLines(result.out)) {
            if (StringUtils.isBlank((String)line)) continue;
            Object path = line.substring(3);
            if (((String)path).contains(" -> ")) {
                path = StringUtils.substringAfter((String)path, (String)" -> ");
            }
            path = StringUtils.removeEnd((String)path, (String)"/");
            path = StringUtils.removeStart((String)path, (String)relPath);
            char indexStatus = line.charAt(0);
            char workTreeStatus = line.charAt(1);
            SourceControlManagement.Status status = null;
            if (workTreeStatus == ' ') {
                if (indexStatus == 'M') {
                    status = SourceControlManagement.Status.MODIFIED;
                } else if (indexStatus == 'A') {
                    status = SourceControlManagement.Status.ADDED;
                } else if (indexStatus == 'D') {
                    status = SourceControlManagement.Status.DELETED;
                } else if (indexStatus == 'R') {
                    status = SourceControlManagement.Status.RENAMED;
                } else if (indexStatus == 'C') {
                    status = SourceControlManagement.Status.COPIED;
                }
            } else if (workTreeStatus == 'M') {
                status = SourceControlManagement.Status.MODIFIED;
            } else if (workTreeStatus == 'D') {
                status = indexStatus == 'D' || indexStatus == 'U' ? SourceControlManagement.Status.UNMERGED : SourceControlManagement.Status.DELETED;
            } else if (workTreeStatus == 'A' || workTreeStatus == 'U') {
                status = SourceControlManagement.Status.UNMERGED;
            } else if (workTreeStatus == '?') {
                status = SourceControlManagement.Status.UNTRACKED;
            }
            if (status == null) continue;
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            newMap.put((String)path, status);
            if (!folder) continue;
            StringBuilder subPath = new StringBuilder();
            for (String segment : StringUtils.split((String)path, (char)'/')) {
                newMap.put(subPath.length() == 0 ? "/" : subPath.toString(), SourceControlManagement.Status.MODIFIED);
                subPath.append('/');
                subPath.append(segment);
            }
        }
        return newMap;
    }

    @Override
    public File getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public String getURI() throws IOException {
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"remote", "-v"});
        String url = StringUtils.substringBefore((String)StringUtils.substringAfter((String)result.out, (String)"origin"), (String)"(").trim();
        if (!StringUtils.isEmpty((String)url)) {
            return "scm:git:" + url;
        }
        return null;
    }

    @Override
    protected void getFromSCM(File workingDirectory, String uri, String branchOrTag) throws IOException {
        this.rootFolder = workingDirectory.getParentFile();
        SourceControlManagement.ExecutionResult r = this.executeCommand(this.executable, new String[]{"-c", "core.askpass=true", "clone", uri, workingDirectory.getName()});
        if (r.exitValue > 0) {
            throw new SourceControlException(r.err);
        }
        this.rootFolder = workingDirectory;
        if (!StringUtils.isEmpty((String)branchOrTag)) {
            this.executeCommand(this.executable, new String[]{"checkout ", branchOrTag});
        }
        this.rootFolder = workingDirectory;
    }

    @Override
    protected void sendToSCM(File workingDirectory, String url) throws IOException {
        int MERGE_COMMAND_INDEX = 5;
        List<Object[]> commands = Arrays.asList({"init"}, {"add", "."}, {"commit", "-a", "-m", "First commit"}, {"remote", "add", "origin", url}, {"-c", "core.askpass=true", "fetch"}, {"merge", "origin/master", "--allow-unrelated-histories"}, {"-c", "core.askpass=true", "push", "-u", "origin", "master"});
        this.rootFolder = workingDirectory;
        for (Object[] command : commands) {
            logger.debug("executing command : {}", (Object)Arrays.toString(command));
            SourceControlManagement.ExecutionResult res = this.executeCommand(this.executable, (String[])command);
            if (Arrays.equals(command, commands.get(MERGE_COMMAND_INDEX)) || res.exitValue <= 0) continue;
            this.executeCommand(this.executable, new String[]{"merge", "--abort"});
            File gitDir = new File(workingDirectory.getPath() + "/.git");
            if (gitDir.exists()) {
                FileUtils.deleteDirectory((File)gitDir);
            }
            logger.error("unable to init git repository {} : {}", (Object)url, (Object)res.err);
            if (!StringUtils.isEmpty((String)res.out)) {
                logger.error(res.out);
            }
            StringBuilder message = new StringBuilder();
            if (!StringUtils.isEmpty((String)res.err)) {
                if (StringUtils.contains((String)res.err, (String)"tree files would be overwritten")) {
                    message.append("Unable to send sources to a non empty repository");
                } else if (StringUtils.contains((String)res.err, (String)"Repository not found")) {
                    message.append("Repository not found");
                } else {
                    message.append("Repository not accessible, see the log for more information");
                }
            } else {
                message.append("Repository not accessible, see the log for more information");
            }
            throw new SourceControlException("Unable to init git repository. " + message.toString());
        }
    }

    @Override
    protected void initWithWorkingDirectory(File workingDirectory) throws IOException {
        this.rootFolder = workingDirectory;
    }

    @Override
    public void markConflictAsResolved(File file) throws IOException {
        this.add(file);
    }

    @Override
    public void move(File src, File dst) throws IOException {
        if (src == null || dst == null) {
            return;
        }
        String rootPath = this.rootFolder.getPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add("mv");
        if (src.getPath().equals(rootPath)) {
            args.add(".");
        } else {
            args.add(src.getPath().substring(rootPath.length() + 1));
        }
        if (dst.getPath().equals(rootPath)) {
            args.add(".");
        } else {
            args.add(dst.getPath().substring(rootPath.length() + 1));
        }
        this.executeCommand(this.executable, args.toArray(new String[args.size()]));
        this.invalidateStatusCache();
    }

    @Override
    public void remove(File file) throws IOException {
        if (file == null) {
            return;
        }
        String rootPath = this.rootFolder.getPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add("rm");
        args.add("-f");
        if (file.getPath().equals(rootPath)) {
            args.add(".");
        } else {
            args.add(file.getPath().substring(rootPath.length() + 1));
        }
        this.executeCommand(this.executable, args.toArray(new String[args.size()]));
        this.invalidateStatusCache();
    }

    @Override
    public String update() throws IOException {
        Map<String, SourceControlManagement.Status> statusMap;
        boolean stashRequired;
        StringBuilder out = new StringBuilder();
        out.append("[").append(this.executable).append(" stash clear").append("]:\n");
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"stash", "clear"});
        out.append(result.out);
        out.append("\n");
        if (StringUtils.isNotEmpty((String)result.err)) {
            out.append(result.err).append("\n");
        }
        boolean bl = stashRequired = (statusMap = this.createStatusMap(false)).values().contains((Object)SourceControlManagement.Status.MODIFIED) || statusMap.values().contains((Object)SourceControlManagement.Status.ADDED) || statusMap.values().contains((Object)SourceControlManagement.Status.DELETED) || statusMap.values().contains((Object)SourceControlManagement.Status.RENAMED) || statusMap.values().contains((Object)SourceControlManagement.Status.COPIED) || statusMap.values().contains((Object)SourceControlManagement.Status.UNMERGED);
        if (stashRequired) {
            out.append("[").append(this.executable).append(" stash").append("]:\n");
            result = this.executeCommand(this.executable, new String[]{"stash"});
            out.append(result.out);
            out.append("\n");
            if (StringUtils.isNotEmpty((String)result.err)) {
                out.append(result.err).append("\n");
            }
        }
        out.append("[").append(this.executable).append(" pull --rebase").append("]:\n");
        SourceControlManagement.ExecutionResult pullResult = this.executeCommand(this.executable, new String[]{"pull", "--rebase"});
        out.append(pullResult.out);
        out.append("\n");
        if (StringUtils.isNotEmpty((String)pullResult.err)) {
            out.append(pullResult.err).append("\n");
        }
        SourceControlManagement.ExecutionResult stashPopResult = null;
        if (stashRequired) {
            out.append("[").append(this.executable).append(" stash pop").append("]:\n");
            stashPopResult = this.executeCommand(this.executable, new String[]{"stash", "pop"});
            out.append(stashPopResult.out);
            out.append("\n");
            if (StringUtils.isNotEmpty((String)stashPopResult.err)) {
                out.append(stashPopResult.err).append("\n");
            }
        }
        this.invalidateStatusCache();
        this.checkExecutionResult(pullResult);
        if (stashPopResult != null) {
            this.checkExecutionResult(stashPopResult);
        }
        return out.toString();
    }

    @Override
    public Map<String, String> getTagInfos(String uri) throws IOException {
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"ls-remote", "--tags", uri});
        List<String> lines = GitSourceControlManagement.readLines(result.out);
        Collections.reverse(lines);
        for (String line : lines) {
            String tag = StringUtils.substringAfter((String)line, (String)"refs/tags/");
            if (tag.endsWith("^{}")) continue;
            infos.put(tag, "scm:git:" + uri);
        }
        return infos;
    }

    @Override
    public Map<String, String> getBranchInfos(String uri) throws IOException {
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"ls-remote", "--heads", uri});
        List<String> lines = GitSourceControlManagement.readLines(result.out);
        Collections.reverse(lines);
        for (String line : lines) {
            String tag = StringUtils.substringAfter((String)line, (String)"refs/heads/");
            infos.put(tag, "scm:git:" + uri);
        }
        return infos;
    }
}

