/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.jahia.services.templates.GitSourceControlManagement;
import org.jahia.services.templates.SourceControlManagement;
import org.jahia.services.templates.SvnSourceControlManagement;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.StringOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceControlFactory {
    private static final Logger logger = LoggerFactory.getLogger(SourceControlFactory.class);
    private Map<String, String> sourceControlExecutables;
    private List<String> ignoredFiles;

    public List<String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public void setIgnoredFiles(List<String> ignoredFiles) {
        this.ignoredFiles = ignoredFiles;
    }

    public SourceControlManagement checkoutRepository(File workingDir, String scmURI, String branchOrTag, boolean initRepository) throws IOException {
        SourceControlManagement scm = this.getSCM(scmURI);
        if (scm != null) {
            String scmUrl = this.getScmURL(scmURI);
            if (initRepository) {
                this.addIgnore(workingDir);
                scm.sendToSCM(workingDir, scmUrl);
            } else {
                scm.getFromSCM(workingDir, scmUrl, branchOrTag);
            }
        }
        return scm;
    }

    private void addIgnore(File path) throws IOException {
        File ignore = new File(path, ".gitignore");
        ArrayList<String> lines = ignore.exists() ? FileUtils.readLines((File)ignore, (String)"UTF-8") : new ArrayList<String>();
        for (String ignoredFile : this.ignoredFiles) {
            if (lines.contains(ignoredFile)) continue;
            lines.add(ignoredFile);
        }
        FileUtils.writeLines((File)ignore, (String)"UTF-8", lines);
    }

    public Map<String, String> listTags(String scmURI) throws IOException {
        SourceControlManagement scm = this.getSCM(scmURI);
        if (scm != null) {
            String scmUrl = this.getScmURL(scmURI);
            return scm.getTagInfos(scmUrl);
        }
        return null;
    }

    public Map<String, String> listBranches(String scmURI) throws IOException {
        SourceControlManagement scm = this.getSCM(scmURI);
        if (scm != null) {
            String scmUrl = this.getScmURL(scmURI);
            return scm.getBranchInfos(scmUrl);
        }
        return null;
    }

    private SourceControlManagement getSCM(String scmURI) throws IOException {
        SourceControlManagement scm = null;
        if (scmURI.startsWith("scm:")) {
            String scmProvider = scmURI.substring(4, scmURI.indexOf(":", 4));
            if (scmProvider.equals("git") && this.sourceControlExecutables.containsKey("git")) {
                scm = new GitSourceControlManagement(this.sourceControlExecutables.get("git"));
            } else if (scmProvider.equals("svn") && this.sourceControlExecutables.containsKey("svn")) {
                scm = new SvnSourceControlManagement(this.sourceControlExecutables.get("svn"));
            } else {
                throw new IOException("Unknown repository type");
            }
        }
        return scm;
    }

    private String getScmURL(String scmURI) {
        return scmURI.substring(scmURI.indexOf(":", 4) + 1);
    }

    public Map<String, String> getSourceControlExecutables() {
        return this.sourceControlExecutables;
    }

    public SourceControlManagement getSourceControlManagement(File workingDir) throws IOException {
        SourceControlManagement scm = null;
        File dir = workingDir;
        do {
            if (new File(dir, ".git").exists()) {
                if (!this.sourceControlExecutables.containsKey("git")) break;
                scm = new GitSourceControlManagement(this.sourceControlExecutables.get("git"));
                continue;
            }
            if (new File(dir, ".svn").exists()) {
                if (!this.sourceControlExecutables.containsKey("svn")) break;
                scm = new SvnSourceControlManagement(this.sourceControlExecutables.get("svn"));
                continue;
            }
            dir = dir.getParentFile();
        } while (scm == null && dir != null);
        if (scm != null) {
            scm.initWithWorkingDirectory(workingDir);
        }
        return scm;
    }

    public Set<String> getSupportedSourceControls() {
        return this.sourceControlExecutables.keySet();
    }

    public void setSourceControlExecutables(Map<String, String> sourceControlExecutables) {
        this.sourceControlExecutables = new HashMap<String, String>();
        if (!SettingsBean.getInstance().isDevelopmentMode()) {
            logger.info("Skipping SCM executables registration in non development mode.");
            return;
        }
        for (Map.Entry<String, String> entry : sourceControlExecutables.entrySet()) {
            try {
                DefaultExecutor executor = new DefaultExecutor();
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new StringOutputStream(), (OutputStream)new StringOutputStream()));
                executor.execute(new CommandLine(entry.getValue()), System.getenv());
            }
            catch (ExecuteException executor) {
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to execute the " + entry.getKey() + " SCM executable: " + entry.getValue() + ". The SCM provider will be disabled. Cause: " + e.getMessage(), (Throwable)e);
                    continue;
                }
                logger.info("Cannot find a valid " + entry.getKey() + " SCM executable at: " + entry.getValue() + ". The SCM provider will be skipped.");
                continue;
            }
            this.sourceControlExecutables.put(entry.getKey(), entry.getValue());
        }
    }
}

