/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean.toolbar;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ActionItem;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.uicomponents.bean.Visibility;
import org.jahia.services.uicomponents.bean.contentmanager.ManagerConfiguration;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.uicomponents.bean.toolbar.Menu;
import org.jahia.services.uicomponents.bean.toolbar.Property;
import org.jahia.services.uicomponents.bean.toolbar.Selected;
import org.jahia.services.uicomponents.bean.toolbar.Toolbar;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Item
implements Serializable,
BeanNameAware,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final long serialVersionUID = -5120594370234680709L;
    private String id;
    private String icon;
    private String title;
    private String titleKey;
    private boolean displayTitle = true;
    private String descriptionKey;
    private Visibility visibility;
    private Selected selected;
    private String layout;
    private List<String> requiredPermissions = Collections.emptyList();
    private List<String> requiredSitePermissions = Collections.emptyList();
    private PermissionsStrategy requiredPermissionsStrategy = PermissionsStrategy.MATCH_ALL;
    private String requiredModule;
    private boolean hideWhenDisabled;
    private List<Property> properties = new ArrayList<Property>();
    private ActionItem actionItem;
    private Object parent;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;
    private ApplicationContext applicationContext;

    public Item() {
    }

    private Item(String id) {
        this();
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public boolean isDisplayTitle() {
        return this.displayTitle;
    }

    public void setDisplayTitle(boolean displayTitle) {
        this.displayTitle = displayTitle;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Selected getSelected() {
        return this.selected;
    }

    public void setSelected(Selected selected) {
        this.selected = selected;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void setBeanName(String name) {
        this.id = name;
    }

    public ActionItem getActionItem() {
        return this.actionItem;
    }

    public void setActionItem(ActionItem actionItem) {
        this.actionItem = actionItem;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    @Deprecated(since="8.0.0.0", forRemoval=true)
    public String getRequiredPermission() {
        return this.requiredPermissions.isEmpty() ? null : this.requiredPermissions.get(0);
    }

    public final List<String> getRequiredPermissions() {
        return Collections.unmodifiableList(this.requiredPermissions);
    }

    public List<String> getRequiredSitePermissions() {
        return Collections.unmodifiableList(this.requiredSitePermissions);
    }

    public final PermissionsStrategy getRequiredPermissionsStrategy() {
        return this.requiredPermissionsStrategy;
    }

    public String getRequiredModule() {
        return this.requiredModule;
    }

    public void setRequiredModule(String requiredModule) {
        this.requiredModule = requiredModule;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermissions = requiredPermission == null ? Collections.emptyList() : Collections.singletonList(requiredPermission);
    }

    public final void setRequiredPermissions(List<String> requiredPermissions) {
        Objects.requireNonNull(requiredPermissions);
        this.requiredPermissions = new ArrayList<String>(requiredPermissions);
    }

    public void setRequiredSitePermissions(String requiredSitePermissions) {
        Objects.requireNonNull(requiredSitePermissions);
        this.requiredSitePermissions = new ArrayList<String>();
        for (String token : requiredSitePermissions.split(",")) {
            this.requiredSitePermissions.add(token.trim());
        }
    }

    public final void setRequiredPermissionsStrategy(PermissionsStrategy permissionsStrategy) {
        this.requiredPermissionsStrategy = Objects.requireNonNull(permissionsStrategy);
    }

    public boolean isHideWhenDisabled() {
        return this.hideWhenDisabled;
    }

    public void setHideWhenDisabled(boolean hideWhenDisabled) {
        this.hideWhenDisabled = hideWhenDisabled;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setParentMenu(Menu menu) {
        this.setParent(menu);
    }

    public void setParentToolbar(Toolbar toolbar) {
        this.setParent(toolbar);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.parent != null) {
            if (this.parent instanceof List) {
                for (Object o : (List)this.parent) {
                    this.addItem(this.getItems(o));
                }
            } else {
                this.addItem(this.getItems(this.parent));
            }
        }
    }

    private void addItem(List<List<Item>> items) {
        if (!items.isEmpty()) {
            this.removeItem(items, this.getId());
            for (List<Item> it : items) {
                int index = -1;
                if (this.position >= 0) {
                    index = this.position;
                } else if (this.positionBefore != null) {
                    index = it.indexOf(new Item(this.positionBefore));
                } else if (this.positionAfter != null) {
                    index = it.indexOf(new Item(this.positionAfter));
                    if (index != -1) {
                        ++index;
                    }
                    if (index >= it.size()) {
                        index = -1;
                    }
                }
                if (index != -1) {
                    it.add(index, this);
                    continue;
                }
                it.add(this);
            }
        }
    }

    public void destroy() throws Exception {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        if (this.parent instanceof List) {
            for (Object o : (List)this.parent) {
                this.removeItem(this.getItems(o), this.getId());
            }
        } else {
            this.removeItem(this.getItems(this.parent), this.getId());
        }
    }

    private void removeItem(List<List<Item>> items, String itemId) {
        if (!items.isEmpty() && itemId != null && !itemId.isEmpty()) {
            for (List<Item> it : items) {
                Iterator<Item> iterator = it.iterator();
                while (iterator.hasNext()) {
                    Item tab = iterator.next();
                    if (!itemId.equals(tab.getId())) continue;
                    iterator.remove();
                }
            }
        }
    }

    private List<List<Item>> getItems(Object parent) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ArrayList<List<Item>> results = new ArrayList<List<Item>>();
        if (parent == null) {
            return results;
        }
        if (parent instanceof String) {
            String parentPath = (String)parent;
            String beanId = StringUtils.substringBefore((String)parentPath, (String)".");
            Object bean = SpringContextSingleton.getBean(beanId);
            String propertyPath = StringUtils.substringAfter((String)parentPath, (String)".");
            if (bean instanceof EditConfiguration || bean instanceof ManagerConfiguration) {
                for (Map.Entry<String, ?> entry : SpringContextSingleton.getBeansOfType(this.applicationContext, bean.getClass()).entrySet()) {
                    if (!entry.getKey().startsWith(beanId + "-")) continue;
                    results.addAll(this.getItems(this.resolveProperty(parentPath, entry.getValue(), propertyPath)));
                }
            }
            parent = this.resolveProperty(parentPath, bean, propertyPath);
        }
        if (parent instanceof Menu) {
            Menu parentMenu = (Menu)parent;
            results.add(parentMenu.getItems());
        } else if (parent instanceof Toolbar) {
            Toolbar parentToolbar = (Toolbar)parent;
            results.add(parentToolbar.getItems());
        } else if (parent instanceof List) {
            results.add((List)parent);
        } else {
            throw new IllegalArgumentException("Unknown parent type '" + parent.getClass().getName() + "'. Can accept Menu, Toolbar or a String value with a bean-compliant path to the corresponding menu/toobar bean");
        }
        return results;
    }

    private Object resolveProperty(String parentPath, Object bean, String propertyPath) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (propertyPath.length() > 0) {
            bean = PropertyUtils.getNestedProperty((Object)bean, (String)propertyPath);
        }
        if (bean == null) {
            throw new IllegalArgumentException("Unable to find target for parent path: " + parentPath);
        }
        if (!(bean instanceof Menu) && !(bean instanceof Toolbar)) {
            throw new IllegalArgumentException("Target bean for path '" + parentPath + "' is not of type Menu or Toolbar. Unable to handle beans of type '" + bean.getClass().getName() + "'");
        }
        return bean;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Item other = (Item)obj;
            return this.getId() != null ? other.getId() != null && this.getId().equals(other.getId()) : other.getId() == null;
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }

    public static enum PermissionsStrategy {
        MATCH_ALL,
        MATCH_ANY;

    }
}

