/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.QueryParser;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.BridgeEvents;
import org.jahia.services.usermanager.GroupCacheHelper;
import org.jahia.services.usermanager.JahiaGroupManagerProvider;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaGroupManagerService
extends JahiaService {
    private static Logger logger = LoggerFactory.getLogger(JahiaGroupManagerService.class);
    public static final String USERS_GROUPNAME = "users";
    public static final String SITE_USERS_GROUPNAME = "site-users";
    public static final String ADMINISTRATORS_GROUPNAME = "administrators";
    public static final String PRIVILEGED_GROUPNAME = "privileged";
    public static final String SITE_PRIVILEGED_GROUPNAME = "site-privileged";
    public static final String SITE_ADMINISTRATORS_GROUPNAME = "site-administrators";
    public static final String GUEST_GROUPNAME = "guest";
    public static final String GUEST_GROUPPATH = "/groups/guest";
    public static final String USERS_GROUPPATH = "/groups/users";
    public static final Set<String> POWERFUL_GROUPS = new HashSet<String>(Arrays.asList("administrators", "site-administrators", "privileged", "site-privileged"));
    public static final Set<String> PROTECTED_GROUPS = new HashSet<String>(Arrays.asList("users", "site-users", "privileged", "site-privileged", "guest", "administrators"));
    private JahiaUserManagerService userManagerService;
    private Map<String, JahiaGroupManagerProvider> legacyGroupProviders = new HashMap<String, JahiaGroupManagerProvider>();
    private GroupCacheHelper cacheHelper;

    private static Pattern getGroupNamePattern() {
        return PatternHolder.INSTANCE;
    }

    public static JahiaGroupManagerService getInstance() {
        return Holder.INSTANCE;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    public JCRGroupNode lookupGroup(String groupPath) {
        return this.lookupGroupByPath(groupPath);
    }

    public JCRGroupNode lookupGroupByPath(String groupPath) {
        try {
            return this.lookupGroupByPath(groupPath, JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null));
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public JCRGroupNode lookupGroupByPath(String groupPath, JCRSessionWrapper session) {
        try {
            return (JCRGroupNode)session.getNode(groupPath);
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public JCRGroupNode lookupGroup(String siteKey, String name) {
        try {
            return this.lookupGroup(siteKey, name, JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null));
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public JCRGroupNode lookupGroup(String siteKey, String name, JCRSessionWrapper session) {
        String path = this.getGroupPath(siteKey, name);
        if (path == null) {
            return null;
        }
        return this.lookupGroupByPath(path, session);
    }

    public String getGroupPath(String siteKey, String name) {
        return this.cacheHelper.getGroupPath(siteKey, name);
    }

    public boolean groupExists(String siteKey, String name) {
        return this.lookupGroup(siteKey, name) != null;
    }

    public JCRGroupNode getAdministratorGroup(String siteKey) throws RepositoryException {
        return this.getAdministratorGroup(siteKey, JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null));
    }

    public JCRGroupNode getAdministratorGroup(String siteKey, JCRSessionWrapper session) throws RepositoryException {
        return this.lookupGroupByPath((String)(siteKey == null ? "/groups/administrators" : "/sites/" + siteKey + "/groups/site-administrators"), session);
    }

    public List<String> getGroupList() {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            ArrayList<String> groups = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                String query = "SELECT [j:nodename] FROM [jnt:group] as group ORDER BY group.[j:nodename]";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row groupsFolderNode = rows.nextRow();
                    String groupName = groupsFolderNode.getPath();
                    if (groups.contains(groupName)) continue;
                    groups.add(groupName);
                }
            }
            return groups;
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving group list", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public List<String> getGroupList(String siteKey) {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            ArrayList<String> groups = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                Object constraint = siteKey != null ? "(isdescendantnode(group,'/sites/" + siteKey + "/groups') or isdescendantnode(group,'/groups/providers'))" : "isdescendantnode(group,'/groups')";
                String query = "SELECT [j:nodename] FROM [jnt:group] as group WHERE " + (String)constraint + " ORDER BY group.[j:nodename]";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row groupNode = rows.nextRow();
                    String groupPath = groupNode.getPath();
                    if (groups.contains(groupPath)) continue;
                    groups.add(groupPath);
                }
            }
            return groups;
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving group list", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public List<String> getGroupnameList() {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            ArrayList<String> groups = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                String query = "SELECT [j:nodename] FROM [jnt:group] as group ORDER BY group.[j:nodename]";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row groupNode = rows.nextRow();
                    String groupName = groupNode.getValue("j:nodename").getString();
                    if (groups.contains(groupName)) continue;
                    groups.add(groupName);
                }
            }
            return groups;
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving group name list", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public Set<JCRGroupNode> searchGroups(String siteKey, Properties searchCriterias) {
        try {
            return this.searchGroups(siteKey, searchCriterias, JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null));
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public Set<JCRGroupNode> searchGroups(String siteKey, Properties searchCriterias, String[] providers) {
        try {
            return this.searchGroups(siteKey, searchCriterias, providers, JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null));
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public Set<JCRGroupNode> searchGroups(String siteKey, Properties searchCriterias, JCRSessionWrapper session) {
        return this.searchGroups(siteKey, searchCriterias, null, session);
    }

    public Set<JCRGroupNode> searchGroups(String siteKey, Properties searchCriterias, String[] providers, JCRSessionWrapper session) {
        return this.searchGroups(siteKey, searchCriterias, providers, false, session);
    }

    public Set<JCRGroupNode> searchGroups(String siteKey, Properties searchCriterias, String[] providers, boolean excludeProtected, JCRSessionWrapper session) {
        if (providers != null) {
            HashSet<JCRGroupNode> groups = new HashSet<JCRGroupNode>();
            for (String providerKey : providers) {
                groups.addAll(this.searchGroups(siteKey, searchCriterias, providerKey, excludeProtected, session));
            }
            return groups;
        }
        return this.searchGroups(siteKey, searchCriterias, (String)null, excludeProtected, session);
    }

    public Set<JCRGroupNode> searchGroups(String siteKey, Properties searchCriterias, String providerKey, boolean excludeProtected, JCRSessionWrapper session) {
        try {
            HashSet<JCRGroupNode> groups = new HashSet<JCRGroupNode>();
            if (session.getWorkspace().getQueryManager() != null) {
                Iterator<Object> objectIterator;
                StringBuilder query = new StringBuilder(128);
                if (providerKey != null) {
                    JCRStoreProvider provider = this.getProvider(siteKey, providerKey, session);
                    if (provider != null) {
                        query.append("(");
                        if (provider.isDefault()) {
                            query.append("g.[j:external] = false");
                        } else {
                            query.append("ISDESCENDANTNODE('").append(provider.getMountPoint()).append("')");
                        }
                        query.append(')');
                    } else {
                        return groups;
                    }
                }
                if (!(searchCriterias == null || searchCriterias.size() <= 0 || searchCriterias.containsKey("*") && searchCriterias.size() == 1 && searchCriterias.getProperty("*").equals("*") || !(objectIterator = searchCriterias.entrySet().iterator()).hasNext())) {
                    query.append(query.length() > 0 ? " AND " : "").append(" (");
                    while (objectIterator.hasNext()) {
                        Object propertyValue;
                        Map.Entry entry = (Map.Entry)objectIterator.next();
                        String propertyKey = (String)entry.getKey();
                        if ("groupname".equals(propertyKey)) {
                            propertyKey = "j:nodename";
                        }
                        propertyValue = "*".equals(propertyValue = (String)entry.getValue()) ? "%" : (((String)propertyValue).indexOf(42) != -1 ? Patterns.STAR.matcher((CharSequence)propertyValue).replaceAll("%") : (String)propertyValue + "%");
                        propertyValue = JCRContentUtils.sqlEncode((String)propertyValue);
                        if ("*".equals(propertyKey)) {
                            query.append("(CONTAINS(g.*,'").append(QueryParser.escape((String)Patterns.PERCENT.matcher((CharSequence)propertyValue).replaceAll(""))).append("') OR LOWER(g.[j:nodename]) LIKE '").append(((String)propertyValue).toLowerCase()).append("') ");
                        } else {
                            query.append("LOWER(g.[").append(Patterns.DOT.matcher(propertyKey).replaceAll("\\\\.")).append("])").append(" LIKE '").append(((String)propertyValue).toLowerCase()).append("'");
                        }
                        if (!objectIterator.hasNext()) continue;
                        query.append(" OR ");
                    }
                    query.append(")");
                }
                if (query.length() > 0) {
                    query.insert(0, " and ");
                }
                if (excludeProtected) {
                    for (String g : PROTECTED_GROUPS) {
                        query.insert(0, " and [j:nodename] <> '" + g + "'");
                    }
                }
                Object s = siteKey == null ? "/groups/" : "/sites/" + siteKey + "/groups/";
                query.insert(0, "SELECT * FROM [jnt:group] as g where isdescendantnode(g,'" + JCRContentUtils.sqlEncode((String)s) + "')");
                query.append(" ORDER BY g.[j:nodename]");
                if (logger.isDebugEnabled()) {
                    logger.debug(query.toString());
                }
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "JCR-SQL2");
                QueryResult qr = q.execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    groups.add((JCRGroupNode)ni.nextNode());
                }
            }
            return groups;
        }
        catch (RepositoryException e) {
            logger.error("Error while searching for groups", (Throwable)e);
            return new HashSet<JCRGroupNode>();
        }
    }

    public List<JCRStoreProvider> getProviderList(String siteKey, JCRSessionWrapper session) {
        LinkedList<JCRStoreProvider> providers = new LinkedList<JCRStoreProvider>();
        try {
            providers.add(JCRSessionFactory.getInstance().getDefaultProvider());
            String providersParentPath = (String)(siteKey == null ? "" : "/sites/" + siteKey) + "/groups/providers";
            JCRNodeWrapper providersNode = session.getNode(providersParentPath);
            JCRNodeIteratorWrapper iterator = providersNode.getNodes();
            while (iterator.hasNext()) {
                JCRNodeWrapper providerNode = (JCRNodeWrapper)iterator.next();
                providers.add(providerNode.getProvider());
            }
        }
        catch (PathNotFoundException providersParentPath) {
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving user providers", (Throwable)e);
        }
        return providers;
    }

    public List<JCRStoreProvider> getProviders(String siteKey, String[] providerKeys, JCRSessionWrapper session) {
        if (ArrayUtils.isEmpty((Object[])providerKeys)) {
            return Collections.emptyList();
        }
        LinkedList<JCRStoreProvider> providers = new LinkedList<JCRStoreProvider>();
        for (JCRStoreProvider provider : this.getProviderList(siteKey, session)) {
            if (!ArrayUtils.contains((Object[])providerKeys, (Object)provider.getKey())) continue;
            providers.add(provider);
        }
        return providers;
    }

    public JCRStoreProvider getProvider(String siteKey, String providerKey, JCRSessionWrapper session) {
        List<JCRStoreProvider> providers = this.getProviders(siteKey, new String[]{providerKey}, session);
        return providers.size() == 1 ? providers.get(0) : null;
    }

    public List<String> getUserMembership(String userName, String site) {
        String userPath = this.userManagerService.getUserPath(userName, site);
        if (userPath == null) {
            return null;
        }
        return this.getMembershipByPath(userPath);
    }

    public boolean isMember(String username, String groupname, String groupSite) {
        return this.isMember(username, null, groupname, groupSite);
    }

    public boolean isMember(String username, String userSite, String groupname, String groupSite) {
        List<String> userMembership = this.getUserMembership(username, userSite);
        return userMembership != null && userMembership.contains(this.getGroupPath(groupSite, groupname));
    }

    public boolean isAdminMember(String username, String siteKey) {
        return this.isAdminMember(username, null, siteKey);
    }

    public boolean isAdminMember(String username, String userSite, String siteKey) {
        return username.equals(this.userManagerService.getRootUserName()) || this.isMember(username, userSite, siteKey == null ? ADMINISTRATORS_GROUPNAME : SITE_ADMINISTRATORS_GROUPNAME, siteKey);
    }

    public JCRGroupNode createGroup(String siteKey, String name, Properties properties, boolean hidden, JCRSessionWrapper session) {
        try {
            JCRNodeWrapper parentNodeWrapper = siteKey == null ? session.getNode("/groups") : session.getNode("/sites/" + siteKey + "/groups");
            JCRGroupNode nodeWrapper = (JCRGroupNode)parentNodeWrapper.addNode(name, "jnt:group");
            nodeWrapper.setProperty("j:hidden", hidden);
            if (properties != null) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    if (entry.getValue() instanceof Boolean) {
                        nodeWrapper.setProperty((String)entry.getKey(), (Boolean)entry.getValue());
                        continue;
                    }
                    nodeWrapper.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            return nodeWrapper;
        }
        catch (RepositoryException e) {
            logger.error("Error while creating group", (Throwable)e);
            return null;
        }
    }

    public boolean deleteGroup(String groupPath, JCRSessionWrapper session) {
        try {
            JCRNodeWrapper node = session.getNode(groupPath);
            PropertyIterator pi = node.getWeakReferences("j:member");
            while (pi.hasNext()) {
                JCRPropertyWrapper member = (JCRPropertyWrapper)pi.next();
                member.getParent().remove();
            }
            QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:member] as m where isdescendantnode(m,'" + JCRContentUtils.sqlEncode(node.getPath()) + "')", "JCR-SQL2");
            NodeIterator ni = q.execute().getNodes();
            while (ni.hasNext()) {
                this.cacheHelper.getMembershipCache().remove((Serializable)((Object)("/" + StringUtils.substringAfter((String)ni.nextNode().getPath(), (String)"/j:members/"))));
            }
            node.remove();
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            logger.error("Error while deleting group", (Throwable)e);
            return false;
        }
    }

    public boolean isGroupNameSyntaxCorrect(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        boolean usernameCorrect = JahiaGroupManagerService.getGroupNamePattern().matcher(name).matches();
        if (!usernameCorrect && logger.isDebugEnabled()) {
            logger.debug("Validation failed for the user name: " + name + " against pattern: " + JahiaGroupManagerService.getGroupNamePattern().pattern());
        }
        return usernameCorrect;
    }

    public void flushMembershipCache(String memberPath, JCRSessionWrapper session) {
        String key = StringUtils.substringAfter((String)memberPath, (String)"/j:members/");
        JCRGroupNode groupNode = this.lookupGroupByPath("/" + key, session);
        if (groupNode != null) {
            for (JCRNodeWrapper member : groupNode.getMembers()) {
                this.flushMembershipCache("/" + key + "/j:members" + member.getPath(), session);
            }
            if (groupNode.getPath().equals(GUEST_GROUPPATH) || groupNode.getPath().equals(USERS_GROUPPATH) || groupNode.getName().equals(SITE_USERS_GROUPNAME)) {
                this.cacheHelper.getMembershipCache().removeAll();
            }
        }
        if (key.contains("/")) {
            this.cacheHelper.getMembershipCache().remove((Serializable)((Object)("/" + key)));
        } else {
            this.cacheHelper.getMembershipCache().removeAll();
        }
    }

    public void updatePathCacheAdded(String groupPath) {
        this.cacheHelper.updatePathCacheAdded(groupPath);
    }

    public void updatePathCacheRemoved(String groupPath) {
        this.cacheHelper.updatePathCacheRemoved(groupPath);
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public List<? extends JahiaGroupManagerProvider> getProviderList() {
        return new ArrayList<JahiaGroupManagerProvider>(this.legacyGroupProviders.values());
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public JahiaGroupManagerProvider getProvider(String key) {
        return this.legacyGroupProviders.get(key);
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public void registerProvider(JahiaGroupManagerProvider jahiaGroupManagerProvider) {
        this.legacyGroupProviders.put(jahiaGroupManagerProvider.getKey(), jahiaGroupManagerProvider);
        BridgeEvents.sendEvent(jahiaGroupManagerProvider.getKey(), "org/jahia/usersgroups/groupProvider/REGISTER");
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public void unregisterProvider(JahiaGroupManagerProvider jahiaGroupManagerProvider) {
        this.legacyGroupProviders.remove(jahiaGroupManagerProvider.getKey());
        BridgeEvents.sendEvent(jahiaGroupManagerProvider.getKey(), "org/jahia/usersgroups/groupProvider/UNREGISTER");
    }

    public void setCacheHelper(GroupCacheHelper cacheHelper) {
        this.cacheHelper = cacheHelper;
    }

    public void clearNonExistingGroupsCache() {
        this.cacheHelper.clearNonExistingGroupsCache();
    }

    public List<String> getMembershipByPath(String principalPath) {
        ArrayList<CallSite> owners = (ArrayList<CallSite>)this.cacheHelper.getMembershipCache().get((Serializable)((Object)principalPath)).getObjectValue();
        if (principalPath.startsWith("/users/") && !principalPath.equals("/users/guest")) {
            owners = owners != null ? new ArrayList<CallSite>(owners) : new ArrayList();
            for (String s : JahiaSitesService.getInstance().getSitesNames()) {
                String siteUsersGroup = "/sites/" + s + "/groups/site-users";
                owners.add((CallSite)((Object)siteUsersGroup));
                owners.addAll((List)this.cacheHelper.getMembershipCache().get((Serializable)((Object)siteUsersGroup)).getObjectValue());
            }
        }
        return owners;
    }

    private static class Holder {
        static final JahiaGroupManagerService INSTANCE = new JahiaGroupManagerService();

        private Holder() {
        }
    }

    private static class PatternHolder {
        static final Pattern INSTANCE = Pattern.compile(SettingsBean.getInstance().lookupString("userManagementGroupNamePattern"));

        private PatternHolder() {
        }
    }
}

