/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jahia.services.usermanager.UserProperty;
import org.jahia.services.usermanager.UserPropertyReadOnlyException;

@Deprecated(since="7.2.0.0", forRemoval=true)
public class UserProperties
implements Serializable {
    private static final long serialVersionUID = -5885566091509965795L;
    public static final Set<String> DEFAULT_PROPERTIES_NAME = new HashSet<String>();
    private Map<String, UserProperty> properties = new HashMap<String, UserProperty>();

    public UserProperties() {
    }

    public UserProperties(Properties properties, boolean readOnly) {
        Enumeration<?> sourceNameEnum = properties.propertyNames();
        while (sourceNameEnum.hasMoreElements()) {
            String curSourceName = (String)sourceNameEnum.nextElement();
            UserProperty curUserProperty = new UserProperty(curSourceName, properties.getProperty(curSourceName), readOnly);
            this.properties.put(curSourceName, curUserProperty);
        }
    }

    public UserProperties(UserProperties copy) {
        this.properties = copy.properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new UserProperty((UserProperty)e.getValue())));
    }

    public void putAll(UserProperties ups) {
        ups.properties.keySet().removeAll(this.properties.keySet());
        this.properties.putAll(ups.properties);
    }

    public void putAll(Properties ups) {
        this.properties.keySet().removeAll(this.properties.keySet());
        for (Object o : ups.keySet()) {
            String propName = o.toString();
            this.properties.put(propName, new UserProperty(propName, "", false));
        }
    }

    public UserProperty getUserProperty(String name) {
        return this.properties.get(name);
    }

    public void setUserProperty(String name, UserProperty value) {
        this.properties.put(name, value);
    }

    public UserProperty removeUserProperty(String name) {
        return this.properties.remove(name);
    }

    public boolean isReadOnly(String name) {
        UserProperty userProperty = this.properties.get(name);
        return userProperty != null && userProperty.isReadOnly();
    }

    public Iterator<String> propertyNameIterator() {
        return this.properties.keySet().iterator();
    }

    public Properties getProperties() {
        Properties propertiesCopy = new Properties();
        Iterator<Map.Entry<String, UserProperty>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, UserProperty> o;
            Map.Entry<String, UserProperty> curEntry = o = iterator.next();
            UserProperty curUserProperty = curEntry.getValue();
            propertiesCopy.put(curUserProperty.getName(), curUserProperty.getValue());
        }
        return propertiesCopy;
    }

    public String getProperty(String name) {
        UserProperty userProperty = this.properties.get(name);
        return userProperty != null ? userProperty.getValue() : null;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void setProperty(String name, String value) throws UserPropertyReadOnlyException {
        UserProperty userProperty = this.properties.get(name);
        if (userProperty != null) {
            if (userProperty.isReadOnly()) {
                throw new UserPropertyReadOnlyException(userProperty, "Property " + name + " is readonly");
            }
            userProperty.setValue(value);
        } else {
            userProperty = new UserProperty(name, value, false);
        }
        this.properties.put(name, userProperty);
    }

    public String removeProperty(String name) throws UserPropertyReadOnlyException {
        UserProperty userProperty = this.properties.get(name);
        if (userProperty != null) {
            if (userProperty.isReadOnly()) {
                throw new UserPropertyReadOnlyException(userProperty, "Property " + name + " is readonly");
            }
            return userProperty.getValue();
        }
        return null;
    }

    public int size() {
        return this.properties.keySet().size();
    }

    public String toString() {
        return this.getProperties().toString();
    }

    static {
        DEFAULT_PROPERTIES_NAME.add("email");
        DEFAULT_PROPERTIES_NAME.add("lastname");
        DEFAULT_PROPERTIES_NAME.add("firstname");
        DEFAULT_PROPERTIES_NAME.add("organization");
        DEFAULT_PROPERTIES_NAME.add("emailNotificationsDisabled");
        DEFAULT_PROPERTIES_NAME.add("preferredLanguage");
    }
}

