/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.AssignAndCompleteTaskJob;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.HistoryWorkflowTask;
import org.jahia.services.workflow.StartProcessJob;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowAction;
import org.jahia.services.workflow.WorkflowComment;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowListener;
import org.jahia.services.workflow.WorkflowObservationManager;
import org.jahia.services.workflow.WorkflowObservationManagerAware;
import org.jahia.services.workflow.WorkflowProvider;
import org.jahia.services.workflow.WorkflowRule;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.services.workflow.WorkflowVariable;
import org.jahia.services.workflow.WorklowTypeRegistration;
import org.jahia.settings.readonlymode.ReadOnlyModeCapable;
import org.jahia.settings.readonlymode.ReadOnlyModeException;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;

public class WorkflowService
implements BeanPostProcessor,
ApplicationListener<JahiaTemplateManagerService.ModuleDeployedOnSiteEvent>,
ReadOnlyModeCapable {
    public static final String CANDIDATE = "candidate";
    public static final String START_ROLE = "start";
    public static final String WORKFLOWRULES_NODE_NAME = "j:workflowRules";
    private static final String WORKFLOWTASKS_NODE_NAME = "workflow-tasks";
    private static final Logger logger = LoggerFactory.getLogger(WorkflowService.class);
    private static WorkflowService instance = new WorkflowService();
    private Map<String, WorkflowProvider> providers = new HashMap<String, WorkflowProvider>();
    private Map<String, WorklowTypeRegistration> workflowRegistrationByDefinition = new HashMap<String, WorklowTypeRegistration>();
    private Map<String, String> modulesForWorkflowDefinition = new HashMap<String, String>();
    private JCRTemplate jcrTemplate;
    private WorkflowObservationManager observationManager = new WorkflowObservationManager(this);
    private CacheService cacheService;
    private Cache<String, Map<String, WorkflowRule>> cache;
    private boolean servicesStarted = false;
    private final ReadWriteLock readOnlyModeLock = new ReentrantReadWriteLock();
    private boolean readOnly;

    public static WorkflowService getInstance() {
        return instance;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void start() throws JahiaInitializationException {
        if (this.cacheService != null) {
            this.cache = this.cacheService.getCache("WorkflowRuleCache", true);
        }
    }

    public synchronized void registerWorkflowType(WorklowTypeRegistration type) {
        if (type != null && !this.workflowRegistrationByDefinition.containsKey(type.getDefinition())) {
            this.workflowRegistrationByDefinition.put(type.getDefinition(), type);
            if (this.servicesStarted) {
                this.doRegisterWorkflowType(type);
            }
        }
    }

    private void doRegisterWorkflowType(final WorklowTypeRegistration type) {
        if (type.getModule() != null) {
            this.modulesForWorkflowDefinition.put(type.getDefinition(), type.getModule().getId());
            for (WorkflowProvider provider : this.providers.values()) {
                final WorkflowDefinition def = provider.getWorkflowDefinitionByKey(type.getDefinition(), null);
                if (def == null) continue;
                try {
                    JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            boolean updated = WorkflowService.this.initializePermission(session, def, type.getModule());
                            if (updated) {
                                session.save();
                                JahiaPrivilegeRegistry.addModulePrivileges(session, "/modules/" + type.getModule().getIdWithVersion());
                            }
                            return null;
                        }
                    });
                }
                catch (RepositoryException e) {
                    logger.error("Cannot register workflow permissions", (Throwable)e);
                }
                type.setProvider(provider.getKey());
                this.cache.flush();
                ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().addPackageForResourceBundle(def.getPackageName() + "." + type.getDefinition(), type.getModule());
                break;
            }
        }
        if (type.getProvider() == null) {
            this.workflowRegistrationByDefinition.remove(type.getDefinition());
            this.modulesForWorkflowDefinition.remove(type.getDefinition());
        }
    }

    public synchronized void registerWorkflowTypes() {
        for (WorklowTypeRegistration registration : new LinkedList<WorklowTypeRegistration>(this.workflowRegistrationByDefinition.values())) {
            this.doRegisterWorkflowType(registration);
        }
    }

    public synchronized void unregisterWorkflowType(WorklowTypeRegistration type) {
        if (this.workflowRegistrationByDefinition.get(type.getDefinition()) == type) {
            this.workflowRegistrationByDefinition.remove(type.getDefinition());
            this.modulesForWorkflowDefinition.remove(type.getDefinition());
            this.cache.flush();
        }
    }

    public Map<String, WorkflowProvider> getProviders() {
        return this.providers;
    }

    public synchronized void addProvider(WorkflowProvider provider) {
        this.providers.put(provider.getKey(), provider);
        if (provider instanceof WorkflowObservationManagerAware) {
            ((WorkflowObservationManagerAware)((Object)provider)).setWorkflowObservationManager(this.observationManager);
        }
    }

    public synchronized void removeProvider(WorkflowProvider provider) {
        this.providers.remove(provider.getKey());
    }

    private synchronized boolean initializePermission(JCRSessionWrapper session, WorkflowDefinition definition, JahiaTemplatesPackage module) throws RepositoryException {
        boolean updated = false;
        Map<String, String> map = this.workflowRegistrationByDefinition.get(definition.getKey()).getPermissions();
        if (map == null) {
            map = new HashMap<String, String>();
            this.workflowRegistrationByDefinition.get(definition.getKey()).setPermissions(map);
        }
        Set<String> tasks = definition.getTasks();
        String permissionPath = "/modules/" + module.getIdWithVersion() + "/permissions";
        for (String task : tasks) {
            if (map.containsKey(task)) continue;
            String permissionName = Patterns.SPACE.matcher(definition.getKey()).replaceAll("-") + "-" + Patterns.SPACE.matcher(task).replaceAll("-");
            if (!session.itemExists(permissionPath + "/workflow-tasks/" + permissionName)) {
                logger.info("Create workflow permission : {}", (Object)permissionName);
                JCRNodeWrapper perms = session.getNode(permissionPath);
                if (!perms.hasNode(WORKFLOWTASKS_NODE_NAME)) {
                    perms.addNode(WORKFLOWTASKS_NODE_NAME, "jnt:permission");
                }
                perms.getNode(WORKFLOWTASKS_NODE_NAME).addNode(permissionName, "jnt:permission");
                updated = true;
            }
            map.put(task, "/workflow-tasks/" + permissionName);
        }
        return updated;
    }

    public List<WorkflowDefinition> getWorkflows(Locale displayLocale) throws RepositoryException {
        ArrayList<WorkflowDefinition> workflowsByProvider = new ArrayList<WorkflowDefinition>();
        for (Map.Entry<String, WorkflowProvider> providerEntry : this.providers.entrySet()) {
            workflowsByProvider.addAll(providerEntry.getValue().getAvailableWorkflows(displayLocale));
        }
        return workflowsByProvider;
    }

    public List<WorkflowDefinition> getWorkflowDefinitionsForType(String type, Locale uiLocale) throws RepositoryException {
        return this.getWorkflowDefinitionsForType(type, null, uiLocale);
    }

    public List<WorkflowDefinition> getWorkflowDefinitionsForType(String type, JCRSiteNode siteNode, Locale uiLocale) throws RepositoryException {
        ArrayList<WorkflowDefinition> workflowsByProvider = new ArrayList<WorkflowDefinition>();
        for (Map.Entry<String, WorkflowProvider> providerEntry : this.providers.entrySet()) {
            List<WorkflowDefinition> defs = providerEntry.getValue().getAvailableWorkflows(uiLocale);
            for (WorkflowDefinition def : defs) {
                WorklowTypeRegistration worklowTypeRegistration = this.workflowRegistrationByDefinition.get(def.getKey());
                if (!worklowTypeRegistration.getType().equals(type) || siteNode != null && !this.isRegistrationAvailableForSite(siteNode, worklowTypeRegistration)) continue;
                workflowsByProvider.add(def);
            }
        }
        return workflowsByProvider;
    }

    private boolean isRegistrationAvailableForSite(JCRSiteNode siteNode, WorklowTypeRegistration worklowTypeRegistration) {
        return worklowTypeRegistration.getModule().getModuleType().equals("system") || siteNode.getInstalledModulesWithAllDependencies().contains(worklowTypeRegistration.getModule().getId());
    }

    public Map<String, WorkflowDefinition> getPossibleWorkflows(JCRNodeWrapper node, boolean checkPermission, Locale uiLocale) throws RepositoryException {
        List<WorkflowDefinition> l = this.getPossibleWorkflows(node, checkPermission, null, uiLocale);
        HashMap<String, WorkflowDefinition> res = new HashMap<String, WorkflowDefinition>();
        for (WorkflowDefinition workflowDefinition : l) {
            res.put(this.workflowRegistrationByDefinition.get(workflowDefinition.getKey()).getType(), workflowDefinition);
        }
        return res;
    }

    public WorkflowDefinition getPossibleWorkflowForType(JCRNodeWrapper node, boolean checkPermission, String type, Locale locale) throws RepositoryException {
        List<WorkflowDefinition> workflowDefinitionList = this.getPossibleWorkflows(node, checkPermission, type, locale);
        if (workflowDefinitionList.isEmpty()) {
            return null;
        }
        return workflowDefinitionList.get(0);
    }

    private List<WorkflowDefinition> getPossibleWorkflows(JCRNodeWrapper node, boolean checkPermission, String type, Locale uiLocale) {
        LinkedHashSet<WorkflowDefinition> workflows = new LinkedHashSet<WorkflowDefinition>();
        Collection<WorkflowRule> rules = this.getWorkflowRulesForType(node, checkPermission, type);
        for (WorkflowRule ruledef : rules) {
            WorkflowDefinition definition = this.lookupProvider(ruledef.getProviderKey()).getWorkflowDefinitionByKey(ruledef.getWorkflowDefinitionKey(), uiLocale);
            if (definition == null) continue;
            workflows.add(definition);
        }
        return new LinkedList<WorkflowDefinition>(workflows);
    }

    public List<JahiaPrincipal> getAssignedRole(final WorkflowDefinition definition, final String activityName, final String processId) throws RepositoryException {
        return this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<List<JahiaPrincipal>>(){

            @Override
            public List<JahiaPrincipal> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                return WorkflowService.this.getAssignedRole(definition, activityName, processId, session);
            }
        });
    }

    public List<JahiaPrincipal> getAssignedRole(WorkflowDefinition definition, String activityName, String processId, JCRSessionWrapper session) throws RepositoryException {
        String permPath;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Workflow [%s], Task [%s], Process ID [%s]: Lookup assignable principals", definition.getName(), activityName, processId));
        }
        List<JahiaPrincipal> principals = Collections.emptyList();
        Map<String, String> perms = this.workflowRegistrationByDefinition.get(definition.getKey()).getPermissions();
        String string = permPath = perms != null ? perms.get(activityName) : null;
        if (permPath == null) {
            return principals;
        }
        Workflow w = this.getWorkflow(definition.getProvider(), processId, null);
        JCRNodeWrapper node = session.getNodeByIdentifier((String)w.getVariables().get("nodeId"));
        if (permPath.indexOf(36) > -1 && w != null) {
            for (Map.Entry<String, Object> entry : w.getVariables().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof List) {
                    List list = (List)entry.getValue();
                    StringBuilder sb = new StringBuilder();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        if (o instanceof WorkflowVariable) {
                            sb.append(((WorkflowVariable)o).getValue());
                        }
                        if (!iterator.hasNext()) continue;
                        sb.append(",");
                    }
                    permPath = permPath.replace("$" + entry.getKey(), iterator.toString());
                    continue;
                }
                if (!(value instanceof WorkflowVariable)) continue;
                permPath = permPath.replace("$" + entry.getKey(), ((WorkflowVariable)value).getValue());
            }
        }
        try {
            if (!permPath.contains("/")) {
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:permission] where name()='" + JCRContentUtils.sqlEncode(permPath) + "'", "JCR-SQL2");
                NodeIterator ni = q.execute().getNodes();
                if (ni.hasNext()) {
                    permPath = StringUtils.substringAfter((String)ni.nextNode().getPath(), (String)"/permissions");
                } else {
                    return principals;
                }
            }
            HashSet<String> roles = new HashSet<String>();
            HashSet<CallSite> extPerms = new HashSet<CallSite>();
            while (!StringUtils.isEmpty((String)permPath)) {
                JCRNodeWrapper roleNode;
                String permissionName = permPath.contains("/") ? StringUtils.substringAfterLast((String)permPath, (String)"/") : permPath;
                JCRNodeIteratorWrapper ni = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:role] where [j:permissionNames] = '" + JCRContentUtils.sqlEncode(permissionName) + "'", "JCR-SQL2").execute().getNodes();
                while (ni.hasNext()) {
                    roleNode = (JCRNodeWrapper)ni.next();
                    roles.add(roleNode.getName());
                }
                ni = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:externalPermissions] where [j:permissionNames] = '" + JCRContentUtils.sqlEncode(permissionName) + "'", "JCR-SQL2").execute().getNodes();
                while (ni.hasNext()) {
                    roleNode = (JCRNodeWrapper)ni.next();
                    extPerms.add((CallSite)((Object)(roleNode.getParent().getName() + "/" + roleNode.getName())));
                }
                permPath = permPath.contains("/") ? StringUtils.substringBeforeLast((String)permPath, (String)"/") : "";
            }
            Map<String, Map<String, String>> actualAclEntries = node.getActualAclEntries();
            principals = new LinkedList<JahiaPrincipal>();
            JahiaUserManagerService userService = ServicesRegistry.getInstance().getJahiaUserManagerService();
            JahiaGroupManagerService groupService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
            JCRSiteNode site = null;
            for (Map.Entry<String, Map<String, String>> actualAclEntry : actualAclEntries.entrySet()) {
                for (Map.Entry<String, String> aclEntry : actualAclEntry.getValue().entrySet()) {
                    if ((!"GRANT".equals(aclEntry.getValue()) || !roles.contains(aclEntry.getKey())) && (!"EXTERNAL".equals(aclEntry.getValue()) || !extPerms.contains(aclEntry.getKey()))) continue;
                    String principal = actualAclEntry.getKey();
                    String principalName = principal.substring(2);
                    if (site == null) {
                        site = node.getResolveSite();
                    }
                    if (principal.charAt(0) == 'u') {
                        JCRUserNode userNode = userService.lookupUser(principalName, node.getPath().startsWith("/sites/") ? site.getSiteKey() : null);
                        if (userNode == null) continue;
                        logger.debug("user {} is granted", (Object)userNode.getUserKey());
                        JahiaUser jahiaUser = userNode.getJahiaUser();
                        if (principals.contains(jahiaUser)) continue;
                        principals.add(jahiaUser);
                        continue;
                    }
                    if (principal.charAt(0) != 'g') continue;
                    JCRGroupNode group = groupService.lookupGroup(site.getSiteKey(), principalName);
                    if (group == null) {
                        group = groupService.lookupGroup(null, principalName);
                    }
                    if (group == null) continue;
                    logger.debug("group {} is granted", (Object)group.getGroupKey());
                    if (principals.contains(group.getJahiaGroup())) continue;
                    principals.add(group.getJahiaGroup());
                }
            }
        }
        catch (RepositoryException | BeansException e) {
            logger.error(e.getMessage(), e);
        }
        if (logger.isDebugEnabled() && principals.isEmpty()) {
            logger.debug(String.format("Workflow [%s], Task [%s], Process ID [%s]: No principal found", definition.getName(), activityName, processId));
        }
        return principals;
    }

    public List<Workflow> getActiveWorkflows(JCRNodeWrapper node, Locale locale, Locale displayLocale) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        try {
            JCRNodeWrapper n = node;
            if (n.isNodeType("jmix:workflow") && n.hasProperty("j:processId")) {
                this.addActiveWorkflows(workflows, n.getProperty("j:processId"), displayLocale);
            }
            try {
                if (locale != null && node.hasTranslations() && (n = node.getI18N(locale)).isNodeType("jmix:workflow") && n.hasProperty("j:processId")) {
                    this.addActiveWorkflows(workflows, n.getProperty("j:processId"), displayLocale);
                }
            }
            catch (ItemNotFoundException e) {
                return workflows;
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return workflows;
    }

    public Map<Locale, List<Workflow>> getActiveWorkflowsForAllLocales(JCRNodeWrapper node) {
        HashMap<Locale, List<Workflow>> workflowsByLocale = new HashMap<Locale, List<Workflow>>();
        try {
            if (node.isNodeType("jmix:workflow")) {
                JCRNodeIteratorWrapper ni = node.getNodes("j:translation*");
                while (ni.hasNext()) {
                    Node n = ((JCRNodeWrapper)ni.next()).getRealNode();
                    String lang = n.getProperty("jcr:language").getString();
                    if (!n.hasProperty("j:processId")) continue;
                    ArrayList<Workflow> l = new ArrayList<Workflow>();
                    workflowsByLocale.put(LanguageCodeConverters.getLocaleFromCode(lang), l);
                    this.addActiveWorkflows(l, n.getProperty("j:processId"), null);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return workflowsByLocale;
    }

    private void addActiveWorkflows(List<Workflow> workflows, Property p, Locale displayLocale) throws RepositoryException {
        Value[] values = p.getValues();
        for (Map.Entry<String, WorkflowProvider> entry : this.providers.entrySet()) {
            ArrayList<String> processIds = new ArrayList<String>(values.length);
            for (Value value : values) {
                String key = value.getString();
                String processId = StringUtils.substringAfter((String)key, (String)":");
                String providerKey = StringUtils.substringBefore((String)key, (String)":");
                if (!providerKey.equals(entry.getKey())) continue;
                processIds.add(processId);
            }
            if (processIds.isEmpty()) continue;
            List<Workflow> workflowsInformations = entry.getValue().getActiveWorkflowsInformations(processIds, displayLocale);
            workflows.addAll(workflowsInformations);
        }
    }

    public Set<WorkflowAction> getAvailableActions(String processId, String provider, Locale locale) {
        return this.lookupProvider(provider).getAvailableActions(processId, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortProcess(String processId, String provider) {
        this.readOnlyModeLock.readLock().lock();
        try {
            this.assertWritable();
            WorkflowProvider workflowProvider = this.lookupProvider(provider);
            logger.debug("Abort process {}", (Object)processId);
            Workflow workflow = workflowProvider.getWorkflow(processId, null);
            final HashSet<String> actionIds = new HashSet<String>();
            for (WorkflowAction action : workflow.getAvailableActions()) {
                if (!(action instanceof WorkflowTask)) continue;
                actionIds.add(((WorkflowTask)action).getId());
            }
            if (!actionIds.isEmpty()) {
                try {
                    JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            for (String actionId : actionIds) {
                                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:workflowTask] where [taskId]='" + actionId + "'", "JCR-SQL2");
                                JCRNodeIteratorWrapper ni = q.execute().getNodes();
                                for (JCRNodeWrapper wrapper : ni) {
                                    wrapper.remove();
                                }
                            }
                            session.save();
                            return false;
                        }
                    });
                }
                catch (RepositoryException e) {
                    logger.error("Cannot remove tasks", (Throwable)e);
                }
            }
            workflowProvider.abortProcess(processId);
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    public void startProcessAsJob(List<String> nodeIds, JCRSessionWrapper session, String processKey, String provider, Map<String, Object> args, List<String> comments) throws RepositoryException, SchedulerException {
        JobDetail jobDetail = BackgroundJob.createJahiaJob("StartProcess", StartProcessJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("userkey", session.getUserNode().getUserKey());
        jobDataMap.put("currentLocale", session.getLocale().toString());
        jobDataMap.put((Object)"nodeIds", nodeIds);
        jobDataMap.put("provider", provider);
        jobDataMap.put("processKey", processKey);
        jobDataMap.put((Object)"map", args);
        jobDataMap.put((Object)"comments", comments);
        ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startProcess(List<String> nodeIds, JCRSessionWrapper session, String processKey, String provider, Map<String, Object> args, List<String> comments) throws RepositoryException {
        this.readOnlyModeLock.readLock().lock();
        try {
            this.assertWritable();
            long startTime = System.currentTimeMillis();
            String startPermission = this.getPermissionForStart(this.workflowRegistrationByDefinition.get(processKey));
            WorkflowProvider providerImpl = this.lookupProvider(provider);
            ArrayList<String> checkedNodeIds = new ArrayList<String>();
            for (String nodeId : nodeIds) {
                try {
                    JCRNodeWrapper n = session.getNodeByIdentifier(nodeId);
                    if (startPermission != null && !n.hasPermission(startPermission)) continue;
                    checkedNodeIds.add(nodeId);
                }
                catch (ItemNotFoundException n) {}
            }
            if (checkedNodeIds.isEmpty()) {
                Iterator<String> iterator = null;
                return iterator;
            }
            String mainId = (String)checkedNodeIds.iterator().next();
            HashMap<String, Object> newArgs = new HashMap<String, Object>();
            for (Map.Entry string : args.entrySet()) {
                newArgs.put(((String)string.getKey()).replaceAll(":", "_"), string.getValue());
            }
            newArgs.put("nodeId", mainId);
            try {
                newArgs.put("nodePath", session.getNodeByIdentifier(mainId).getPath());
            }
            catch (ItemNotFoundException n) {
                // empty catch block
            }
            newArgs.put("nodeIds", checkedNodeIds);
            newArgs.put("workspace", session.getWorkspace().getName());
            newArgs.put("locale", session.getLocale());
            newArgs.put("workflow", providerImpl.getWorkflowDefinitionByKey(processKey, session.getLocale()));
            newArgs.put("user", session.getUser() != null ? session.getUser().getUserKey() : null);
            if (comments != null && !comments.isEmpty()) {
                this.addCommentsToVariables(newArgs, comments, session.getUser().getUserKey());
            }
            String processId = providerImpl.startProcess(processKey, newArgs);
            if (logger.isDebugEnabled()) {
                logger.debug("A workflow {} from {} has been started on {}{} nodes{} from workspace {} in locale {} with id {}{} in {} ms", new Object[]{processKey, provider, checkedNodeIds.size(), nodeIds.size() > checkedNodeIds.size() ? " (originally " + nodeIds.size() + ")" : "", logger.isTraceEnabled() ? ": " + String.valueOf(checkedNodeIds) : "", newArgs.get("workspace"), newArgs.get("locale"), processId, startPermission != null ? " checking for permission " + startPermission : "", System.currentTimeMillis() - startTime});
            }
            String string = processId;
            return string;
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    private void addCommentsToVariables(Map<String, Object> args, List<String> comments, String userKey) {
        LinkedList<WorkflowComment> wfComments = (LinkedList<WorkflowComment>)args.get("comments");
        if (wfComments == null) {
            wfComments = new LinkedList<WorkflowComment>();
            args.put("comments", wfComments);
        }
        Date timestamp = new Date();
        for (String comment : comments) {
            wfComments.add(new WorkflowComment(comment, timestamp, userKey));
        }
    }

    public synchronized void addProcessId(JCRNodeWrapper stageNode, String provider, String processId) throws RepositoryException {
        stageNode.checkout();
        if (!stageNode.isNodeType("jmix:workflow")) {
            stageNode.addMixin("jmix:workflow");
        }
        ArrayList<Object> values = stageNode.hasProperty("j:processId") ? new ArrayList<JCRValueWrapper>(Arrays.asList(stageNode.getProperty("j:processId").getValues())) : new ArrayList<Value>();
        values.add(stageNode.getSession().getValueFactory().createValue(provider + ":" + processId));
        stageNode.setProperty("j:processId", values.toArray(new Value[values.size()]));
        stageNode.getSession().save();
    }

    public synchronized void removeProcessId(JCRNodeWrapper stageNode, String provider, String processId) throws RepositoryException {
        if (!stageNode.hasProperty("j:processId")) {
            return;
        }
        stageNode.checkout();
        ArrayList<JCRValueWrapper> values = new ArrayList<JCRValueWrapper>(Arrays.asList(stageNode.getProperty("j:processId").getValues()));
        ArrayList<Value> newValues = new ArrayList<Value>();
        for (Value value : values) {
            if (value.getString().equals(provider + ":" + processId)) continue;
            newValues.add(value);
        }
        if (newValues.isEmpty()) {
            if (stageNode.hasProperty("j:processId")) {
                stageNode.getProperty("j:processId").remove();
            }
        } else {
            stageNode.setProperty("j:processId", newValues.toArray(new Value[newValues.size()]));
        }
        stageNode.getSession().save();
    }

    public List<WorkflowTask> getTasksForUser(JahiaUser user, Locale uiLocale) {
        LinkedList<WorkflowTask> workflowActions = new LinkedList<WorkflowTask>();
        for (Map.Entry<String, WorkflowProvider> providerEntry : this.providers.entrySet()) {
            workflowActions.addAll(providerEntry.getValue().getTasksForUser(user, uiLocale));
        }
        return workflowActions;
    }

    public List<Workflow> getWorkflowsForUser(JahiaUser user, Locale uiLocale) {
        LinkedList<Workflow> workflow = new LinkedList<Workflow>();
        for (Map.Entry<String, WorkflowProvider> providerEntry : this.providers.entrySet()) {
            workflow.addAll(providerEntry.getValue().getWorkflowsForUser(user, uiLocale));
        }
        return workflow;
    }

    public List<Workflow> getWorkflowsForType(String type, Locale uiLocale) {
        ArrayList<Workflow> list = new ArrayList<Workflow>();
        for (WorklowTypeRegistration registration : this.workflowRegistrationByDefinition.values()) {
            if (!registration.getType().equals(type)) continue;
            list.addAll(this.getWorkflowsForDefinition(registration.getDefinition(), uiLocale));
        }
        return list;
    }

    public List<Workflow> getWorkflowsForDefinition(String definition, Locale uiLocale) {
        ArrayList<Workflow> list = new ArrayList<Workflow>();
        for (WorkflowProvider provider : this.providers.values()) {
            list.addAll(provider.getWorkflowsForDefinition(definition, uiLocale));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignTask(String taskId, String provider, JahiaUser user) {
        this.readOnlyModeLock.readLock().lock();
        try {
            this.assertWritable();
            logger.debug("Assigning user {} to task {}", (Object)user.getName(), (Object)taskId);
            this.lookupProvider(provider).assignTask(taskId, user);
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeTask(String taskId, JahiaUser user, String provider, String outcome, Map<String, Object> args) {
        this.readOnlyModeLock.readLock().lock();
        try {
            this.assertWritable();
            this.lookupProvider(provider).completeTask(taskId, user, outcome, args);
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    public void assignAndCompleteTaskAsJob(String taskId, String provider, String outcome, Map<String, Object> args, JahiaUser user) throws RepositoryException, SchedulerException {
        JobDetail jobDetail = BackgroundJob.createJahiaJob("AssignAndCompleteTask", AssignAndCompleteTaskJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("userkey", user.getUserKey());
        jobDataMap.put("taskId", taskId);
        jobDataMap.put("provider", provider);
        jobDataMap.put("outcome", outcome);
        jobDataMap.put((Object)"map", args);
        ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail);
    }

    public void assignAndCompleteTask(String taskId, String provider, String outcome, Map<String, Object> args, JahiaUser user) {
        this.assignTask(taskId, provider, user);
        this.completeTask(taskId, user, provider, outcome, args);
    }

    public void addWorkflowRule(JCRNodeWrapper node, WorkflowDefinition workflow) throws RepositoryException {
        JCRNodeWrapper rules = null;
        try {
            rules = node.getNode(WORKFLOWRULES_NODE_NAME);
        }
        catch (RepositoryException e) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            node.addMixin("jmix:workflowRulesable");
            rules = node.addNode(WORKFLOWRULES_NODE_NAME, "jnt:workflowRules");
        }
        String wfName = workflow.getProvider() + "_" + workflow.getKey();
        JCRNodeWrapper n = rules.hasNode(wfName) ? rules.getNode(wfName) : rules.addNode(wfName, "jnt:workflowRule");
        if (!n.isCheckedOut()) {
            n.checkout();
        }
        n.setProperty("j:workflow", workflow.getProvider() + ":" + workflow.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComment(String processId, String provider, String comment, String user) {
        this.readOnlyModeLock.readLock().lock();
        try {
            this.assertWritable();
            this.lookupProvider(provider).addComment(processId, comment, user);
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    public WorkflowTask getWorkflowTask(String taskId, String provider, Locale displayLocale) {
        return this.lookupProvider(provider).getWorkflowTask(taskId, displayLocale);
    }

    public HistoryWorkflow getHistoryWorkflow(String id, String provider, Locale uiLocale) {
        List<HistoryWorkflow> list = this.lookupProvider(provider).getHistoryWorkflows(Collections.singletonList(id), uiLocale);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<HistoryWorkflow> getHistoryWorkflows(JCRNodeWrapper node, Locale uiLocale) {
        LinkedList<HistoryWorkflow> history = new LinkedList<HistoryWorkflow>();
        try {
            for (WorkflowProvider workflowProvider : this.providers.values()) {
                history.addAll(workflowProvider.getHistoryWorkflowsForNode(node.getIdentifier(), uiLocale));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return history;
    }

    public List<HistoryWorkflow> getHistoryWorkflowsByPath(String path, Locale locale) {
        LinkedList<HistoryWorkflow> history = new LinkedList<HistoryWorkflow>();
        for (WorkflowProvider workflowProvider : this.providers.values()) {
            history.addAll(workflowProvider.getHistoryWorkflowsForPath(path, locale));
        }
        return history;
    }

    public List<HistoryWorkflowTask> getHistoryWorkflowTasks(String workflowProcessId, String providerKey, Locale uiLocale) {
        return this.lookupProvider(providerKey).getHistoryWorkflowTasks(workflowProcessId, uiLocale);
    }

    protected WorkflowProvider lookupProvider(String key) {
        WorkflowProvider provider = this.providers.get(key);
        if (provider == null) {
            throw new JahiaRuntimeException("Unknown workflow provider with the key '" + key + "'");
        }
        return provider;
    }

    public boolean hasActiveWorkflowForType(JCRNodeWrapper node, String type) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        try {
            List<WorkflowDefinition> forAction = this.getWorkflowDefinitionsForType(type, null);
            if (node.isNodeType("jmix:workflow") && node.hasProperty("j:processId")) {
                this.addActiveWorkflows(workflows, node.getProperty("j:processId"), node.getSession().getLocale());
            }
            for (Workflow workflow : workflows) {
                if (!forAction.contains(workflow.getWorkflowDefinition())) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void addWorkflowRule(JCRNodeWrapper node, String wfName) throws RepositoryException {
        String provider = StringUtils.substringBefore((String)wfName, (String)":");
        String wfKey = StringUtils.substringAfter((String)wfName, (String)":");
        WorkflowDefinition definition = this.lookupProvider(provider).getWorkflowDefinitionByKey(wfKey, node.getSession().getLocale());
        this.addWorkflowRule(node, definition);
    }

    public WorkflowRule getWorkflowRuleForAction(JCRNodeWrapper objectNode, boolean checkPermission, String action) throws RepositoryException {
        Collection<WorkflowRule> rules = this.getWorkflowRulesForType(objectNode, checkPermission, action);
        if (rules.isEmpty()) {
            return null;
        }
        return rules.iterator().next();
    }

    private Collection<WorkflowRule> getWorkflowRulesForType(JCRNodeWrapper objectNode, boolean checkPermission, String type) {
        LinkedHashSet<WorkflowRule> results = new LinkedHashSet<WorkflowRule>();
        Collection<WorkflowRule> rules = this.getWorkflowRules(objectNode);
        for (WorkflowRule rule : rules) {
            String permName;
            WorklowTypeRegistration worklowTypeRegistration = this.workflowRegistrationByDefinition.get(rule.getWorkflowDefinitionKey());
            if (type != null && !worklowTypeRegistration.getType().equals(type)) continue;
            String string = permName = checkPermission ? this.getPermissionForStart(worklowTypeRegistration) : null;
            if (permName != null && !objectNode.hasPermission(permName)) continue;
            results.add(rule);
        }
        return results;
    }

    public Collection<WorkflowRule> getWorkflowRules(JCRNodeWrapper objectNode) {
        try {
            Map<String, WorkflowRule> rules = this.recurseOnRules(objectNode);
            HashMap perms = new HashMap();
            JCRNodeWrapper rootNode = objectNode.getSession().getNode("/");
            JahiaAccessManager accessControlManager = (JahiaAccessManager)rootNode.getRealNode().getSession().getAccessControlManager();
            Map<String, List<String[]>> aclEntries = objectNode.getAclEntries();
            if (aclEntries != null) {
                for (List<String[]> list : aclEntries.values()) {
                    for (String[] strings : list) {
                        for (Privilege privilege : accessControlManager.getPermissionsInRole(strings[2])) {
                            if (!perms.containsKey(strings[0])) {
                                perms.put(strings[0], new ArrayList());
                            }
                            ((List)perms.get(strings[0])).add(JCRContentUtils.getJCRName(privilege.getName(), objectNode.getRealNode().getSession().getWorkspace().getNamespaceRegistry()));
                        }
                    }
                }
            }
            HashMap<String, WorkflowRule> rulesCopy = new HashMap<String, WorkflowRule>(rules);
            for (Map.Entry<String, WorkflowRule> ruleEntry : rules.entrySet()) {
                WorkflowRule rule = ruleEntry.getValue();
                for (Map.Entry aclEntry : perms.entrySet()) {
                    if (!((String)aclEntry.getKey()).startsWith((String)(rule.getDefinitionPath().equals("/") ? "/" : rule.getDefinitionPath() + "/")) || Collections.disjoint((Collection)aclEntry.getValue(), rule.getPermissions().values())) continue;
                    rule = new WorkflowRule((String)aclEntry.getKey(), ruleEntry.getValue().getDefinitionPath(), rule.getProviderKey(), rule.getWorkflowDefinitionKey(), rule.getPermissions());
                    rulesCopy.put(ruleEntry.getKey(), rule);
                }
            }
            return Collections.unmodifiableCollection(rulesCopy.values());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Map<String, WorkflowRule> recurseOnRules(JCRNodeWrapper n) throws RepositoryException {
        String nodePath = n.getPath();
        Map<String, WorkflowRule> results = this.cache.get(nodePath);
        if (results != null) {
            return results;
        }
        if ("/".equals(nodePath)) {
            results = this.getDefaultRules(n);
        } else {
            results = n.isNodeType("jnt:virtualsite") ? this.getDefaultRules(n) : this.recurseOnRules(n.getParent());
            if (n.hasNode(WORKFLOWRULES_NODE_NAME)) {
                results = new HashMap<String, WorkflowRule>(results);
                JCRNodeWrapper wfRules = n.getNode(WORKFLOWRULES_NODE_NAME);
                NodeIterator rules = wfRules.getNodes();
                while (rules.hasNext()) {
                    Node rule = rules.nextNode();
                    String wfName = rule.getProperty("j:workflow").getString();
                    String name = StringUtils.substringAfter((String)wfName, (String)":");
                    String prov = StringUtils.substringBefore((String)wfName, (String)":");
                    WorklowTypeRegistration type = this.workflowRegistrationByDefinition.get(name);
                    if (type == null) continue;
                    String wftype = type.getType();
                    results.put(wftype, new WorkflowRule(nodePath, nodePath, prov, name, type.getPermissions()));
                }
            }
        }
        this.cache.put(nodePath, results);
        return results;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.ModuleDeployedOnSiteEvent event) {
        this.cache.flush();
    }

    private Map<String, WorkflowRule> getDefaultRules(JCRNodeWrapper n) throws RepositoryException {
        HashMap<String, WorkflowRule> results = new HashMap<String, WorkflowRule>();
        HashMap<String, WorklowTypeRegistration> m = new HashMap<String, WorklowTypeRegistration>();
        for (WorklowTypeRegistration worklowTypeRegistration : this.workflowRegistrationByDefinition.values()) {
            if (!worklowTypeRegistration.isCanBeUsedForDefault() || m.containsKey(worklowTypeRegistration.getType()) && ((WorklowTypeRegistration)m.get(worklowTypeRegistration.getType())).getDefaultPriority() >= worklowTypeRegistration.getDefaultPriority() || !this.isRegistrationAvailableForSite(n.getResolveSite(), worklowTypeRegistration)) continue;
            m.put(worklowTypeRegistration.getType(), worklowTypeRegistration);
        }
        for (Map.Entry entry : m.entrySet()) {
            results.put(((WorklowTypeRegistration)entry.getValue()).getType(), new WorkflowRule("/", "/", ((WorklowTypeRegistration)entry.getValue()).getProvider(), ((WorklowTypeRegistration)entry.getValue()).getDefinition(), ((WorklowTypeRegistration)entry.getValue()).getPermissions()));
        }
        return results;
    }

    public Workflow getWorkflow(String provider, String id, Locale displayLocale) {
        if (logger.isDebugEnabled()) {
            StackTraceElement el = Thread.currentThread().getStackTrace()[2];
            logger.debug("Trigger getWorkflow command from {}.{}", (Object)org.apache.commons.lang3.StringUtils.substringAfterLast((String)el.getClassName(), (String)"."), (Object)el.getMethodName());
        }
        return this.lookupProvider(provider).getWorkflow(id, displayLocale);
    }

    public WorkflowDefinition getWorkflowDefinition(String provider, String id, Locale locale) {
        if (this.getWorkflowRegistration(id) == null) {
            return null;
        }
        return this.lookupProvider(provider).getWorkflowDefinitionByKey(id, locale);
    }

    public WorklowTypeRegistration getWorkflowRegistration(String definitionKey) {
        return this.workflowRegistrationByDefinition.get(definitionKey);
    }

    public String getWorkflowType(WorkflowDefinition def) {
        return this.workflowRegistrationByDefinition.get(def.getKey()).getType();
    }

    public String getFormForAction(String definitionKey, String action) {
        if (this.workflowRegistrationByDefinition.get(definitionKey).getForms() != null) {
            return this.workflowRegistrationByDefinition.get(definitionKey).getForms().get(action);
        }
        return null;
    }

    public String getModuleForWorkflow(String key) {
        return this.modulesForWorkflowDefinition.get(key);
    }

    public Set<String> getTypesOfWorkflow() {
        HashSet<String> s = new HashSet<String>();
        for (WorklowTypeRegistration registration : this.workflowRegistrationByDefinition.values()) {
            s.add(registration.getType());
        }
        return s;
    }

    public void deleteProcess(String processId, String provider) {
        this.readOnlyModeLock.readLock().lock();
        try {
            this.assertWritable();
            this.lookupProvider(provider).deleteProcess(processId);
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    public void addWorkflowListener(WorkflowListener listener) {
        this.observationManager.addWorkflowListener(listener);
    }

    public void removeWorkflowListener(WorkflowListener listener) {
        this.observationManager.removeWorkflowListener(listener);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof WorklowTypeRegistration) {
            WorklowTypeRegistration registration = (WorklowTypeRegistration)bean;
            this.registerWorkflowType(registration);
            logger.info("Registering workflow type \"" + registration.getType() + "\" with definition \"" + registration.getDefinition() + "\" and permissions: " + String.valueOf(registration.getPermissions()));
        }
        return bean;
    }

    public void setJcrTemplate(JCRTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public WorkflowObservationManager getObservationManager() {
        return this.observationManager;
    }

    public synchronized void initAfterAllServicesAreStarted() {
        this.servicesStarted = true;
        this.observationManager.initAfterAllServicesAreStarted();
        this.registerWorkflowTypes();
    }

    private String getPermissionForStart(WorklowTypeRegistration worklowTypeRegistration) {
        int pos;
        String startPermission = null;
        if (worklowTypeRegistration != null && worklowTypeRegistration.getPermissions() != null && (startPermission = worklowTypeRegistration.getPermissions().get(START_ROLE)) != null && (pos = startPermission.lastIndexOf(47)) != -1 && pos < startPermission.length() - 1) {
            startPermission = startPermission.substring(pos);
        }
        return startPermission;
    }

    @Override
    public void switchReadOnlyMode(boolean enable) {
        this.readOnlyModeLock.writeLock().lock();
        try {
            this.readOnly = enable;
        }
        finally {
            this.readOnlyModeLock.writeLock().unlock();
        }
    }

    @Override
    public int getReadOnlyModePriority() {
        return 700;
    }

    private void assertWritable() {
        if (this.readOnly) {
            throw new ReadOnlyModeException("The Workflow Service is in read only mode: no operations that modify workflow state are available");
        }
    }
}

