/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class WorkflowVariable
implements Serializable {
    private static final long serialVersionUID = 942602985046632239L;
    private String value;
    private int type;

    public WorkflowVariable() {
    }

    public WorkflowVariable(String value, int type) {
        this.type = type;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Date getValueAsDate() {
        if (null == this.value || "".equals(this.value.trim())) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(Long.valueOf(this.value));
            return calendar.getTime();
        }
        catch (NumberFormatException e) {
            DateTime dateTime = ISODateTimeFormat.dateOptionalTimeParser().parseDateTime(this.value);
            return dateTime.toDate();
        }
    }

    public static HashMap<String, Object> getVariablesMap(Map<String, List<String>> parameters, String formNodeType, List<String> excludedParameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ExtendedNodeType type = null;
        if (formNodeType != null && NodeTypeRegistry.getInstance().hasNodeType(formNodeType)) {
            try {
                type = NodeTypeRegistry.getInstance().getNodeType(formNodeType);
            }
            catch (NoSuchNodeTypeException noSuchNodeTypeException) {
                // empty catch block
            }
        }
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            String s;
            List<String> paramValue;
            String paramName = entry.getKey();
            if (excludedParameters != null && excludedParameters.contains(paramName) || (paramValue = parameters.get(paramName)) == null || paramValue.isEmpty()) continue;
            ExtendedPropertyDefinition definition = null;
            if (type != null) {
                definition = type.getPropertyDefinition(paramName);
            }
            if (definition != null) {
                if (definition.isMultiple()) {
                    ArrayList<WorkflowVariable> list = new ArrayList<WorkflowVariable>();
                    for (String s2 : paramValue) {
                        if (!StringUtils.isNotBlank((String)s2)) continue;
                        list.add(new WorkflowVariable(s2, definition.getRequiredType()));
                    }
                    map.put(paramName, list);
                    continue;
                }
                s = paramValue.get(0);
                if (!StringUtils.isNotBlank((String)s)) continue;
                map.put(paramName, new WorkflowVariable(s, definition.getRequiredType()));
                continue;
            }
            s = paramValue.get(0);
            if (!StringUtils.isNotBlank((String)s)) continue;
            map.put(paramName, paramValue.get(0));
        }
        return map;
    }

    public String toString() {
        return "WorkflowVariable{value='" + this.value + "', type=" + this.type + "}";
    }
}

