/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.drools.core.command.impl.FixedKnowledgeCommandContext;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowAction;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowParticipation;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.services.workflow.jbpm.JBPM6WorkflowProvider;
import org.jahia.utils.i18n.ResourceBundles;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.command.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCommand<T>
implements GenericCommand<T> {
    private static final Comparator<Constraint> CONSTRAINT_PRIORITY_COMPARATOR = new Comparator<Constraint>(){

        @Override
        public int compare(Constraint o1, Constraint o2) {
            return Integer.compare(o2.getPriority(), o1.getPriority());
        }
    };
    private static final long serialVersionUID = -2742789169791810141L;
    private static transient Logger logger = LoggerFactory.getLogger(BaseCommand.class);
    private KnowledgeCommandContext context;
    protected KieSession ksession;
    private TaskService taskService;
    private AuditLogService auditLogService;
    private EntityManager em;
    private RuntimeEngine runtimeEngine;
    private JbpmServicesPersistenceManager persistenceManager;
    protected WorkflowService workflowService;
    private JahiaUserManagerService userManager;
    private JahiaGroupManagerService groupManager;
    private String key;
    private boolean localTransactionOwner = false;

    public KieSession getKieSession() {
        return this.ksession;
    }

    public TaskService getTaskService() {
        if (this.taskService == null) {
            this.taskService = this.runtimeEngine.getTaskService();
            this.localTransactionOwner = this.persistenceManager.beginTransaction();
        }
        return this.taskService;
    }

    public AuditLogService getLogService() {
        if (this.auditLogService == null) {
            Environment environment = this.context.getKieSession().getEnvironment();
            this.auditLogService = new JPAAuditLogService(environment);
        }
        return this.auditLogService;
    }

    public EntityManager getEm() {
        return this.em;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public JahiaUserManagerService getUserManager() {
        return this.userManager;
    }

    public JahiaGroupManagerService getGroupManager() {
        return this.groupManager;
    }

    public String getKey() {
        return this.key;
    }

    public void setRuntimeEngine(RuntimeEngine runtimeEngine) {
        this.runtimeEngine = runtimeEngine;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    public void setPersistenceManager(JbpmServicesPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setUserManager(JahiaUserManagerService userManager) {
        this.userManager = userManager;
    }

    public void setGroupManager(JahiaGroupManagerService groupManager) {
        this.groupManager = groupManager;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T execute(Context context) {
        if (!(context instanceof KnowledgeCommandContext)) {
            throw new UnsupportedOperationException("This command must be executed by a " + KieSession.class.getSimpleName() + " instance!");
        }
        FixedKnowledgeCommandContext realContext = (FixedKnowledgeCommandContext)context;
        this.context = realContext;
        this.ksession = realContext.getKieSession();
        Environment environment = realContext.getKieSession().getEnvironment();
        EntityManager jbpmEm = (EntityManager)SpringContextSingleton.getBean("jbpmEm");
        environment.set("IS_JTA_TRANSACTION", (Object)false);
        environment.set("IS_SHARED_ENTITY_MANAGER", (Object)true);
        environment.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)jbpmEm);
        this.em = jbpmEm;
        JbpmServicesPersistenceManager persistenceManager = (JbpmServicesPersistenceManager)SpringContextSingleton.getBean("jbpmServicesPersistenceManager");
        boolean success = false;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(this.toString());
            }
            T r = this.execute();
            success = true;
            T t = r;
            return t;
        }
        finally {
            if (this.taskService != null) {
                if (success) {
                    persistenceManager.endTransaction(this.localTransactionOwner);
                } else {
                    persistenceManager.rollBackTransaction(this.localTransactionOwner);
                }
            }
        }
    }

    public abstract T execute();

    protected WorkflowDefinition getWorkflowDefinitionById(String id, Locale uiLocale, KieBase kieBase) {
        Process process = kieBase.getProcess(id);
        return this.convertToWorkflowDefinition(process, uiLocale);
    }

    protected Set<WorkflowAction> getAvailableActions(KieSession ksession, TaskService taskService, String processId, Locale uiLocale) {
        HashSet<WorkflowAction> workflowActions = new HashSet<WorkflowAction>();
        List taskSummaries = taskService.getTasksByStatusByProcessInstanceId(Long.parseLong(processId), JBPM6WorkflowProvider.OPEN_STATUS_LIST, "en");
        for (TaskSummary taskSummary : taskSummaries) {
            Task task = taskService.getTaskById(taskSummary.getId());
            WorkflowTask workflowAction = this.convertToWorkflowTask(task, uiLocale, ksession, taskService);
            workflowActions.add(workflowAction);
        }
        return workflowActions;
    }

    protected List<WorkflowTask> convertToWorkflowTasks(Locale uiLocale, List<TaskSummary> taskSummaryList, KieSession ksession, TaskService taskService) {
        LinkedList<WorkflowTask> availableTasks = new LinkedList<WorkflowTask>();
        for (TaskSummary taskSummary : taskSummaryList) {
            try {
                Task task = taskService.getTaskById(taskSummary.getId());
                WorkflowTask workflowTask = this.convertToWorkflowTask(task, uiLocale, ksession, taskService);
                availableTasks.add(workflowTask);
            }
            catch (Exception e) {
                logger.debug("Cannot get task " + taskSummary.getName() + " for user", (Throwable)e);
            }
        }
        return availableTasks;
    }

    protected WorkflowDefinition convertToWorkflowDefinition(Process process, Locale uiLocale) {
        WorkflowDefinition wf = new WorkflowDefinition(process.getName(), process.getName(), this.key);
        WorkflowProcess workflowProcess = (WorkflowProcess)process;
        String startFormName = this.workflowService.getFormForAction(wf.getKey(), "start");
        wf.setFormResourceName(startFormName);
        wf.setPackageName(process.getPackageName());
        Node[] nodes = workflowProcess.getNodes();
        LinkedHashSet<String> tasks = new LinkedHashSet<String>();
        tasks.add("start");
        for (Node node : nodes) {
            if (!(node instanceof HumanTaskNode)) continue;
            tasks.add(node.getName());
        }
        wf.setTasks(tasks);
        if (uiLocale != null) {
            try {
                ResourceBundle resourceBundle = this.getResourceBundle(uiLocale, process.getPackageName(), wf.getKey());
                wf.setDisplayName(resourceBundle.getString("name"));
            }
            catch (Exception e) {
                wf.setDisplayName(wf.getName());
            }
        }
        return wf;
    }

    protected Workflow convertToWorkflow(ProcessInstance instance, Locale uiLocale, KieSession ksession, TaskService taskService, AuditLogService auditLogService) {
        WorkflowProcessInstance workflowProcessInstance = (WorkflowProcessInstance)instance;
        Workflow workflow = new Workflow(instance.getProcessName(), Long.toString(instance.getId()), this.key);
        WorkflowDefinition definition = this.getWorkflowDefinitionById(instance.getProcessId(), uiLocale, ksession.getKieBase());
        workflow.setWorkflowDefinition(definition);
        workflow.setAvailableActions(this.getAvailableActions(ksession, taskService, Long.toString(instance.getId()), uiLocale));
        ProcessInstanceLog processInstanceLog = (ProcessInstanceLog)((ProcessInstanceImpl)instance).getMetaData().get("ProcessInstanceLog");
        if (processInstanceLog == null) {
            processInstanceLog = auditLogService.findProcessInstance(instance.getId());
        }
        workflow.setStartTime(processInstanceLog.getStart());
        Object user = workflowProcessInstance.getVariable("user");
        if (user != null) {
            workflow.setStartUser(user.toString());
        }
        workflow.setVariables(((WorkflowProcessInstanceImpl)workflowProcessInstance).getVariables());
        return workflow;
    }

    protected WorkflowTask convertToWorkflowTask(Task task, Locale uiLocale, KieSession ksession, TaskService taskService) {
        ProcessInstance instance;
        NodeInstance taskNodeInstance = this.getTaskNodeInstance(task, ksession);
        WorkflowTask workflowTask = new WorkflowTask(taskNodeInstance.getNode().getName(), this.key);
        workflowTask.setDueDate(task.getTaskData().getExpirationTime());
        workflowTask.setCreateTime(task.getTaskData().getCreatedOn());
        workflowTask.setProcessId(Long.toString(task.getTaskData().getProcessInstanceId()));
        if (task.getTaskData().getActualOwner() != null) {
            workflowTask.setAssignee(ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUserByPath(task.getTaskData().getActualOwner().getId()).getJahiaUser());
        }
        workflowTask.setId(Long.toString(task.getId()));
        Set<String> connectionIds = this.getTaskOutcomes(taskNodeInstance.getNode());
        workflowTask.setOutcomes(connectionIds);
        Map<String, String> permissions = this.workflowService.getWorkflowRegistration(ISO9075.decode((String)taskNodeInstance.getProcessInstance().getProcessId())).getPermissions();
        String prefix = taskNodeInstance.getNodeName() + ".";
        permissions = permissions.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), Map.Entry::getValue));
        workflowTask.setOutcomesPermissions(permissions);
        PeopleAssignments peopleAssignements = task.getPeopleAssignments();
        ArrayList<WorkflowParticipation> participations = new ArrayList<WorkflowParticipation>();
        if (peopleAssignements.getPotentialOwners().size() > 0) {
            for (OrganizationalEntity organizationalEntity : peopleAssignements.getPotentialOwners()) {
                if (organizationalEntity instanceof Group) {
                    Group group = (Group)organizationalEntity;
                    JCRGroupNode jcrGroup = this.groupManager.lookupGroupByPath(group.getId());
                    if (jcrGroup != null) {
                        participations.add(new WorkflowParticipation("candidate", jcrGroup.getJahiaGroup()));
                        continue;
                    }
                    logger.warn("Unable to find group {} as a task assignment candidate for task. Skipping it.", (Object)group.getId());
                    continue;
                }
                if (!(organizationalEntity instanceof User)) continue;
                User user = (User)organizationalEntity;
                JCRUserNode jcrUser = this.userManager.lookupUserByPath(user.getId());
                if (jcrUser != null) {
                    participations.add(new WorkflowParticipation("candidate", jcrUser.getJahiaUser()));
                    continue;
                }
                logger.warn("Unable to find user {} as a task assignment candidate for task. Skipping it.", (Object)user.getId());
            }
        }
        workflowTask.setParticipations(participations);
        long contentId = task.getTaskData().getDocumentContentId();
        Content taskContent = taskService.getContentById(contentId);
        Object contentData = ContentMarshallerHelper.unmarshall((byte[])taskContent.getContent(), (Environment)ksession.getEnvironment());
        if (contentData instanceof Map) {
            Map taskParameters = (Map)contentData;
            workflowTask.setVariables(taskParameters);
        }
        if ((instance = ksession.getProcessInstance(task.getTaskData().getProcessInstanceId())) != null) {
            WorkflowDefinition definition = this.getWorkflowDefinitionById(instance.getProcessId(), uiLocale, ksession.getKieBase());
            workflowTask.setWorkflowDefinition(definition);
            this.i18nOfWorkflowAction(uiLocale, workflowTask, definition.getKey(), definition.getPackageName());
            workflowTask.setFormResourceName(this.workflowService.getFormForAction(definition.getKey(), workflowTask.getName()));
        }
        return workflowTask;
    }

    protected NodeInstance getTaskNodeInstance(Task task, KieSession ksession) {
        WorkflowProcessInstance workflowProcessInstance = (WorkflowProcessInstance)ksession.getProcessInstance(task.getTaskData().getProcessInstanceId());
        long workItemId = task.getTaskData().getWorkItemId();
        NodeInstance taskNodeInstance = null;
        for (NodeInstance nodeInstance : workflowProcessInstance.getNodeInstances()) {
            WorkItemNodeInstance workItemNodeInstance;
            if (!(nodeInstance instanceof WorkItemNodeInstance) || (workItemNodeInstance = (WorkItemNodeInstance)nodeInstance).getWorkItem().getId() != workItemId) continue;
            taskNodeInstance = nodeInstance;
            break;
        }
        return taskNodeInstance;
    }

    protected Set<String> getTaskOutcomes(Node node) {
        LinkedHashSet<String> connectionIds = new LinkedHashSet<String>();
        if (node != null) {
            this.getOutgoingConnectionNames(connectionIds, node);
        }
        return connectionIds;
    }

    protected void getOutgoingConnectionNames(Set<String> connectionIds, Node node) {
        Map outgoingConnections = node.getOutgoingConnections();
        for (Map.Entry outgoingConnectionEntry : outgoingConnections.entrySet()) {
            for (Connection connection : (List)outgoingConnectionEntry.getValue()) {
                if (connection.getTo() instanceof Split) {
                    connectionIds.addAll(this.getConstraintNamesOrderedByPriority(((Split)connection.getTo()).getConstraints().values()));
                    continue;
                }
                if (connection.getTo() instanceof Join) {
                    this.getOutgoingConnectionNames(connectionIds, ((Join)connection.getTo()).getTo().getTo());
                    continue;
                }
                String uniqueId = (String)connection.getMetaData().get("UniqueId");
                connectionIds.add(uniqueId);
            }
        }
    }

    private Collection<String> getConstraintNamesOrderedByPriority(Collection<Constraint> constraints) {
        LinkedList<Constraint> orderedConstraints = new LinkedList<Constraint>(constraints);
        Collections.sort(orderedConstraints, CONSTRAINT_PRIORITY_COMPARATOR);
        return orderedConstraints.stream().map(c -> c.getName()).collect(Collectors.toList());
    }

    protected void updateTaskNode(final JahiaUser user, final String taskUuid) {
        if (taskUuid != null) {
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(user, null, null, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JCRNodeWrapper nodeByUUID = session.getNodeByUUID(taskUuid);
                        if (user != null) {
                            if (!nodeByUUID.hasProperty("assigneeUserKey") || !nodeByUUID.getProperty("assigneeUserKey").getString().equals(user.getName())) {
                                nodeByUUID.setProperty("assigneeUserKey", user.getLocalPath());
                                session.save();
                            }
                        } else if (nodeByUUID.hasProperty("assigneeUserKey")) {
                            nodeByUUID.getProperty("assigneeUserKey").remove();
                            session.save();
                        }
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error("Cannot update task", (Throwable)e);
            }
        }
    }

    protected Map<String, Object> getTaskOutputParameters(Task task, Map<String, Object> taskInputParameters, KieSession ksession, TaskService taskService) {
        Map<String, Object> taskOutputParameters = null;
        if (taskInputParameters != null) {
            Content taskOutputContent = taskService.getContentById(task.getTaskData().getOutputContentId());
            if (taskOutputContent == null) {
                taskOutputParameters = new LinkedHashMap<String, Object>(taskInputParameters);
            } else {
                Object outputContentData = ContentMarshallerHelper.unmarshall((byte[])taskOutputContent.getContent(), (Environment)ksession.getEnvironment());
                if (outputContentData instanceof Map) {
                    taskOutputParameters = (Map)outputContentData;
                }
            }
        }
        return taskOutputParameters;
    }

    protected Map<String, Object> getTaskInputParameters(Task task, KieSession ksession, TaskService taskService) {
        Content taskInputContent = taskService.getContentById(task.getTaskData().getDocumentContentId());
        Object inputContentData = ContentMarshallerHelper.unmarshall((byte[])taskInputContent.getContent(), (Environment)ksession.getEnvironment());
        Map taskInputParameters = null;
        if (inputContentData instanceof Map) {
            taskInputParameters = (Map)inputContentData;
        }
        return taskInputParameters;
    }

    protected boolean checkParticipation(Task task, JahiaUser user) {
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        List potentialOwners = peopleAssignments.getPotentialOwners();
        if (potentialOwners == null || potentialOwners.isEmpty()) {
            return true;
        }
        for (OrganizationalEntity potentialOwner : potentialOwners) {
            if (!(potentialOwner instanceof User ? user.getUserKey().equals(potentialOwner.getId()) : potentialOwner instanceof Group && this.groupManager.getMembershipByPath(user.getLocalPath()).contains(potentialOwner.getId()))) continue;
            return true;
        }
        return false;
    }

    protected ResourceBundle getResourceBundle(Locale uiLocale, String packageName, String definitionKey) {
        try {
            if (this.workflowService.getModuleForWorkflow(definitionKey) != null) {
                JahiaTemplatesPackage module = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.workflowService.getModuleForWorkflow(definitionKey));
                return ResourceBundles.get(packageName + "." + StringUtils.replace((String)definitionKey, (String)" ", (String)""), module, uiLocale);
            }
            return ResourceBundles.get("org.jahia.modules.workflow." + StringUtils.replace((String)definitionKey, (String)" ", (String)""), uiLocale);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    protected void i18nOfWorkflowAction(Locale uiLocale, WorkflowAction workflowAction, String definitionKey, String packageName) {
        ResourceBundle resourceBundle = null;
        if (uiLocale != null) {
            resourceBundle = this.getResourceBundle(uiLocale, packageName, definitionKey);
            String rbActionName = this.i18nName(workflowAction.getName(), resourceBundle);
            workflowAction.setDisplayName(rbActionName);
        }
        if (workflowAction instanceof WorkflowTask) {
            WorkflowTask workflowTask = (WorkflowTask)workflowAction;
            Set<String> outcomes = workflowTask.getOutcomes();
            LinkedList<String> displayOutcomes = new LinkedList<String>();
            LinkedList<String> outcomeIcons = new LinkedList<String>();
            Iterator<String> iterator = outcomes.iterator();
            while (iterator.hasNext()) {
                String outcome;
                String s = outcome = iterator.next();
                String icon = null;
                if (resourceBundle != null) {
                    String key = (StringUtils.replace((String)workflowAction.getName(), (String)" ", (String)".").trim() + "." + StringUtils.replace((String)outcome, (String)" ", (String)".").trim()).toLowerCase();
                    try {
                        s = resourceBundle.getString(key);
                    }
                    catch (Exception e) {
                        logger.warn("Missing ressource : " + key + " in " + String.valueOf(resourceBundle));
                    }
                    try {
                        icon = resourceBundle.getString(key + ".icon");
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                displayOutcomes.add(s);
                outcomeIcons.add(icon);
            }
            workflowTask.setDisplayOutcomes(displayOutcomes);
            workflowTask.setOutcomeIcons(outcomeIcons);
        }
    }

    protected String i18nName(String actionName, ResourceBundle resourceBundle) {
        if (resourceBundle != null) {
            String key = StringUtils.replace((String)actionName, (String)" ", (String)".").trim().toLowerCase();
            try {
                actionName = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                logger.warn("Missing ressource : " + key + " in " + String.valueOf(resourceBundle));
            }
        }
        return actionName;
    }

    protected List<HistoryWorkflow> getHistoryWorkflows(List<String> processIds, Locale uiLocale) {
        ArrayList<HistoryWorkflow> historyWorkflows = new ArrayList<HistoryWorkflow>();
        for (String processId : processIds) {
            ProcessInstanceLog processInstanceLog = this.getLogService().findProcessInstance(Long.parseLong(processId));
            List nodeIdVariableInstanceLogs = this.getLogService().findVariableInstances(Long.parseLong(processId), "nodeId");
            String nodeId = null;
            if (nodeIdVariableInstanceLogs.size() > 0) {
                nodeId = ((VariableInstanceLog)nodeIdVariableInstanceLogs.get(0)).getValue();
            }
            String user = null;
            List userVariableInstanceLogs = this.getLogService().findVariableInstances(Long.parseLong(processId), "user");
            if (userVariableInstanceLogs.size() > 0) {
                user = ((VariableInstanceLog)userVariableInstanceLogs.get(0)).getValue();
            }
            HistoryWorkflow historyWorkflow = new HistoryWorkflow(Long.toString(processInstanceLog.getProcessInstanceId()), this.getWorkflowDefinitionById(processInstanceLog.getProcessId(), uiLocale, this.getKieSession().getKieBase()), processInstanceLog.getProcessName(), this.getKey(), user, processInstanceLog.getStart(), processInstanceLog.getEnd(), processInstanceLog.getOutcome(), nodeId);
            historyWorkflow.setDisplayName(historyWorkflow.getWorkflowDefinition().getDisplayName());
            historyWorkflows.add(historyWorkflow);
        }
        return historyWorkflows;
    }

    public String toString() {
        return String.format("Execute command of class %s", StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
    }
}

