/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.osgi.framework.Bundle;

public class JahiaOsgiKieModule
extends AbstractKieModule {
    private final Bundle bundle;
    private final int bundleUrlPrefixLength;
    private Set<String> fileNames;

    public JahiaOsgiKieModule(ReleaseId releaseId, KieModuleModel kModuleModel, Bundle bundle, int bundleUrlPrefixLength) {
        super(releaseId, kModuleModel);
        this.bundle = bundle;
        this.bundleUrlPrefixLength = bundleUrlPrefixLength;
    }

    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    public boolean isAvailable(String pResourceName) {
        return this.fileNames.contains(pResourceName);
    }

    public byte[] getBytes(String pResourceName) {
        URL url = this.bundle.getEntry(pResourceName);
        return url == null ? null : JahiaOsgiKieModule.readUrlAsBytes(url);
    }

    public Collection<String> getFileNames() {
        if (this.fileNames != null) {
            return this.fileNames;
        }
        this.fileNames = new HashSet<String>();
        Enumeration e = this.bundle.findEntries("", "*", true);
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            String urlString = url.toString();
            if (urlString.endsWith("/")) continue;
            this.fileNames.add(urlString.substring(this.bundleUrlPrefixLength));
        }
        return this.fileNames;
    }

    public File getFile() {
        throw new UnsupportedOperationException();
    }

    private static byte[] readUrlAsBytes(URL url) {
        InputStream is = null;
        try {
            is = url.openStream();
            byte[] byArray = IoUtils.readBytesFromInputStream((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String readUrlAsString(URL url) {
        return new String(JahiaOsgiKieModule.readUrlAsBytes(url));
    }

    private static String getPomProperties(Bundle bundle) {
        Enumeration e = bundle.findEntries("META-INF/maven", "pom.properties", true);
        if (!e.hasMoreElements()) {
            throw new RuntimeException("Cannot find pom.properties file in bundle " + String.valueOf(bundle));
        }
        return JahiaOsgiKieModule.readUrlAsString((URL)e.nextElement());
    }

    public static JahiaOsgiKieModule create(URL url, Bundle bundle) {
        KieModuleModel kieProject = KieModuleModelImpl.fromXML((URL)url);
        String urlString = url.toString();
        String pomProperties = JahiaOsgiKieModule.getPomProperties(bundle);
        ReleaseId releaseId = ReleaseIdImpl.fromPropertiesString((String)pomProperties);
        return new JahiaOsgiKieModule(releaseId, kieProject, bundle, urlString.indexOf("META-INF"));
    }

    public String toString() {
        return "JahiaOsgiKieModule{bundle=" + String.valueOf(this.bundle) + ",releaseId=" + String.valueOf(this.getReleaseId()) + "}";
    }
}

