/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings;

import java.io.File;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.DatabaseUtils;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSettingsInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSettingsInitializer.class);
    public static final String CLUSTER_HAZELCAST_BIND_PORT = "cluster.hazelcast.bindPort";

    public void initClusterSettings(SettingsBean settings) {
        this.checkNeedDiscoveryInfoReset(settings);
        JahiaContextLoaderListener.setSystemProperty("java.net.preferIPv4Stack", Boolean.TRUE.toString());
        if (StringUtils.isEmpty((String)System.getProperty("hazelcast.socket.bind.any"))) {
            JahiaContextLoaderListener.setSystemProperty("hazelcast.socket.bind.any", Boolean.FALSE.toString());
        }
        this.initBindAddress(settings);
        String bindPort = settings.getString("cluster.tcp.bindPort", settings.getString("cluster.tcp.ehcache.jahia.port", null));
        if (StringUtils.isNotEmpty((String)bindPort)) {
            JahiaContextLoaderListener.setSystemProperty("cluster.tcp.bindPort", bindPort);
        }
        JahiaContextLoaderListener.setSystemProperty("cluster.configFile.jahia", settings.getString("cluster.configFile.jahia", "tcp.xml"));
        if (System.getProperty(CLUSTER_HAZELCAST_BIND_PORT) == null) {
            JahiaContextLoaderListener.setSystemProperty(CLUSTER_HAZELCAST_BIND_PORT, settings.getString(CLUSTER_HAZELCAST_BIND_PORT, "7860"));
        }
        if (System.getProperty("cluster.hazelcast.manager.enabled") == null) {
            JahiaContextLoaderListener.setSystemProperty("cluster.hazelcast.manager.enabled", settings.getString("cluster.hazelcast.manager.enabled", "false"));
        }
        if (System.getProperty("cluster.hazelcast.manager.url") == null) {
            JahiaContextLoaderListener.setSystemProperty("cluster.hazelcast.manager.url", settings.getString("cluster.hazelcast.manager.url", "http://localhost:8080/mancenter"));
        }
    }

    private void checkNeedDiscoveryInfoReset(SettingsBean settings) {
        if (settings.isStartupOptionSet("reset-discovery-info") || Boolean.getBoolean("jahia.backup-restore")) {
            try {
                LOGGER.info("Detected startup option for resetting cluster discovery information");
                LOGGER.info("Cleaning database table [JGROUPSPING] ...");
                try {
                    DatabaseUtils.executeStatements(Collections.singletonList("DELETE FROM JGROUPSPING"));
                    LOGGER.info("Database table [JGROUPSPING] successfully cleaned");
                }
                catch (SQLException e) {
                    LOGGER.error("Unable to clean database table: JGROUPSPING", (Throwable)e);
                }
                LOGGER.info("Search and remove [org.apache.karaf.cellar.discovery.config] file from [bundles-deployed] ...");
                File targetConfig = null;
                File bundlesDeployed = new File(settings.getJahiaVarDiskPath() + File.separator + "bundles-deployed");
                if (bundlesDeployed.exists()) {
                    boolean removed = false;
                    File[] bundleFiles = bundlesDeployed.listFiles();
                    if (bundleFiles != null) {
                        for (File bundleFile : bundleFiles) {
                            File discoveryConfig;
                            if (!bundleFile.isDirectory() || !(discoveryConfig = new File(bundleFile, "data" + File.separator + "config" + File.separator + "org" + File.separator + "apache" + File.separator + "karaf" + File.separator + "cellar" + File.separator + "discovery.config")).exists()) continue;
                            targetConfig = discoveryConfig;
                            removed = discoveryConfig.delete();
                            break;
                        }
                    }
                    if (removed) {
                        LOGGER.info("Config file [org.apache.karaf.cellar.discovery.config] at location {} successfully removed", targetConfig);
                    } else if (targetConfig != null) {
                        LOGGER.warn("Unable to delete the [org.apache.karaf.cellar.discovery.config] file at location {}", targetConfig);
                    } else {
                        LOGGER.warn("Config file [org.apache.karaf.cellar.discovery.config] not found");
                    }
                } else {
                    LOGGER.error("Unable to find [bundles-deployed] under {}", (Object)settings.getJahiaVarDiskPath());
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error resetting cluster discovery information. Cause: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void initBindAddress(SettingsBean settings) {
        InetAddress ip;
        String jgroupsBindAddress;
        String bindAddress = settings.getString("cluster.tcp.bindAddress", settings.getString("cluster.tcp.start.ip_address", null));
        if (StringUtils.isEmpty((String)bindAddress) && StringUtils.isNotEmpty((String)(jgroupsBindAddress = System.getProperty("jgroups.bind_addr")))) {
            bindAddress = jgroupsBindAddress;
            LOGGER.info("Using value, supplied via jgroups.bind_addr system property, for the bind address: {}", (Object)bindAddress);
        }
        if (StringUtils.isEmpty((String)bindAddress)) {
            LOGGER.info("No bind address configured, using auto-detected non-loopback one {}", (Object)bindAddress);
            ip = ClusterSettingsInitializer.getNonLoopbackIp();
            if (ip == null) {
                LOGGER.warn("Unable to detect non-loopback network bind address. Please configure cluster.tcp.bindAddress in jahia.node.properties explicitly. For this start we will take the loopback IP.");
                ip = ClusterSettingsInitializer.getLocalHostIp();
            } else {
                LOGGER.info("Detected non-loopback network bind address: {}", (Object)ip.getHostAddress());
            }
        } else {
            InetAddress normalizedIp;
            ip = ClusterSettingsInitializer.toIp(bindAddress);
            if (!ip.getHostAddress().equals(bindAddress)) {
                LOGGER.info("Converted configured bind address to IP: {} to {}", (Object)bindAddress, (Object)ip.getHostAddress());
            }
            if (ip.isLoopbackAddress() && !(normalizedIp = ClusterSettingsInitializer.getLocalHostIp()).equals(ip)) {
                ip = normalizedIp;
                LOGGER.info("Normalized the loopback bind IP: {} to {}", (Object)bindAddress, (Object)ip.getHostAddress());
            }
        }
        LOGGER.info("Setting JGroups bind address to: {}", (Object)ip.getHostAddress());
        JahiaContextLoaderListener.setSystemProperty("cluster.tcp.bindAddress", ip.getHostAddress());
        JahiaContextLoaderListener.setSystemProperty("jgroups.bind_addr", ip.getHostAddress());
    }

    private static InetAddress getNonLoopbackIp() {
        try {
            return Util.getNonLoopbackAddress();
        }
        catch (SocketException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private static InetAddress toIp(String address) {
        PropertyConverters.Default propertyConverter = new PropertyConverters.Default();
        try {
            return (InetAddress)propertyConverter.convert(null, InetAddress.class, null, address, true);
        }
        catch (Exception e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private static InetAddress getLocalHostIp() {
        try {
            return Util.getLocalhost((StackType)Util.getIpStackType());
        }
        catch (UnknownHostException e) {
            throw new JahiaRuntimeException(e);
        }
    }
}

