/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupOptions {
    private static final Logger logger = LoggerFactory.getLogger(StartupOptions.class);
    public static final String OPTION_DISABLE_MAIL_SERVICE = "disable-mail-service";
    public static final String OPTION_INDEX_CHECK = "index-check";
    public static final String OPTION_INDEX_FIX = "index-fix";
    public static final String OPTION_REINDEX = "reindex";
    public static final String OPTION_RESET_DISCOVERY_INFO = "reset-discovery-info";
    private Set<String> options = Collections.emptySet();

    private static boolean deleteMarkerIfPresent(String markerPath, SettingsBean settings) throws IOException {
        File marker = new File(StartupOptions.interpolate(markerPath, settings));
        boolean present = marker.exists();
        if (present) {
            FileUtils.deleteQuietly((File)marker);
        }
        return present;
    }

    private static String interpolate(String marker, SettingsBean settings) throws IOException {
        if (marker.indexOf("#jahia.data.dir#") != -1) {
            return StringUtils.replace((String)marker, (String)"#jahia.data.dir#", (String)settings.getJahiaVarDiskPath());
        }
        if (marker.indexOf("#jahia.jackrabbit.home#") != -1) {
            return StringUtils.replace((String)marker, (String)"#jahia.jackrabbit.home#", (String)settings.getRepositoryHome().getPath());
        }
        return marker;
    }

    StartupOptions(SettingsBean settings, Map<String, Set<String>> mapping) {
        this.init(settings, mapping);
    }

    public Set<String> getOptions() {
        return this.options;
    }

    private void init(SettingsBean settings, Map<String, Set<String>> mapping) {
        HashSet<String> opts = new HashSet<String>();
        logger.debug("Initializing startup options using mapping: {}", mapping);
        try {
            for (Map.Entry<String, Set<String>> mappingEntry : mapping.entrySet()) {
                if (!StartupOptions.deleteMarkerIfPresent(mappingEntry.getKey(), settings)) continue;
                for (String option : mappingEntry.getValue()) {
                    opts.add(option);
                }
                if (!mappingEntry.getKey().endsWith("/backup-restore") && !mappingEntry.getKey().endsWith("/safe-env-clone")) continue;
                JahiaContextLoaderListener.setSystemProperty("jahia.backup-restore", "true");
            }
            this.options = Collections.unmodifiableSet(opts);
            logger.info("Initialized startup options: {}", this.options);
        }
        catch (IOException e) {
            logger.error("Unable to initialize startup options", (Throwable)e);
        }
    }

    public boolean isSet(String option) {
        return this.options.contains(option);
    }
}

