/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings.readonlymode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jahia.services.SpringContextSingleton;
import org.jahia.settings.readonlymode.ReadOnlyModeCapable;
import org.jahia.settings.readonlymode.ReadOnlyModeException;
import org.jahia.settings.readonlymode.ReadOnlyModeStatusInfo;
import org.jahia.settings.readonlymode.ReadOnlyModeStatusSupplier;
import org.jahia.settings.readonlymode.ReadOnlyModeSwitchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadOnlyModeController
implements Serializable {
    private static final Comparator<ReadOnlyModeCapable> SERVICES_COMPARATOR_BY_PRIORITY = Comparator.comparingInt(ReadOnlyModeCapable::getReadOnlyModePriority);
    private static final long serialVersionUID = 5240686816879033535L;
    private static final Logger logger = LoggerFactory.getLogger(ReadOnlyModeController.class);
    private final transient Collection<ReadOnlyModeSwitchListener> switchListeners = new CopyOnWriteArrayList<ReadOnlyModeSwitchListener>();
    private final transient Collection<ReadOnlyModeStatusSupplier> statusSuppliers = new CopyOnWriteArrayList<ReadOnlyModeStatusSupplier>();
    private volatile transient ReadOnlyModeStatus readOnlyStatus = ReadOnlyModeStatus.OFF;

    public static void readOnlyModeViolated(String message) throws ReadOnlyModeException {
        throw new ReadOnlyModeException(message);
    }

    public static ReadOnlyModeController getInstance() {
        return Holder.INSTANCE;
    }

    public synchronized void switchReadOnlyMode(boolean enable) {
        ReadOnlyModeStatus targetStatus = enable ? ReadOnlyModeStatus.ON : ReadOnlyModeStatus.OFF;
        logger.info("Received request to switch read only mode to {}", (Object)targetStatus);
        if (targetStatus != this.readOnlyStatus) {
            if (!this.isStatusUpdateAllowed(enable)) {
                throw new IllegalStateException("The read-only mode state is " + String.valueOf((Object)this.readOnlyStatus) + ", unable to switch to " + String.valueOf((Object)targetStatus));
            }
            this.readOnlyStatus = enable ? ReadOnlyModeStatus.PENDING_ON : ReadOnlyModeStatus.PENDING_OFF;
            LinkedList<ReadOnlyModeCapable> services = new LinkedList<ReadOnlyModeCapable>(SpringContextSingleton.getBeansOfType(ReadOnlyModeCapable.class).values());
            Collections.sort(services, enable ? SERVICES_COMPARATOR_BY_PRIORITY.reversed() : SERVICES_COMPARATOR_BY_PRIORITY);
            logger.info("Switching read only status of {} services", (Object)services.size());
            for (ReadOnlyModeCapable service : services) {
                try {
                    service.switchReadOnlyMode(enable);
                }
                catch (RuntimeException e) {
                    this.readOnlyStatus = enable ? ReadOnlyModeStatus.PARTIAL_ON : ReadOnlyModeStatus.PARTIAL_OFF;
                    logger.error("Error switching read only status of the service " + String.valueOf(service), (Throwable)e);
                    throw e;
                }
            }
            this.readOnlyStatus = targetStatus;
        }
        this.notifyReadOnlyModeSwitched(enable);
        logger.info("Finished read-only mode switch. Now the read-only mode is {}", (Object)this.readOnlyStatus);
    }

    public ReadOnlyModeStatus getReadOnlyStatus() {
        return this.readOnlyStatus;
    }

    public List<ReadOnlyModeStatusInfo> getReadOnlyStatuses() {
        ArrayList<ReadOnlyModeStatusInfo> statuses = new ArrayList<ReadOnlyModeStatusInfo>();
        statuses.add(new ReadOnlyModeStatusInfo("local", this.getReadOnlyStatus()));
        for (ReadOnlyModeStatusSupplier supplier : this.statusSuppliers) {
            statuses.addAll(supplier.getStatuses());
        }
        return statuses;
    }

    public void addSwitchListener(ReadOnlyModeSwitchListener listener) {
        Objects.requireNonNull(listener);
        this.switchListeners.add(listener);
    }

    public void removeSwitchListener(ReadOnlyModeSwitchListener listener) {
        Objects.requireNonNull(listener);
        this.switchListeners.remove(listener);
    }

    public void addStatusSupplier(ReadOnlyModeStatusSupplier supplier) {
        Objects.requireNonNull(supplier);
        this.statusSuppliers.add(supplier);
    }

    public void removeStatusSupplier(ReadOnlyModeStatusSupplier supplier) {
        Objects.requireNonNull(supplier);
        this.statusSuppliers.remove(supplier);
    }

    private void notifyReadOnlyModeSwitched(boolean enabled) {
        for (ReadOnlyModeSwitchListener listener : this.switchListeners) {
            listener.onReadOnlyModeSwitched(enabled);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatusUpdateAllowed(boolean switchModeTo) {
        if (switchModeTo) {
            if (this.readOnlyStatus == ReadOnlyModeStatus.OFF) {
                return true;
            }
        } else if (this.readOnlyStatus == ReadOnlyModeStatus.ON) return true;
        if (this.readOnlyStatus == ReadOnlyModeStatus.PARTIAL_ON) return true;
        if (this.readOnlyStatus != ReadOnlyModeStatus.PARTIAL_OFF) return false;
        return true;
    }

    private static class Holder {
        static final ReadOnlyModeController INSTANCE = new ReadOnlyModeController();

        private Holder() {
        }
    }

    public static enum ReadOnlyModeStatus {
        OFF,
        ON,
        PENDING_ON,
        PENDING_OFF,
        PARTIAL_ON,
        PARTIAL_OFF;

    }
}

