/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.jvm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServerConnection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jahia.bin.errors.ErrorFileDumper;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ThreadMonitor.class);
    public static final String THREAD_MONITOR_DEACTIVATED = "ThreadMonitor deactivated.";
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH);
    private static final String DUMP_END = "\n<EndOfDump>\n\n";
    private static String INDENT = "    ";
    private String dumpPrefix = "\nFull thread dump ";
    private ThreadMXBean tmbean;
    private static volatile ThreadMonitor instance;
    private Timer timer;
    private boolean debugLogging = false;
    private AtomicBoolean alreadyDumping = new AtomicBoolean(false);
    private boolean activated = true;
    private long minimalIntervalBetweenDumps = 500L;
    private long lastDumpTime = -1L;
    private long dumpsGenerated = 0L;

    private static File getNextThreadDumpFile(String postfix) {
        Date now = new Date();
        File todaysDirectory = new File(SettingsBean.getThreadDir(), ErrorFileDumper.DATE_FORMAT_DIRECTORY.format(now));
        todaysDirectory.mkdirs();
        return new File(todaysDirectory, "thread-dump-" + ErrorFileDumper.DATE_FORMAT_FILE.format(now) + (postfix != null ? postfix : "") + ".out");
    }

    private void debug(String msg) {
        if (this.debugLogging) {
            System.out.println(msg);
        }
    }

    private static void out(String msg) {
        System.out.println(msg);
    }

    private ThreadMonitor() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    private ThreadMonitor(MBeanServerConnection server) {
        this.setMBeanServerConnection(server);
        try {
            this.parseMBeanInfo();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadMonitor getInstance() {
        if (instance != null) return instance;
        Class<ThreadMonitor> clazz = ThreadMonitor.class;
        synchronized (ThreadMonitor.class) {
            if (instance != null) return instance;
            instance = new ThreadMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void shutdownInstance() {
        if (instance == null) {
            return;
        }
        instance.shutdown();
        instance = null;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    public void setDebugLogging(boolean debugLogging) {
        this.debugLogging = debugLogging;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public long getMinimalIntervalBetweenDumps() {
        return this.minimalIntervalBetweenDumps;
    }

    public void setMinimalIntervalBetweenDumps(long minimalIntervalBetweenDumps) {
        this.minimalIntervalBetweenDumps = minimalIntervalBetweenDumps;
    }

    public boolean isDumping() {
        return this.alreadyDumping.get();
    }

    private void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private boolean acquireAlreadyDumping() {
        boolean dumping = this.alreadyDumping.get();
        if (dumping) {
            this.debug("Thread dump already in progress, ignoring...");
            return true;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastDumpTime <= this.minimalIntervalBetweenDumps) {
            this.debug("Cannot dump threads as minimal interval (" + this.minimalIntervalBetweenDumps + "ms) between dumps has not elapsed (=" + (currentTime - this.lastDumpTime) + "ms)");
            return true;
        }
        this.debug("More than minimal interval (" + this.minimalIntervalBetweenDumps + "ms) has elapsed (=" + (currentTime - this.lastDumpTime) + "ms), letting dump go through...");
        this.alreadyDumping.set(true);
        return false;
    }

    private void releaseAlreadyDumping() {
        this.lastDumpTime = System.currentTimeMillis();
        ++this.dumpsGenerated;
        this.alreadyDumping.set(false);
        this.debug("Released dumping lock, alreadyDumping=" + this.alreadyDumping.get());
    }

    private void cancelTimer() {
        this.timer.cancel();
        this.timer = null;
    }

    public File dumpThreadInfo(boolean toSysOut, boolean toFile) {
        if (!this.activated) {
            return null;
        }
        if (!toSysOut && !toFile) {
            return null;
        }
        if (this.acquireAlreadyDumping()) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        String threadInfo = this.getFullThreadInfo();
        if (toSysOut) {
            System.out.print(threadInfo);
        }
        File dumpFile = null;
        if (toFile) {
            dumpFile = ThreadMonitor.getNextThreadDumpFile(null);
            try {
                FileUtils.writeStringToFile((File)dumpFile, (String)threadInfo, (String)"UTF-8");
                long dumpTime = System.currentTimeMillis() - startTime;
                ThreadMonitor.out("Wrote thread dump to file " + dumpFile.getAbsolutePath() + " in " + dumpTime + " ms");
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.releaseAlreadyDumping();
        return dumpFile;
    }

    private void dumpThreadInfo(StringBuilder dump) {
        dump.append(this.getDumpDate());
        dump.append(this.dumpPrefix);
        dump.append("\n");
        long[] tids = this.tmbean.getAllThreadIds();
        ThreadInfo[] tinfos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE);
        for (int i = 0; i < tinfos.length; ++i) {
            ThreadInfo ti = tinfos[i];
            if (ti == null) continue;
            this.printThreadInfo(ti, dump);
        }
        dump.append(DUMP_END);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpThreadInfoUsingJstack(StringBuilder dump) {
        BufferedReader br = null;
        try {
            Process p = Runtime.getRuntime().exec("jstack " + JahiaContextLoaderListener.getPid());
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = br.readLine();
            while (line != null) {
                dump.append(line).append("\n");
                line = br.readLine();
            }
            IOUtils.closeQuietly((Reader)br);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(br);
        }
    }

    public File dumpThreadInfoWithInterval(boolean toSysOut, boolean toFile, int threadDumpCount, int intervalSeconds) {
        if (!this.activated) {
            return null;
        }
        if (threadDumpCount < 1 || intervalSeconds < 1 || !toSysOut && !toFile) {
            return null;
        }
        if (this.acquireAlreadyDumping()) {
            return null;
        }
        if (this.timer == null) {
            this.timer = new Timer("DumpThreadInfoWithInterval", true);
        }
        File file = toFile ? ThreadMonitor.getNextThreadDumpFile("-" + threadDumpCount + "-executions") : null;
        this.timer.schedule((TimerTask)new ThreadDumpTask(threadDumpCount, toSysOut, file), 0L, (long)intervalSeconds * 1000L);
        return file;
    }

    public String findDeadlock() {
        if (!this.activated) {
            return THREAD_MONITOR_DEACTIVATED;
        }
        if (this.acquireAlreadyDumping()) {
            return "Dead lock detection already in progress in another thread, will not report";
        }
        StringBuilder dump = new StringBuilder();
        long[] tids = this.tmbean.findMonitorDeadlockedThreads();
        if (tids == null) {
            this.releaseAlreadyDumping();
            return null;
        }
        dump.append("\n\nFound one Java-level deadlock:\n");
        dump.append("==============================\n");
        ThreadInfo[] infos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE);
        for (int i = 1; i < infos.length; ++i) {
            ThreadInfo ti = infos[i];
            this.printThreadInfo(ti, dump);
        }
        this.releaseAlreadyDumping();
        return dump.toString();
    }

    public void generateThreadInfo(Writer writer) {
        if (!this.activated) {
            try {
                writer.write(THREAD_MONITOR_DEACTIVATED);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
        if (this.acquireAlreadyDumping()) {
            try {
                writer.write("Thread info generation already in progress in another thread.");
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
        try {
            writer.write(this.getFullThreadInfo());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseAlreadyDumping();
        }
    }

    private String getDumpDate() {
        return DATE_FORMAT.format(new Date());
    }

    private String getFullThreadInfo() {
        StringBuilder dump = new StringBuilder(65536);
        if (SettingsBean.getInstance() != null && SettingsBean.getInstance().isUseJstackForThreadDumps()) {
            this.dumpThreadInfoUsingJstack(dump);
        } else {
            this.dumpThreadInfo(dump);
        }
        return dump.toString();
    }

    private void parseMBeanInfo() throws IOException {
        this.setDumpPrefix();
    }

    private void printThread(ThreadInfo ti, StringBuilder dump) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\" nid=" + ti.getThreadId() + " state=" + String.valueOf((Object)ti.getThreadState()));
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        sb.append(" []\n" + Patterns.DOLLAR.matcher(((Object)((Object)ti.getThreadState())).getClass().getName()).replaceAll(".") + ": " + String.valueOf((Object)ti.getThreadState()));
        if (ti.getLockName() != null && ti.getThreadState() != Thread.State.BLOCKED) {
            String[] lockInfo = Patterns.AT.split(ti.getLockName());
            sb.append("\n" + INDENT + "- waiting on <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
            sb.append("\n" + INDENT + "- locked <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
        } else if (ti.getLockName() != null && ti.getThreadState() == Thread.State.BLOCKED) {
            String[] lockInfo = Patterns.AT.split(ti.getLockName());
            sb.append("\n" + INDENT + "- waiting to lock <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
        }
        dump.append(sb.toString());
        dump.append("\n");
        if (ti.getLockOwnerName() != null) {
            dump.append(INDENT + " owned by " + ti.getLockOwnerName() + " id=" + ti.getLockOwnerId());
            dump.append("\n");
        }
    }

    private void printThreadInfo(ThreadInfo ti, StringBuilder dump) {
        this.printThread(ti, dump);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            dump.append(INDENT + "at " + ste.toString());
            dump.append("\n");
        }
        dump.append("\n");
    }

    private void setDumpPrefix() {
        RuntimeMXBean rmbean = ManagementFactory.getRuntimeMXBean();
        this.dumpPrefix = this.dumpPrefix + rmbean.getVmName() + " (" + rmbean.getVmVersion() + ")\n";
    }

    void setMBeanServerConnection(MBeanServerConnection mbs) {
        this.tmbean = ManagementFactory.getThreadMXBean();
    }

    public long getDumpsGenerated() {
        return this.dumpsGenerated;
    }

    public long getLastDumpTime() {
        return this.lastDumpTime;
    }

    private class ThreadDumpTask
    extends TimerTask {
        private int executionCount;
        private int numberOfExecutions;
        private File targetFile;
        private boolean toSystemOut;

        ThreadDumpTask(int numberOfExecutions, boolean toSystemOut, File targetFile) {
            this.numberOfExecutions = numberOfExecutions;
            this.targetFile = targetFile;
            this.toSystemOut = toSystemOut;
            ThreadMonitor.out("Starting thread dump task for " + numberOfExecutions + " executions into a file " + String.valueOf(targetFile));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ++this.executionCount;
            if (this.executionCount > this.numberOfExecutions) {
                return;
            }
            ThreadMonitor.out("Executing thread dump " + this.executionCount + " of " + this.numberOfExecutions);
            FileOutputStream out = null;
            long startTime = System.currentTimeMillis();
            try {
                String dump = ThreadMonitor.getInstance().getFullThreadInfo();
                if (this.toSystemOut) {
                    System.out.println(dump);
                }
                if (this.targetFile != null) {
                    out = new FileOutputStream(this.targetFile, true);
                    ((OutputStream)out).write(dump.getBytes("UTF-8"));
                    out.flush();
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.targetFile != null) {
                    IOUtils.closeQuietly(out);
                    long dumpTime = System.currentTimeMillis() - startTime;
                    ThreadMonitor.this.debug("Appended thread dump to file " + this.targetFile.getAbsolutePath() + " in " + dumpTime + " ms");
                }
                if (this.executionCount >= this.numberOfExecutions) {
                    ThreadMonitor.this.cancelTimer();
                    ThreadMonitor.out("Stopping thread dump task after " + this.executionCount + " executions into a file " + String.valueOf(this.targetFile));
                    ThreadMonitor.getInstance().releaseAlreadyDumping();
                }
            }
        }
    }
}

