/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import javax.servlet.Servlet;
import org.jahia.osgi.BundleLifecycleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.tools.patches.PatchExecutor;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlPatcher
implements PatchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlPatcher.class);
    private static final int TIMEOUT = 60000;

    @Override
    public boolean canExecute(String name, String lifecyclePhase) {
        return name.endsWith(lifecyclePhase + ".graphql");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeScript(String name, String scriptContent) {
        try {
            BundleContext context = FrameworkService.getBundleContext();
            String filter = "(component.name=graphql.kickstart.servlet.OsgiGraphQLHttpServlet)";
            ServiceTracker configurationAdminTracker = new ServiceTracker(context, context.createFilter(filter), null);
            configurationAdminTracker.open();
            Servlet servlet = (Servlet)configurationAdminTracker.waitForService(60000L);
            configurationAdminTracker.close();
            if (servlet == null) {
                logger.error("Cannot find OSGi graphql servlet to execute patch");
                String string = ".failed";
                return string;
            }
            JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser());
            String[] mutations = (String[])servlet.getClass().getMethod("getMutations", new Class[0]).invoke((Object)servlet, new Object[0]);
            if (mutations == null || mutations.length == 0) {
                logger.warn("No mutations found in graphql servlet, attempting to rewire graphql dxm provider.");
                ServiceReference[] serviceReferences = context.getServiceReferences("graphql.kickstart.servlet.osgi.GraphQLProvider", "(component.name=org.jahia.modules.graphql.provider.dxm.DXGraphQLProvider)");
                if (serviceReferences == null || serviceReferences.length == 0) {
                    logger.error("Cannot find OSGi Jahia graphql provider to rewire mutations");
                    String string = ".failed";
                    return string;
                }
                logger.info("Refreshing Jahia graphql provider to rewire mutations, will perform patch once refreshed.");
                BundleLifecycleUtils.refreshBundle(serviceReferences[0].getBundle());
                logger.info("Refreshed Jahia graphql provider will perform patch now.");
            } else {
                logger.info("Found {} mutations in graphql servlet, will execute patch.", (Object)mutations.length);
            }
            String json = (String)servlet.getClass().getMethod("executeQuery", String.class).invoke((Object)servlet, scriptContent);
            logger.info("Graphql execution result : {}", (Object)json);
            JSONObject object = new JSONObject(json);
            if (object.has("errors") && object.getJSONArray("errors").length() > 0) {
                String string = ".failed";
                return string;
            }
            String string = ".installed";
            return string;
        }
        catch (Exception e) {
            logger.error("Execution of script failed with error: {}", (Object)e.getMessage(), (Object)e);
            String string = ".failed";
            return string;
        }
        finally {
            JCRSessionFactory.getInstance().setCurrentUser(null);
        }
    }
}

