/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.jahia.commons.DatabaseScripts;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public final class DatabaseUtils {
    public static final String TEST_TABLE = "jahia_nodetypes_provider";
    private static volatile DatabaseType dbType;
    private static volatile DataSource ds;
    private static final Logger logger;
    private static final Comparator<Resource> SCRIPT_RESOURCE_COMPARATOR;

    public static void closeQuietly(Object closable) {
        if (closable == null) {
            return;
        }
        try {
            if (closable instanceof Connection) {
                ((Connection)closable).close();
            } else if (closable instanceof Statement) {
                ((Statement)closable).close();
            } else if (closable instanceof ResultSet) {
                ((ResultSet)closable).close();
            } else if (closable instanceof ScrollableResults) {
                ((ScrollableResults)closable).close();
            } else if (closable instanceof Session) {
                ((Session)closable).close();
            } else if (closable instanceof StatelessSession) {
                ((StatelessSession)closable).close();
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            logger.warn(e.getMessage());
        }
    }

    public static void executeScript(Resource sqlScript) throws SQLException, IOException {
        DatabaseUtils.executeScript(new InputStreamReader(sqlScript.getInputStream(), Charsets.UTF_8));
    }

    public static void executeScript(Reader sqlScript) throws SQLException, IOException {
        DatabaseUtils.executeStatements(DatabaseScripts.getScriptStatements((Reader)sqlScript));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeStatements(List<String> statements) throws SQLException {
        logger.info("Executing {} statement(s)...", (Object)statements.size());
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        try {
            conn = DatabaseUtils.getDatasource().getConnection();
            DatabaseScripts.executeStatements(statements, (Connection)conn);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            if (conn != null && !conn.getAutoCommit()) {
                conn.rollback();
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
            logger.info("Done executing {} statement(s) in {} ms", (Object)statements.size(), (Object)(System.currentTimeMillis() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String query) throws SQLException {
        int result = 0;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DatabaseUtils.getDatasource().getConnection();
            stmt = conn.createStatement();
            result = stmt.executeUpdate(query);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            if (conn != null && !conn.getAutoCommit()) {
                conn.rollback();
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseType getDatabaseType() {
        if (dbType != null) return dbType;
        Class<DatabaseUtils> clazz = DatabaseUtils.class;
        synchronized (DatabaseUtils.class) {
            if (dbType != null) return dbType;
            dbType = DatabaseType.valueOf(StringUtils.substringBefore((String)StringUtils.substringBefore((String)SettingsBean.getInstance().getPropertiesFile().getProperty("db_script").trim(), (String)"."), (String)"_"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSource getDatasource() {
        if (ds != null) return ds;
        Class<DatabaseUtils> clazz = DatabaseUtils.class;
        synchronized (DatabaseUtils.class) {
            if (ds != null) return ds;
            ds = (DataSource)SpringContextSingleton.getBean("dataSource");
            // ** MonitorExit[var0] (shouldn't be in output)
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScrollMode getFirstSupportedScrollMode(ScrollMode fallback, ScrollMode ... scrollModesToTest) {
        ScrollMode supportedMode = null;
        Connection conn = null;
        try {
            conn = DatabaseUtils.getDatasource().getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            for (ScrollMode scrollMode : scrollModesToTest) {
                if (!metaData.supportsResultSetType(scrollMode.toResultSetType())) continue;
                supportedMode = scrollMode;
                break;
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Unlable to check supported scrollable resultset type. Cause: " + e.getMessage(), (Throwable)e);
            } else {
                logger.warn("Unlable to check supported scrollable resultset type. Cause: " + e.getMessage());
            }
        }
        finally {
            DatabaseUtils.closeQuietly(conn);
        }
        return supportedMode != null ? supportedMode : fallback;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isDatabaseStructureInitialized() {
        try {
            Connection conn = ds.getConnection();
            try {
                boolean bl;
                block20: {
                    Statement stmt = conn.createStatement();
                    try {
                        try {
                            stmt.executeQuery("select count(*) from jahia_nodetypes_provider");
                        }
                        catch (SQLException e) {
                            boolean bl2 = false;
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (conn != null) {
                                conn.close();
                            }
                            return bl2;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    bl = true;
                    if (stmt == null) break block20;
                    stmt.close();
                }
                return bl;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        throwable3.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    public static void initializeDatabaseStructure(String varDir, ApplicationContext applicationContext) {
        try {
            Resource[] scripts;
            for (Resource script : scripts = DatabaseUtils.getScripts(varDir + "/db/sql/schema", applicationContext)) {
                String path = script.getFile().getCanonicalPath();
                logger.info("Excecuting {}...", (Object)path);
                long startAt = System.currentTimeMillis();
                DatabaseUtils.executeScript(script);
                logger.info("Finished excecuting {} in {} ms", (Object)path, (Object)(System.currentTimeMillis() - startAt));
            }
        }
        catch (IOException | SQLException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    public static Resource[] getScripts(String basePath, ApplicationContext applicationContext) throws IOException {
        String folder = "file:" + basePath + "/" + String.valueOf((Object)DatabaseUtils.getDatabaseType());
        if (applicationContext.getResource(folder).exists()) {
            Resource[] scripts = applicationContext.getResources(folder + "/**/*.sql");
            Arrays.sort(scripts, SCRIPT_RESOURCE_COMPARATOR);
            return scripts;
        }
        return new Resource[0];
    }

    public static SessionFactory getHibernateSessionFactory() {
        return (SessionFactory)SpringContextSingleton.getBean("sessionFactory");
    }

    public static void setDatasource(DataSource ds) {
        DatabaseUtils.ds = ds;
    }

    private DatabaseUtils() {
    }

    static {
        logger = LoggerFactory.getLogger(DatabaseUtils.class);
        SCRIPT_RESOURCE_COMPARATOR = new Comparator<Resource>(){

            @Override
            public int compare(Resource resource1, Resource resource2) {
                try {
                    return resource1.getFile().getCanonicalPath().compareTo(resource2.getFile().getCanonicalPath());
                }
                catch (IOException e) {
                    throw new JahiaRuntimeException(e);
                }
            }
        };
    }

    public static enum DatabaseType {
        derby,
        mssql,
        mysql,
        oracle,
        postgresql,
        mariadb;

    }
}

