/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.SpringContextSingleton;
import org.jodconverter.core.document.DefaultDocumentFormatRegistry;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

public final class FileUtils {
    private static DocumentFormatRegistry formatRegistry = DefaultDocumentFormatRegistry.getInstance();

    public static String calculateDigest(InputStream is) {
        String string;
        block9: {
            DigestInputStream digestInputStream = FileUtils.toDigestInputStream(is instanceof BufferedInputStream ? is : new BufferedInputStream(is));
            try {
                byte[] b = new byte[8192];
                int read = 0;
                while (read != -1) {
                    read = digestInputStream.read(b);
                }
                string = Hex.encodeHexString((byte[])digestInputStream.getMessageDigest().digest());
                if (digestInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (digestInputStream != null) {
                        try {
                            digestInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JahiaRuntimeException(e);
                }
            }
            digestInputStream.close();
        }
        return string;
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public static void cleanDirectory(File directory, FileFilter filter) throws IOException {
        if (!directory.exists()) {
            String message = String.valueOf(directory) + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = String.valueOf(directory) + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + String.valueOf(directory));
        }
        if (files.length == 0) {
            return;
        }
        IOException exception = null;
        for (File file : files) {
            if (filter != null && !filter.accept(file)) continue;
            try {
                org.apache.commons.io.FileUtils.forceDelete((File)file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static String getContent(Resource resource) throws IOException {
        String content = null;
        InputStream is = null;
        try {
            is = resource.getInputStream();
            content = IOUtils.toString((InputStream)is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return content;
    }

    public static String getExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }

    public static String getExtensionFromMimeType(String mimeType) {
        DocumentFormat df = formatRegistry.getFormatByMediaType(mimeType);
        if (df == null) {
            return null;
        }
        return df.getExtension();
    }

    private static Map<String, String> getFileExtensionIcons() {
        return Holder.fileExtensionIcons;
    }

    private static Map<String, String> getFileMimeTypeIcons() {
        return Holder.fileMimeTypeIcons;
    }

    public static String[] getFileExtensionIconsMapping() {
        return Arrays.copyOf(Holder.fileExtensionIconsMapping, Holder.fileExtensionIconsMapping.length);
    }

    public static String getFileIcon(String fileName) {
        Map<String, String> mappings;
        String ext = "unknown";
        if (StringUtils.isNotEmpty((String)fileName)) {
            int index = FilenameUtils.indexOfExtension((String)fileName);
            ext = index != -1 ? fileName.substring(index + 1) : fileName;
            ext = ext.toLowerCase();
        }
        if ((mappings = FileUtils.getFileExtensionIcons()) == null) {
            return "file";
        }
        String icon = mappings.get(ext);
        return icon != null ? icon : mappings.get("unknown");
    }

    public static String getFileIconFromMimetype(String mimeType) {
        if (StringUtils.isNotEmpty((String)mimeType)) {
            String mappedMimeTypeIcon = FileUtils.getFileMimeTypeIcons().get(mimeType);
            if (mappedMimeTypeIcon != null) {
                return mappedMimeTypeIcon;
            }
            for (Map.Entry<String, String> mappedMimeTypeEntry : FileUtils.getFileMimeTypeIcons().entrySet()) {
                if (!mappedMimeTypeEntry.getKey().endsWith("*") || !mimeType.startsWith(StringUtils.substringBeforeLast((String)mappedMimeTypeEntry.getKey(), (String)"*"))) continue;
                return mappedMimeTypeEntry.getValue();
            }
        }
        return FileUtils.getFileMimeTypeIcons().get("unknown");
    }

    public static long getLastModified(Resource resource) throws IOException {
        URL resourceUrl = resource.getURL();
        return ResourceUtils.isJarURL((URL)resourceUrl) ? ResourceUtils.getFile((URL)ResourceUtils.extractJarFileURL((URL)resourceUrl)).lastModified() : resource.lastModified();
    }

    public static List<DocumentFormat> getPossibleFormats() {
        LinkedHashSet map = new LinkedHashSet();
        Set formatSet = formatRegistry.getOutputFormats(DocumentFamily.TEXT);
        map.addAll(formatSet);
        formatSet = formatRegistry.getOutputFormats(DocumentFamily.SPREADSHEET);
        map.addAll(formatSet);
        formatSet = formatRegistry.getOutputFormats(DocumentFamily.PRESENTATION);
        map.addAll(formatSet);
        formatSet = formatRegistry.getOutputFormats(DocumentFamily.DRAWING);
        map.addAll(formatSet);
        ArrayList<DocumentFormat> list = new ArrayList<DocumentFormat>(map);
        Collections.sort(list, new Comparator<DocumentFormat>(){

            @Override
            public int compare(DocumentFormat o1, DocumentFormat o2) {
                return o1.getExtension().compareTo(o2.getExtension());
            }
        });
        return list;
    }

    public static String humanReadableByteCount(long bytes) {
        return FileUtils.humanReadableByteCount(bytes, false);
    }

    public static String humanReadableByteCount(long bytes, boolean withDetails) {
        if (bytes < 1024L) {
            return bytes + " bytes";
        }
        StringBuilder display = new StringBuilder();
        long divider = 1024L;
        if (bytes / 0x40000000L > 0L) {
            divider = 0x40000000L;
            display.append(" GB");
        } else if (bytes / 0x100000L > 0L) {
            divider = 0x100000L;
            display.append(" MB");
        } else {
            display.append(" KB");
        }
        display.insert(0, new DecimalFormat("###,###,###,###,###,###,###.##").format((double)bytes / (double)divider));
        if (withDetails) {
            display.append(" (").append(new DecimalFormat("###,###,###,###,###,###,###").format(bytes)).append(" bytes)");
        }
        return display.toString();
    }

    public static void moveDirectoryContentToDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        File[] files = srcDir.listFiles();
        if (files != null && files.length > 0) {
            for (File f : files) {
                if (filter != null && !filter.accept(f)) continue;
                org.apache.commons.io.FileUtils.moveToDirectory((File)f, (File)destDir, (boolean)true);
            }
        }
    }

    private static DigestInputStream toDigestInputStream(InputStream is) {
        try {
            return new DigestInputStream(is, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private FileUtils() {
    }

    private static class Holder {
        static final Map<String, String> fileExtensionIcons;
        static final Map<String, String> fileMimeTypeIcons;
        static final String[] fileExtensionIconsMapping;

        private Holder() {
        }

        static {
            Map icons = (Map)SpringContextSingleton.getBean("fileExtensionIcons");
            FastHashMap mappings = new FastHashMap(icons);
            mappings.setFast(true);
            String[] jsMappings = new String[]{new StringBuilder(512).append("\"").append(StringUtils.join(mappings.keySet().iterator(), (String)"\", \"")).append("\"").toString(), new StringBuilder(512).append("\"").append(StringUtils.join(mappings.values().iterator(), (String)"\", \"")).append("\"").toString()};
            fileExtensionIconsMapping = jsMappings;
            fileExtensionIcons = mappings;
            fileMimeTypeIcons = new FastHashMap((Map)SpringContextSingleton.getBean("fileMimeTypeIcons"));
        }
    }
}

