/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.properties;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesManager {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesManager.class);
    public Properties properties = new Properties();
    public String propertiesFilePath;

    public PropertiesManager() {
    }

    public PropertiesManager(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
        this.loadProperties();
    }

    public PropertiesManager(Properties properties) {
        this.properties = properties;
    }

    private void loadProperties() {
        this.properties = new Properties();
        File file = new File(this.propertiesFilePath);
        if (!file.exists()) {
            return;
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            this.properties.load(inputStream);
        }
        catch (IOException ioe) {
            logger.error("IOException on loadProperties().", (Throwable)ioe);
        }
        catch (SecurityException se) {
            logger.error("SecurityException on file [" + this.propertiesFilePath + "]", (Throwable)se);
        }
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public void setProperty(String propertyName, String propvalue) {
        this.properties.setProperty(propertyName, propvalue);
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public void storeProperties() {
        try {
            this.storeProperties(this.propertiesFilePath);
        }
        catch (NullPointerException npe) {
            logger.error("NullPointerException on storeProperties().", (Throwable)npe);
        }
    }

    public void storeProperties(String propertiesFilePath) {
        block23: {
            File propertiesFileObject = new File(propertiesFilePath);
            File propertiesFileFolder = propertiesFileObject.getParentFile();
            if (!propertiesFileFolder.exists()) {
                propertiesFileFolder.mkdirs();
                propertiesFileFolder = null;
            }
            try {
                if (new File(this.propertiesFilePath).exists()) {
                    ArrayList<String> bufferList = new ArrayList<String>();
                    String lineReaded = null;
                    try (BufferedReader buffered = new BufferedReader(new FileReader(this.propertiesFilePath));){
                        int position = 0;
                        ArrayList<String> allProperties = Collections.list(this.properties.propertyNames());
                        while ((lineReaded = buffered.readLine()) != null) {
                            try {
                                lineReaded = lineReaded.replaceAll("\\t", "    ");
                                if (!lineReaded.trim().equals("") && !lineReaded.trim().substring(0, 1).equals("#")) {
                                    boolean propertyFound = false;
                                    Iterator propertyNames = allProperties.iterator();
                                    while (propertyNames.hasNext() && !propertyFound) {
                                        String propertyName = (String)propertyNames.next();
                                        String propvalue = this.properties.getProperty(propertyName);
                                        if (lineReaded.indexOf(propertyName + " ") != 0 || (position = lineReaded.indexOf(61)) < 0) continue;
                                        propertyFound = true;
                                        StringBuilder thisLineBuffer = new StringBuilder();
                                        thisLineBuffer.append(lineReaded.substring(0, position + 1));
                                        thisLineBuffer.append("   ");
                                        thisLineBuffer.append(PropertiesManager.string2Property(propvalue));
                                        bufferList.add(thisLineBuffer.toString());
                                        allProperties.remove(propertyName);
                                    }
                                    continue;
                                }
                                bufferList.add(lineReaded.trim());
                            }
                            catch (IndexOutOfBoundsException propertyFound) {
                            }
                            catch (IllegalArgumentException ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                        for (String restantPropertyName : allProperties) {
                            StringBuilder specialLineBuffer = new StringBuilder();
                            specialLineBuffer.append(restantPropertyName);
                            for (int i = 0; i < 55 - restantPropertyName.length(); ++i) {
                                specialLineBuffer.append(" ");
                            }
                            specialLineBuffer.append("=   ");
                            specialLineBuffer.append(this.properties.getProperty(restantPropertyName));
                            bufferList.add(specialLineBuffer.toString());
                        }
                    }
                    this.writeTheFile(propertiesFilePath, bufferList);
                    break block23;
                }
                try (FileOutputStream outputStream = new FileOutputStream(propertiesFileObject);){
                    this.properties.store(outputStream, "This file has been written by Jahia.");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeTheFile(String propertiesFilePath, List<String> bufferList) {
        try (FileWriter fileWriter = new FileWriter(new File(propertiesFilePath));){
            StringBuilder outputBuffer = new StringBuilder();
            for (int i = 0; i < bufferList.size(); ++i) {
                outputBuffer.append(bufferList.get(i));
                outputBuffer.append("\n");
            }
            fileWriter.write(outputBuffer.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Properties getPropertiesObject() {
        return this.properties;
    }

    public static String string2Property(String originalValue) {
        StringBuilder convertedValue = new StringBuilder();
        for (int i = 0; i < originalValue.length(); ++i) {
            if (originalValue.substring(i, i + 1).equals(":")) {
                convertedValue.append("\\:");
                continue;
            }
            if (originalValue.substring(i, i + 1).equals("\\")) {
                convertedValue.append("\\\\");
                continue;
            }
            convertedValue.append(originalValue.substring(i, i + 1));
        }
        return convertedValue.toString();
    }
}

