/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.security;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.jaas.JahiaPrincipal;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheHelper;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.utils.security.PathWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger(AccessManagerUtils.class);
    private static final Map<String, Map<String, String>> PRIVILEGE_NAMES = new ConcurrentHashMap<String, Map<String, String>>(2);
    private static volatile Cache<String, Set<Privilege>> privilegesInRole = null;
    private static volatile Cache<String, Boolean> matchingPermissions = null;
    public static ThreadLocal<Collection<String>> deniedPathes = new ThreadLocal();
    private static final Pattern REFERENCE_FIELD_LANGUAGE_PATTERN = Pattern.compile("(.*)j:referenceInField_.*_([a-z]{2,3}(_[A-Z]{2})?)_[0-9]+([/].*)?$");
    private static final Pattern TRANSLATION_LANGUAGE_PATTERN = Pattern.compile("(.*)j:translation_([a-z]{2,3}(_[A-Z]{2})?)([/].*)?$");

    public static void initCaches() {
        if (privilegesInRole == null) {
            privilegesInRole = AccessManagerUtils.initCache("org.jahia.security.privilegesInRolesCache");
        }
        if (matchingPermissions == null) {
            matchingPermissions = AccessManagerUtils.initCache("org.jahia.security.matchingPermissions");
        }
    }

    public static void flushPrivilegesInRoles() {
        if (privilegesInRole != null) {
            privilegesInRole.flush();
        }
        if (matchingPermissions != null) {
            matchingPermissions.flush();
            CacheHelper.sendCacheFlushCommandToCluster("FLUSH_MATCHINGPERMISSIONS");
        }
    }

    public static void flushMatchingPermissions() {
        if (matchingPermissions != null) {
            matchingPermissions.flush();
        }
    }

    public static String getPrivilegeName(String privilegeName, String workspace) {
        Object name;
        if (workspace == null) {
            return privilegeName;
        }
        Map<String, String> wsp = PRIVILEGE_NAMES.get(workspace);
        if (wsp == null) {
            wsp = new ConcurrentHashMap<String, String>();
            PRIVILEGE_NAMES.put(workspace, wsp);
        }
        if ((name = wsp.get(privilegeName)) == null) {
            name = privilegeName + "_" + workspace;
            wsp.put(privilegeName, (String)name);
        }
        return name;
    }

    public static void setDeniedPaths(Collection<String> denied) {
        deniedPathes.set(denied);
    }

    public static boolean isSystemPrincipal(JahiaPrincipal jahiaPrincipal) {
        return jahiaPrincipal != null && jahiaPrincipal.isSystem();
    }

    public static boolean isGranted(PathWrapper pathWrapper, Set<String> permissions, Session securitySession, JahiaPrincipal jahiaPrincipal, String workspaceName, boolean isAliased, Map<String, Boolean> pathPermissionCache, Map<Object, CompiledAcl> compiledAcls, JahiaPrivilegeRegistry privilegeRegistry) throws RepositoryException {
        if (AccessManagerUtils.isSystemPrincipal(jahiaPrincipal) && deniedPathes.get() == null) {
            return true;
        }
        if (permissions.size() == 1 && pathWrapper.isRoot() && permissions.contains(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}read", workspaceName))) {
            return true;
        }
        boolean res = false;
        String jcrPath = pathWrapper.getPathStr();
        String cacheKey = jcrPath + " : " + String.valueOf(permissions);
        Boolean result = AccessManagerUtils.pathPermissionCacheGet(cacheKey, isAliased, pathPermissionCache);
        if (result != null) {
            return result;
        }
        try {
            String nodeName;
            Node n;
            PropertyIterator pi;
            if (deniedPathes.get() != null && deniedPathes.get().contains(jcrPath)) {
                AccessManagerUtils.pathPermissionCachePut(cacheKey, false, isAliased, pathPermissionCache);
                return false;
            }
            if (AccessManagerUtils.isSystemPrincipal(jahiaPrincipal)) {
                AccessManagerUtils.pathPermissionCachePut(cacheKey, true, isAliased, pathPermissionCache);
                return true;
            }
            Item i = null;
            Boolean itemExists = null;
            if ((permissions.contains(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}write", workspaceName)) || permissions.contains(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", workspaceName)) || permissions.contains(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}removeNode", workspaceName))) && (itemExists = Boolean.valueOf(pathWrapper.itemExist())).booleanValue() && (i = pathWrapper.getItem()).isNode() && ((Node)i).isNodeType("jmix:systemNode")) {
                AccessManagerUtils.pathPermissionCachePut(cacheKey, false, isAliased, pathPermissionCache);
                return false;
            }
            if (jahiaPrincipal != null && AccessManagerUtils.isAdmin(null, jahiaPrincipal)) {
                AccessManagerUtils.pathPermissionCachePut(cacheKey, true, isAliased, pathPermissionCache);
                return true;
            }
            if (itemExists == null) {
                itemExists = pathWrapper.itemExist();
            }
            if (!itemExists.booleanValue()) {
                AccessManagerUtils.pathPermissionCachePut(cacheKey, true, isAliased, pathPermissionCache);
                return true;
            }
            if (i == null) {
                i = pathWrapper.getItem();
            }
            if (i instanceof Version) {
                i = ((Version)i).getContainingHistory();
            }
            PathWrapper nodePathWrapper = pathWrapper;
            if (i instanceof VersionHistory && (pi = ((VersionHistory)i).getReferences()).hasNext()) {
                Property p = pi.nextProperty();
                i = p.getParent();
                nodePathWrapper = pathWrapper.getNewPathWrapper(i.getPath());
            }
            if (i.isNode()) {
                n = (Node)i;
            } else {
                n = i.getParent();
                nodePathWrapper = nodePathWrapper.getAncestor();
            }
            String string = jcrPath = !nodePathWrapper.equals(pathWrapper) ? nodePathWrapper.getPathStr() : jcrPath;
            if (permissions.contains(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", workspaceName))) {
                String language;
                Matcher matcher;
                if (jcrPath.contains("j:translation_")) {
                    matcher = TRANSLATION_LANGUAGE_PATTERN.matcher(jcrPath);
                    if (matcher.matches()) {
                        language = matcher.group(2);
                        permissions.remove(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", workspaceName));
                        permissions.add(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", workspaceName) + "_" + language);
                    }
                } else if (jcrPath.contains("j:referenceInField_") && (matcher = REFERENCE_FIELD_LANGUAGE_PATTERN.matcher(jcrPath)).matches()) {
                    language = matcher.group(2);
                    permissions.remove(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", workspaceName));
                    permissions.add(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", workspaceName) + "_" + language);
                }
            }
            if (permissions.contains(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}addChildNodes", workspaceName)) && ((nodeName = pathWrapper.getNodeName()).startsWith("j:translation_") || nodeName.startsWith("j:referenceInField_")) && AccessManagerUtils.isGranted(nodePathWrapper, Collections.singleton(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", workspaceName)), securitySession, jahiaPrincipal, workspaceName, isAliased, pathPermissionCache, compiledAcls, privilegeRegistry)) {
                return true;
            }
            String ntName = n.getPrimaryNodeType().getName();
            if (ntName.equals("jnt:acl") || ntName.equals("jnt:ace")) {
                if (permissions.contains(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}read", workspaceName))) {
                    permissions.add(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}readAccessControl", workspaceName));
                }
                if (permissions.contains(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", workspaceName))) {
                    permissions.add(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyAccessControl", workspaceName));
                }
            }
            String site = AccessManagerUtils.resolveSite(jcrPath);
            res = AccessManagerUtils.recurseOnACPs(nodePathWrapper, securitySession, permissions, site, compiledAcls, jahiaPrincipal, isAliased, privilegeRegistry, workspaceName);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        AccessManagerUtils.pathPermissionCachePut(cacheKey, res, isAliased, pathPermissionCache);
        return res;
    }

    public static Set<Privilege> getPermissionsInRole(String role, JahiaPrivilegeRegistry privilegeRegistry) throws RepositoryException {
        Set<Privilege> permsInRole = null;
        if (privilegesInRole == null) {
            privilegesInRole = AccessManagerUtils.initCache("org.jahia.security.privilegesInRolesCache");
        } else {
            permsInRole = privilegesInRole.get(role);
        }
        if (permsInRole == null) {
            permsInRole = AccessManagerUtils.internalGetPermissionsInRole(role, privilegeRegistry);
            privilegesInRole.put(role, permsInRole);
        }
        return permsInRole;
    }

    public static boolean matchPermission(Set<String> permissions, String role, boolean isAliased, JahiaPrivilegeRegistry privilegeRegistry, String workspaceName) throws RepositoryException {
        int permissionsSize = permissions.size();
        StringBuilder stringBuilder = new StringBuilder(role);
        for (String permission : permissions) {
            stringBuilder.append(permission);
        }
        String entryKey = stringBuilder.toString();
        Boolean cachedValue = AccessManagerUtils.matchingPermissionsGet(entryKey, isAliased);
        if (cachedValue == null) {
            Set<Privilege> permsInRole = AccessManagerUtils.getPermissionsInRole(role, privilegeRegistry);
            logger.debug("Checking role {}", (Object)role);
            for (Privilege privilege : permsInRole) {
                String privilegeName = privilege.getName();
                if (AccessManagerUtils.checkPrivilege(permissions, privilegeName, entryKey, isAliased, workspaceName)) {
                    return true;
                }
                for (Privilege sub : privilege.getAggregatePrivileges()) {
                    if (!AccessManagerUtils.checkPrivilege(permissions, sub.getName(), entryKey, isAliased, workspaceName)) continue;
                    return true;
                }
            }
            if (permissionsSize == permissions.size()) {
                AccessManagerUtils.matchingPermissionsPut(entryKey, Boolean.FALSE, isAliased);
            }
            return false;
        }
        if (cachedValue.booleanValue()) {
            permissions.clear();
            return true;
        }
        return false;
    }

    public static Privilege[] getPrivileges(String absPath, String workspace, JahiaPrincipal jahiaPrincipal, JahiaPrivilegeRegistry privilegeRegistry) throws PathNotFoundException, RepositoryException {
        JCRNodeWrapper node = JCRSessionFactory.getInstance().getCurrentSystemSession(workspace, null, null).getNode(absPath);
        return AccessManagerUtils.getPrivileges((Node)node, jahiaPrincipal, privilegeRegistry);
    }

    public static Privilege[] getPrivileges(Node node, JahiaPrincipal jahiaPrincipal, JahiaPrivilegeRegistry privilegeRegistry) throws PathNotFoundException, RepositoryException {
        Set<String> grantedRoles = AccessManagerUtils.getRoles(node, jahiaPrincipal);
        HashSet<Privilege> results = new HashSet<Privilege>();
        for (String role : grantedRoles) {
            Set<Privilege> permissionsInRole = AccessManagerUtils.getPermissionsInRole(role, privilegeRegistry);
            if (!permissionsInRole.isEmpty()) {
                results.addAll(permissionsInRole);
                continue;
            }
            logger.debug("No permissions found for role '{}' on path '{}' (or parent)", (Object)role, (Object)node.getPath());
        }
        return results.toArray(new Privilege[results.size()]);
    }

    public static boolean isAdmin(String siteKey, JahiaPrincipal jahiaPrincipal) {
        if (jahiaPrincipal.getAdmin() == null) {
            jahiaPrincipal.setAdmin(Boolean.valueOf(!" guest ".equals(jahiaPrincipal.getName()) && ServicesRegistry.getInstance().getJahiaGroupManagerService().isAdminMember(jahiaPrincipal.getName(), jahiaPrincipal.getRealm(), siteKey)));
        }
        return jahiaPrincipal.getAdmin();
    }

    public static Set<String> getRoles(String absPath, String workspace, JahiaPrincipal jahiaPrincipal) throws PathNotFoundException, RepositoryException {
        JCRNodeWrapper node = JCRSessionFactory.getInstance().getCurrentSystemSession(workspace, null, null).getNode(absPath);
        return AccessManagerUtils.getRoles(node, jahiaPrincipal);
    }

    public static Set<String> getRoles(Node node, JahiaPrincipal jahiaPrincipal) throws PathNotFoundException, RepositoryException {
        String site = AccessManagerUtils.resolveSite(node.getPath());
        if (node instanceof JCRNodeWrapper) {
            return AccessManagerUtils.getOptimizedRoles((JCRNodeWrapper)node, jahiaPrincipal, site);
        }
        HashSet<String> grantedRoles = new HashSet<String>();
        HashSet<CallSite> foundRoles = new HashSet<CallSite>();
        try {
            while (true) {
                if (node.hasNode("j:acl")) {
                    Node acl = node.getNode("j:acl");
                    NodeIterator aces = acl.getNodes();
                    while (aces.hasNext()) {
                        Value[] roles;
                        String principal;
                        Node ace = aces.nextNode();
                        if (!ace.isNodeType("jnt:ace") || !AccessManagerUtils.matchUser(principal = ace.getProperty("j:principal").getString(), site, jahiaPrincipal)) continue;
                        boolean granted = ace.getProperty("j:aceType").getString().equals("GRANT");
                        Object roleSuffix = "";
                        if (ace.isNodeType("jnt:externalAce")) {
                            roleSuffix = "/" + ace.getProperty("j:externalPermissionsName").getString();
                        }
                        for (Value r : roles = ace.getProperty("j:roles").getValues()) {
                            String role = r.getString();
                            String key = principal + ":" + role + (String)roleSuffix;
                            if (foundRoles.contains(key)) continue;
                            if (granted) {
                                grantedRoles.add(role + (String)roleSuffix);
                            }
                            foundRoles.add((CallSite)((Object)key));
                        }
                    }
                    if (acl.hasProperty("j:inherit") && !acl.getProperty("j:inherit").getBoolean()) {
                        return grantedRoles;
                    }
                }
                if (!node.getPath().equals("/")) {
                    node = node.getParent();
                    continue;
                }
                break;
            }
        }
        catch (ItemNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return grantedRoles;
    }

    private static Set<String> getOptimizedRoles(JCRNodeWrapper node, JahiaPrincipal jahiaPrincipal, String site) {
        HashSet<String> grantedRoles = new HashSet<String>();
        HashSet<CallSite> foundRoles = new HashSet<CallSite>();
        Map<String, List<String[]>> acl = node.getAclEntries();
        for (Map.Entry<String, List<String[]>> entry : acl.entrySet()) {
            String principal = entry.getKey();
            if (!AccessManagerUtils.matchUser(principal, site, jahiaPrincipal)) continue;
            for (String[] ace : entry.getValue()) {
                boolean granted;
                boolean bl = granted = !ace[1].equals("DENY");
                String role = ace[2];
                String key = principal + ":" + role;
                if (foundRoles.contains(key)) continue;
                if (granted) {
                    grantedRoles.add(role);
                }
                foundRoles.add((CallSite)((Object)key));
            }
        }
        return grantedRoles;
    }

    private static String resolveSite(String jcrPath) {
        String site = jcrPath.startsWith("/sites/") ? StringUtils.substringBefore((String)jcrPath.substring("/sites".length() + 1), (String)"/") : "systemsite";
        return site;
    }

    private static boolean recurseOnACPs(PathWrapper pathWrapper, Session s, Set<String> permissions, String site, Map<Object, CompiledAcl> compiledAcls, JahiaPrincipal jahiaPrincipal, boolean isAliased, JahiaPrivilegeRegistry privilegeRegistry, String workspaceName) throws RepositoryException {
        HashSet<CallSite> foundRoles = new HashSet<CallSite>();
        permissions = new HashSet<String>(permissions);
        while (pathWrapper.getLength() > 0) {
            CompiledAcl acl = compiledAcls.get(pathWrapper.getInnerObject());
            if (acl == null) {
                Node node;
                acl = new CompiledAcl();
                compiledAcls.put(pathWrapper.getInnerObject(), acl);
                Item i = pathWrapper.getItem();
                if (i.isNode() && (node = (Node)i).hasNode("j:acl")) {
                    Node aclNode = node.getNode("j:acl");
                    NodeIterator aces = aclNode.getNodes();
                    while (aces.hasNext()) {
                        Node aceNode = aces.nextNode();
                        try {
                            String role;
                            Value[] roleValues;
                            String principal = aceNode.getProperty("j:principal").getString();
                            if (!AccessManagerUtils.matchUser(principal, site, jahiaPrincipal)) continue;
                            CompiledAce ace = new CompiledAce();
                            acl.aces.add(ace);
                            ace.principal = principal;
                            boolean bl = ace.granted = !aceNode.getProperty("j:aceType").getString().equals("DENY");
                            if (aceNode.isNodeType("jnt:externalAce")) {
                                for (Value role1 : roleValues = aceNode.getProperty("j:roles").getValues()) {
                                    role = role1.getString();
                                    ace.roles.add(role + "/" + aceNode.getProperty("j:externalPermissionsName").getString());
                                }
                                continue;
                            }
                            for (Value role1 : roleValues = aceNode.getProperty("j:roles").getValues()) {
                                role = role1.getString();
                                ace.roles.add(role);
                            }
                        }
                        catch (RepositoryException e) {
                            logger.error("Can't read ACE " + aceNode.getPath(), (Throwable)e);
                        }
                    }
                    acl.broken = aclNode.hasProperty("j:inherit") && !aclNode.getProperty("j:inherit").getBoolean();
                }
            }
            for (CompiledAce perm : acl.aces) {
                for (String role : perm.roles) {
                    String key = perm.principal + ":" + role;
                    if (foundRoles.contains(key)) continue;
                    foundRoles.add((CallSite)((Object)key));
                    if (!perm.granted || !AccessManagerUtils.matchPermission(permissions, role, isAliased, privilegeRegistry, workspaceName)) continue;
                    return true;
                }
            }
            if (acl.broken) {
                return false;
            }
            if (pathWrapper.isRoot()) {
                return false;
            }
            pathWrapper = pathWrapper.getAncestor();
        }
        return false;
    }

    private static Set<Privilege> internalGetPermissionsInRole(String role, JahiaPrivilegeRegistry privilegeRegistry) throws RepositoryException {
        Node roleNode;
        String externalPermission = null;
        String roleName = role;
        if (roleName.contains("/")) {
            externalPermission = StringUtils.substringAfter((String)role, (String)"/");
            roleName = StringUtils.substringBefore((String)role, (String)"/");
        }
        Set<Privilege> privileges = (roleNode = AccessManagerUtils.findRoleNode(roleName)) != null ? AccessManagerUtils.getPrivileges(roleNode, externalPermission, privilegeRegistry) : Collections.emptySet();
        return privileges;
    }

    private static Node findRoleNode(String role) throws RepositoryException {
        try {
            JCRNodeIteratorWrapper nodes = JCRSessionFactory.getInstance().getCurrentSystemSession("default", null, null).getWorkspace().getQueryManager().createQuery("select * from [jnt:role] as r where localname()='" + JCRContentUtils.sqlEncode(role) + "' and isdescendantnode(r,['/roles'])", "JCR-SQL2").execute().getNodes();
            if (nodes.hasNext()) {
                return nodes.nextNode();
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static Set<Privilege> getPrivileges(Node roleNode, String externalPermission, JahiaPrivilegeRegistry privilegeRegistry) throws RepositoryException {
        HashSet<Privilege> privileges;
        block17: {
            Value[] perms;
            Session s;
            block16: {
                Value[] perms2;
                privileges = new HashSet();
                Node roleParent = roleNode.getParent();
                if (roleParent.isNodeType("jnt:role")) {
                    privileges = AccessManagerUtils.getPrivileges(roleParent, externalPermission, privilegeRegistry);
                }
                if (externalPermission != null) {
                    if (roleNode.hasNode(externalPermission)) {
                        roleNode = roleNode.getNode(externalPermission);
                    } else {
                        return privileges;
                    }
                }
                s = roleNode.getSession();
                if (!roleNode.hasProperty("j:permissionNames")) break block16;
                for (Value value : perms2 = roleNode.getProperty("j:permissionNames").getValues()) {
                    try {
                        try {
                            Privilege privilege = privilegeRegistry.getPrivilege(value.getString(), null);
                            privileges.add(privilege);
                        }
                        catch (AccessControlException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Permission not available : " + value.getString(), (Throwable)e);
                        }
                    }
                    catch (RepositoryException e) {
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
                break block17;
            }
            if (!roleNode.hasProperty("j:permissions")) break block17;
            for (Value value : perms = roleNode.getProperty("j:permissions").getValues()) {
                try {
                    Node p = s.getNodeByIdentifier(value.getString());
                    try {
                        Privilege privilege = privilegeRegistry.getPrivilege(p);
                        privileges.add(privilege);
                    }
                    catch (AccessControlException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Permission not available : " + String.valueOf(p), (Throwable)e);
                    }
                }
                catch (RepositoryException repositoryException) {
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        return privileges;
    }

    private static boolean checkPrivilege(Set<String> permissions, String name, String cacheEntryKey, boolean isAliased, String workspaceName) {
        if (!(isAliased && name.contains("_default") || !AccessManagerUtils.checkPrivilege(permissions, name))) {
            AccessManagerUtils.matchingPermissionsPut(cacheEntryKey, Boolean.TRUE, isAliased);
            return true;
        }
        return isAliased && name.contains("_live") && AccessManagerUtils.checkPrivilege(permissions, name.replaceAll("_live", "_" + workspaceName));
    }

    private static boolean checkPrivilege(Set<String> permissions, String privilegeName) {
        if (permissions.contains(privilegeName)) {
            logger.debug("Found privilege {}", (Object)privilegeName);
            permissions.remove(privilegeName);
            if (permissions.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private static boolean matchUser(String principal, String site, JahiaPrincipal jahiaPrincipal) {
        String principalName = principal.substring(2);
        return principal.charAt(0) == 'u' ? jahiaPrincipal.isGuest() && principalName.equals("guest") || principalName.equals(jahiaPrincipal.getName()) && (jahiaPrincipal.getRealm() == null || jahiaPrincipal.getRealm().equals(site)) : principal.charAt(0) == 'g' && AccessManagerUtils.isUserMemberOf(principalName, site, jahiaPrincipal);
    }

    private static boolean isUserMemberOf(String groupname, String site, JahiaPrincipal jahiaPrincipal) {
        return "guest".equals(groupname) || !jahiaPrincipal.isGuest() && "users".equals(groupname) || !jahiaPrincipal.isGuest() && "site-users".equals(groupname) && (jahiaPrincipal.getRealm() == null || jahiaPrincipal.getRealm().equals(site)) || !jahiaPrincipal.isGuest() && (ServicesRegistry.getInstance().getJahiaGroupManagerService().isMember(jahiaPrincipal.getName(), jahiaPrincipal.getRealm(), groupname, site) || ServicesRegistry.getInstance().getJahiaGroupManagerService().isMember(jahiaPrincipal.getName(), jahiaPrincipal.getRealm(), groupname, null));
    }

    private static Boolean matchingPermissionsGet(String key, boolean isAliased) {
        return isAliased ? null : matchingPermissions.get(key);
    }

    private static void matchingPermissionsPut(String key, Boolean value, boolean isAliased) {
        if (!isAliased) {
            matchingPermissions.put(key, value);
        }
    }

    private static Boolean pathPermissionCacheGet(String key, boolean isAliased, Map<String, Boolean> pathPermissionCache) {
        return isAliased ? null : pathPermissionCache.get(key);
    }

    private static void pathPermissionCachePut(String key, Boolean value, boolean isAliased, Map<String, Boolean> pathPermissionCache) {
        if (!isAliased) {
            pathPermissionCache.put(key, value);
        }
    }

    private static <K, V> Cache<K, V> initCache(String name) {
        CacheService cacheService = ServicesRegistry.getInstance().getCacheService();
        if (cacheService != null) {
            try {
                return cacheService.getCache(name, true);
            }
            catch (JahiaInitializationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static class CompiledAce {
        String principal;
        Set<String> roles = new HashSet<String>();
        boolean granted;
    }

    public static class CompiledAcl {
        boolean broken = false;
        Set<CompiledAce> aces = new HashSet<CompiledAce>();
    }
}

