/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.zip;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class FilteredDirectoryWalker
extends DirectoryWalker {
    private static final String[] EMPTY_ARRAY = new String[0];
    private File startDirectory;

    private static String[] convertPatterns(File baseDir, String[] pathPatterns) {
        String[] convertedPatterns = new String[pathPatterns.length];
        for (int i = 0; i < pathPatterns.length; ++i) {
            convertedPatterns[i] = new File(baseDir, FilteredDirectoryWalker.convertSeparator(pathPatterns[i])).getPath();
        }
        return convertedPatterns;
    }

    private static String convertSeparator(String pathPattern) {
        return File.separatorChar != '/' ? pathPattern.replace('/', File.separatorChar) : pathPattern;
    }

    public FilteredDirectoryWalker(File startDirectory) {
        this(startDirectory, null, null);
    }

    public FilteredDirectoryWalker(File startDirectory, String[] includePathPatterns, String[] excludePathPatterns) {
        super((FileFilter)new PathFilter(FilteredDirectoryWalker.convertPatterns(startDirectory, includePathPatterns != null ? includePathPatterns : EMPTY_ARRAY), FilteredDirectoryWalker.convertPatterns(startDirectory, excludePathPatterns != null ? excludePathPatterns : EMPTY_ARRAY)), -1);
        this.startDirectory = startDirectory;
    }

    protected void handleFile(File file, int depth, Collection results) throws IOException {
        results.add(file);
    }

    public void zip(ZipOutputStream zout) throws IOException {
        LinkedList results = new LinkedList();
        this.walk(this.startDirectory, results);
        for (File file : results) {
            if (file.getPath().length() <= this.startDirectory.getPath().length()) continue;
            if (zout != null) {
                zout.putNextEntry(new ZipEntry(file.getPath().substring(this.startDirectory.getPath().length() + 1)));
                zout.write(FileUtils.readFileToByteArray((File)file));
                continue;
            }
            System.out.println(file);
        }
    }

    private static class PathFilter
    implements FileFilter {
        private String[] includeWildcards;
        private String[] excludeWildcards;

        public PathFilter(String[] includeWildcards, String[] excludeWildcards) {
            this.includeWildcards = includeWildcards;
            this.excludeWildcards = excludeWildcards;
        }

        private static boolean matches(String path, String wildcard) {
            return FilenameUtils.wildcardMatch((String)path, (String)wildcard, (IOCase)IOCase.SENSITIVE);
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            boolean accept = false;
            String path = file.getPath();
            if (this.includeWildcards.length > 0) {
                for (String wildcard : this.includeWildcards) {
                    if (!PathFilter.matches(path, wildcard)) continue;
                    accept = true;
                    break;
                }
            } else {
                accept = true;
            }
            if (accept && this.excludeWildcards.length > 0) {
                for (String wildcard : this.excludeWildcards) {
                    if (!PathFilter.matches(path, wildcard)) continue;
                    accept = false;
                    break;
                }
            }
            return accept;
        }
    }
}

