/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaArchiveFileException;
import org.jahia.exceptions.JahiaException;
import org.jahia.utils.zip.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaArchiveFileHandler {
    private static Logger logger = LoggerFactory.getLogger(JahiaArchiveFileHandler.class);
    private static final String CLASS_NAME = JahiaArchiveFileHandler.class.getName();
    private String filePath;
    private JarFile jarFile;
    private String basePath;

    public JahiaArchiveFileHandler(String path) throws IOException {
        this.filePath = path;
        File f = new File(path);
        try {
            this.jarFile = new JarFile(f);
        }
        catch (IOException ioe) {
            logger.error("IOException occurred " + f.getAbsolutePath(), (Throwable)ioe);
            throw new IOException(CLASS_NAME + " IOException occurred ");
        }
        catch (NullPointerException e) {
            logger.error("NullPointerException " + f.getAbsolutePath(), (Throwable)e);
            throw new IOException(CLASS_NAME + " NullPointerException occurred ");
        }
    }

    public JahiaArchiveFileHandler(String path, String basePath) throws IOException {
        this(path);
        this.basePath = basePath;
    }

    public void unzip() throws JahiaException {
        try {
            File f = new File(this.filePath);
            String parentPath = f.getParent() + File.separator;
            try (FileInputStream fis = new FileInputStream(this.filePath);
                 BufferedInputStream bis = new BufferedInputStream(fis);
                 ZipInputStream zis = new ZipInputStream(bis);
                 ZipFile zf = new ZipFile(this.filePath);){
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    String zeName = ze.getName();
                    String path = parentPath + this.genPathFile(zeName);
                    File fo = new File(path);
                    if (ze.isDirectory()) {
                        fo.mkdirs();
                    } else {
                        this.copyStream(zis, new FileOutputStream(fo));
                    }
                    zis.closeEntry();
                }
            }
        }
        catch (IOException ioe) {
            throw new JahiaException("JahiaArchiveFileHandler", "fail processing unzip", 12, 2, ioe);
        }
    }

    public Map<String, String> unzip(String path) throws JahiaException {
        return this.unzip(path, true);
    }

    public Map<String, String> unzip(String path, PathFilter pathFilter) throws JahiaException {
        return this.unzip(path, true, pathFilter, null);
    }

    public Map<String, String> unzip(String path, boolean overwrite) throws JahiaException {
        return this.unzip(path, overwrite, PathFilter.ALL, null);
    }

    public Map<String, String> unzip(String path, boolean overwrite, PathFilter pathFilter, String pathPrefix) throws JahiaException {
        TreeMap<String, String> unzippedFiles = new TreeMap<String, String>();
        HashMap<File, Long> timestamps = new HashMap<File, Long>();
        pathFilter = pathFilter != null ? pathFilter : PathFilter.ALL;
        try (FileInputStream fis = new FileInputStream(this.filePath);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zis = new ZipInputStream(bis);
             ZipFile zf = new ZipFile(this.filePath);){
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                String zeName = ze.getName();
                String entryFilePath = this.genPathFile(zeName);
                String destPath = path + File.separator + entryFilePath;
                File fo = new File(destPath);
                if (pathFilter.accept((String)(pathPrefix != null ? pathPrefix + "/" + zeName : zeName))) {
                    String loggedPath = fo.getAbsolutePath();
                    if (this.basePath != null) {
                        loggedPath = StringUtils.substringAfter((String)loggedPath, (String)this.basePath);
                    }
                    unzippedFiles.put(entryFilePath, loggedPath);
                    long lastModified = ze.getTime();
                    if (lastModified > 0L) {
                        timestamps.put(fo, lastModified);
                    }
                    if (ze.isDirectory()) {
                        fo.mkdirs();
                    } else if (overwrite || !fo.exists()) {
                        File parent = new File(fo.getParent());
                        parent.mkdirs();
                        FileOutputStream fos = new FileOutputStream(fo);
                        this.copyStream(zis, fos);
                    }
                }
                zis.closeEntry();
            }
        }
        catch (IOException ioe) {
            throw new JahiaException(CLASS_NAME, "faile processing unzip", 12, 2, ioe);
        }
        for (Map.Entry tst : timestamps.entrySet()) {
            try {
                if (((File)tst.getKey()).setLastModified((Long)tst.getValue())) continue;
                logger.warn("Unable to set last mofified date for file {}.", tst.getKey());
            }
            catch (Exception e) {
                logger.warn("Unable to set last mofified date for file {}. Cause: {}", tst.getKey(), (Object)e.getMessage());
            }
        }
        return unzippedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File extractFile(String entryName) throws IOException, JahiaArchiveFileException {
        File tmpFile = null;
        ZipEntry entry = this.jarFile.getEntry(entryName);
        if (entry != null && !entry.isDirectory()) {
            InputStream ins = this.jarFile.getInputStream(entry);
            if (ins != null) {
                tmpFile = File.createTempFile("jahia_temp", ".jar", null);
                if (tmpFile == null || !tmpFile.canWrite()) {
                    throw new IOException("extractFile error creating temporary file");
                }
                try (FileOutputStream outs = new FileOutputStream(tmpFile);){
                    this.copyStream(ins, outs);
                    outs.flush();
                }
            }
        } else {
            throw new JahiaArchiveFileException(entryName + " is null or a directory ", 30);
        }
        return tmpFile;
    }

    public String extractContent(String entryName) throws IOException, JahiaArchiveFileException {
        if (!this.entryExists(entryName)) {
            throw new JahiaArchiveFileException(entryName + " is not found", 30);
        }
        ZipEntry entry = this.jarFile.getEntry(entryName);
        StringWriter out = new StringWriter();
        IOUtils.copy((InputStream)this.jarFile.getInputStream(entry), (Writer)out);
        return out.getBuffer().toString();
    }

    public void extractEntry(String entryName, String destPath) throws JahiaException {
        try {
            ZipEntry entry = this.jarFile.getEntry(entryName);
            if (entry == null) {
                StringBuilder strBuf = new StringBuilder(1024);
                strBuf.append(" extractEntry(), cannot find entry ");
                strBuf.append(entryName);
                strBuf.append(" in the jar file ");
                throw new JahiaException(CLASS_NAME, strBuf.toString(), 12, 2);
            }
            File destDir = new File(destPath);
            if (!destDir.isDirectory() || !destDir.canWrite()) {
                throw new JahiaException(CLASS_NAME, " cannot access to the destination dir ", 12, 2);
            }
            try (FileInputStream fis = new FileInputStream(this.filePath);
                 BufferedInputStream bis = new BufferedInputStream(fis);
                 ZipInputStream zis = new ZipInputStream(bis);
                 ZipFile zf = new ZipFile(this.filePath);){
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null && !ze.getName().equalsIgnoreCase(entryName)) {
                    zis.closeEntry();
                }
                if (ze != null) {
                    if (ze.isDirectory()) {
                        while (ze != null) {
                            String zeName = ze.getName();
                            String path = destPath + File.separator + this.genPathFile(zeName);
                            File fo = new File(path);
                            if (ze.isDirectory()) {
                                fo.mkdirs();
                            } else {
                                FileOutputStream outs = new FileOutputStream(fo);
                                this.copyStream(zis, outs);
                            }
                            zis.closeEntry();
                            ze = zis.getNextEntry();
                        }
                    } else {
                        String zeName = ze.getName();
                        String path = destPath + File.separator + this.genPathFile(zeName);
                        File fo = new File(path);
                        FileOutputStream outs = new FileOutputStream(fo);
                        this.copyStream(zis, outs);
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new JahiaException(CLASS_NAME, "faile processing unzip", 12, 2, ioe);
        }
    }

    public ZipEntry getEntry(String entryName) {
        return this.jarFile.getEntry(entryName);
    }

    public boolean isDirectory(String entryName) {
        return this.jarFile.getEntry(entryName) != null && this.jarFile.getEntry(entryName).isDirectory();
    }

    public boolean entryExists(String entryName) {
        return this.jarFile.getEntry(entryName) != null;
    }

    public void closeArchiveFile() {
        try {
            this.jarFile.close();
        }
        catch (IOException e) {
            logger.error("cannot close jar file", (Throwable)e);
        }
    }

    protected String genPathFile(String entryName) {
        StringBuilder sb = new StringBuilder(entryName.length());
        for (int i = 0; i < entryName.length(); ++i) {
            if (entryName.charAt(i) == '/') {
                sb.append(File.separator);
                continue;
            }
            sb.append(entryName.charAt(i));
        }
        return sb.toString();
    }

    protected void copyStream(InputStream ins, OutputStream outs) throws IOException {
        int bufferRead;
        int bufferSize = 1024;
        byte[] writeBuffer = new byte[bufferSize];
        BufferedOutputStream bos = new BufferedOutputStream(outs, bufferSize);
        while ((bufferRead = ins.read(writeBuffer)) != -1) {
            bos.write(writeBuffer, 0, bufferRead);
        }
        bos.flush();
        bos.close();
        outs.flush();
        outs.close();
    }

    public String getPath() {
        return this.jarFile.getName();
    }
}

