/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.buildautomation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.configurators.JahiaGlobalConfigurator;
import org.jahia.configuration.logging.AbstractLogger;
import org.jahia.utils.maven.plugin.AbstractManagementMojo;
import org.jahia.utils.maven.plugin.MojoLogger;

public class ConfigureMojo
extends AbstractManagementMojo
implements JahiaConfigInterface {
    protected String jahiaModulesDiskPath;
    protected String jahiaWebAppsDeployerBaseURL;
    protected String cluster_activated;
    protected String cluster_node_serverId;
    protected String clusterHazelcastBindPort;
    protected String jahiaRootUsername;
    protected String jahiaRootPassword;
    protected String jahiaRootPreferredLang;
    protected String jahiaRootFirstname;
    protected String jahiaRootLastname;
    protected String jahiaRootEmail;
    protected String processingServer;
    protected String jahiaImportsDiskPath;
    protected String clusterTCPBindAddress;
    protected String clusterTCPBindPort;
    protected String databaseType;
    protected String databaseUrl;
    protected String databaseUsername;
    protected String databasePassword;
    protected List<String> siteImportLocation;
    protected String overwritedb;
    protected String deleteFiles;
    protected String storeFilesInDB;
    protected String targetConfigurationDirectory;
    protected String mailServer;
    protected String mailAdministrator;
    protected String mailFrom;
    protected String mailParanoia;
    protected String jahiaToolManagerUsername;
    protected String jahiaToolManagerPassword;
    protected String ldapActivated;
    protected Map<String, String> groupLdapProviderProperties;
    protected Map<String, String> userLdapProviderProperties;
    protected String operatingMode;
    protected boolean externalizedConfigActivated;
    protected boolean externalizedConfigExploded;
    protected String externalizedConfigTargetPath;
    protected String externalizedConfigClassifier;
    protected String externalizedConfigFinalName;
    protected String jeeApplicationLocation;
    protected String jeeApplicationModuleList;
    protected String fileDataStorePath;
    protected Map<String, String> jahiaAdvancedProperties;
    protected Map<String, String> jahiaProperties;
    private String licenseFile;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            new JahiaGlobalConfigurator((AbstractLogger)new MojoLogger(this.getLog()), (JahiaConfigInterface)this).execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while configuring Jahia", e);
        }
    }

    public String getCluster_activated() {
        return this.cluster_activated;
    }

    public String getCluster_node_serverId() {
        return this.cluster_node_serverId;
    }

    public String getClusterHazelcastBindPort() {
        return this.clusterHazelcastBindPort;
    }

    public String getClusterTCPBindAddress() {
        return this.clusterTCPBindAddress;
    }

    public String getClusterTCPBindPort() {
        return this.clusterTCPBindPort;
    }

    public String getDatabasePassword() {
        return StringUtils.defaultString((String)this.databasePassword);
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getDatabaseUsername() {
        return StringUtils.defaultString((String)this.databaseUsername);
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getTargetServerDirectory() {
        return this.targetServerDirectory;
    }

    public String getTargetServerType() {
        return this.targetServerType;
    }

    public String getTargetServerVersion() {
        return this.targetServerVersion;
    }

    public String getWebAppDirName() {
        return this.webAppDirName;
    }

    public String getJahiaImportsDiskPath() {
        return this.jahiaImportsDiskPath;
    }

    public String getJahiaWebAppsDeployerBaseURL() {
        return this.jahiaWebAppsDeployerBaseURL;
    }

    public String getJahiaRootPassword() {
        return this.jahiaRootPassword;
    }

    public String getDb_script() {
        return this.getDatabaseType() + ".script";
    }

    public String getOverwritedb() {
        return this.overwritedb;
    }

    public String getDeleteFiles() {
        return this.deleteFiles;
    }

    public String getProcessingServer() {
        return this.processingServer;
    }

    public List<String> getSiteImportLocation() {
        return this.siteImportLocation;
    }

    public String getStoreFilesInDB() {
        return this.storeFilesInDB;
    }

    public String getTargetConfigurationDirectory() {
        return this.targetConfigurationDirectory;
    }

    public void setTargetConfigurationDirectory(String targetConfigurationDirectory) {
        this.targetConfigurationDirectory = targetConfigurationDirectory;
    }

    public String getJahiaRootEmail() {
        return this.jahiaRootEmail;
    }

    public String getJahiaRootFirstname() {
        return this.jahiaRootFirstname;
    }

    public String getJahiaRootLastname() {
        return this.jahiaRootLastname;
    }

    public String getJahiaRootUsername() {
        return this.jahiaRootUsername;
    }

    public String getMailAdministrator() {
        return this.mailAdministrator;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getMailParanoia() {
        return this.mailParanoia;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public String getJahiaModulesDiskPath() {
        return this.jahiaModulesDiskPath;
    }

    public String getJahiaToolManagerUsername() {
        return this.jahiaToolManagerUsername;
    }

    public String getJahiaToolManagerPassword() {
        return this.jahiaToolManagerPassword;
    }

    public String getLdapActivated() {
        return this.ldapActivated;
    }

    public Map<String, String> getGroupLdapProviderProperties() {
        return this.groupLdapProviderProperties;
    }

    public Map<String, String> getUserLdapProviderProperties() {
        return this.userLdapProviderProperties;
    }

    public void setGroupLdapProviderProperties(String groupLdapProviderProperties) {
        if (groupLdapProviderProperties != null) {
            this.groupLdapProviderProperties = JahiaGlobalConfigurator.fromJSON((String)groupLdapProviderProperties);
        }
    }

    public void setUserLdapProviderProperties(String userLdapProviderProperties) {
        if (userLdapProviderProperties != null) {
            this.userLdapProviderProperties = JahiaGlobalConfigurator.fromJSON((String)userLdapProviderProperties);
        }
    }

    public String getOperatingMode() {
        return this.operatingMode;
    }

    public boolean isExternalizedConfigActivated() {
        return this.externalizedConfigActivated;
    }

    public String getExternalizedConfigTargetPath() {
        if (this.externalizedConfigTargetPath == null && this.externalizedConfigActivated) {
            this.initConfigTargetDir();
        }
        return this.externalizedConfigTargetPath;
    }

    private void initConfigTargetDir() {
        String path = null;
        boolean isTomcat = false;
        boolean isJBoss = false;
        if (this.targetServerType != null) {
            if (this.targetServerType.startsWith("jboss")) {
                isJBoss = true;
                path = "${jahiaWebAppRoot}/../../digital-factory-config.jar/";
            } else if (this.targetServerType.startsWith("tomcat")) {
                isTomcat = true;
                path = "${jahiaWebAppRoot}/../../digital-factory-config/";
            }
        }
        if (path == null) {
            throw new IllegalArgumentException("Externalized configuration is activated, but the target directory could not be detected. Please, specify it explicitly.");
        }
        this.externalizedConfigTargetPath = JahiaGlobalConfigurator.resolveDataDir(path, (String)this.getWebappDeploymentDir().getAbsolutePath()).getAbsolutePath();
        this.getLog().info((CharSequence)("Configuration directory path resolved to: " + this.externalizedConfigTargetPath));
        try {
            if (isTomcat) {
                this.adjustCatalinaProperties();
            } else if (isJBoss) {
                FileUtils.touch((File)new File(this.externalizedConfigTargetPath, "../digital-factory-config.jar.dodeploy"));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustCatalinaProperties() throws IOException {
        File catalinaProps = new File(this.targetServerDirectory, "conf/catalina.properties");
        String content = FileUtils.readFileToString((File)catalinaProps);
        if (!content.contains("${catalina.home}/digital-factory-config")) {
            List lines = IOUtils.readLines((Reader)new StringReader(content));
            LinkedList<String> modifiedLines = new LinkedList<String>();
            for (String line : lines) {
                modifiedLines.add(line.startsWith("common.loader") ? ConfigureMojo.addPathToCommonLoader(line) : line);
            }
            FileWriter fileWriter = new FileWriter(catalinaProps);
            try {
                IOUtils.writeLines(modifiedLines, null, (Writer)fileWriter);
                fileWriter.flush();
                this.getLog().info((CharSequence)"Adjusted common.loader value in the catalina.properties to reference digital-factory-config directory");
            }
            finally {
                IOUtils.closeQuietly((Writer)fileWriter);
            }
        }
    }

    private static String addPathToCommonLoader(String line) {
        line = (line = line.trim()).endsWith("\\") ? line.substring(0, line.length() - 2) + ",${catalina.home}/digital-factory-config,\\" : line + ",${catalina.home}/digital-factory-config";
        return line;
    }

    public String getExternalizedConfigClassifier() {
        return this.externalizedConfigClassifier;
    }

    public String getExternalizedConfigFinalName() {
        return this.externalizedConfigFinalName;
    }

    public String getJeeApplicationLocation() {
        return this.jeeApplicationLocation;
    }

    public String getJeeApplicationModuleList() {
        return this.jeeApplicationModuleList;
    }

    public String getFileDataStorePath() {
        return this.fileDataStorePath;
    }

    public Map<String, String> getJahiaAdvancedProperties() {
        return this.jahiaAdvancedProperties;
    }

    public Map<String, String> getJahiaProperties() {
        return this.jahiaProperties;
    }

    public void setJahiaAdvancedProperties(String jahiaAdvancedProperties) {
        if (jahiaAdvancedProperties != null) {
            this.jahiaAdvancedProperties = JahiaGlobalConfigurator.fromJSON((String)jahiaAdvancedProperties);
        }
    }

    public void setJahiaProperties(String jahiaProperties) {
        if (jahiaProperties != null) {
            this.jahiaProperties = JahiaGlobalConfigurator.fromJSON((String)jahiaProperties);
        }
    }

    public String getJahiaRootPreferredLang() {
        return this.jahiaRootPreferredLang;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public boolean isExternalizedConfigExploded() {
        return this.externalizedConfigExploded;
    }
}

