/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.ArticleService;
import org.jahia.utils.maven.plugin.contentgenerator.ContentGeneratorService;
import org.jahia.utils.maven.plugin.contentgenerator.FileService;
import org.jahia.utils.maven.plugin.contentgenerator.OutputService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ContentBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.FolderBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.PageBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.support.RandomUtils;
import org.jdom.Document;

public class ContentService {
    private int nbOftenKeywordsAlreadyAssigned;
    private int nbSeldomKeywordsAlreadyAssigned;
    private Map<String, List<CmisDirectoryPath>> cmisFilePaths;
    private final Random random = new Random();
    private static final List<String> OFTEN_USED_DESCRIPTION_WORDS = Arrays.asList(ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS.split("\\s*,\\s*"));
    private static final List<String> SELDOM_USED_DESCRIPTION_WORDS = Arrays.asList(ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS.split("\\s*,\\s*"));
    private static final Log LOGGER = new SystemStreamLog();

    public ContentService() {
        this.initCmisFilePath();
    }

    public void createTopContents(ExportBO export, List<ArticleBO> articles) throws IOException {
        OutputService os = new OutputService();
        ArticleService articleService = ArticleService.getInstance();
        String rootContentName = export.getSiteType().equals("Headless") ? export.getRootFolderName() : export.getRootPageName();
        LOGGER.info((CharSequence)"Creating top contents");
        HashMap<String, ArticleBO> articlesMap = new HashMap<String, ArticleBO>();
        for (String language : export.getSiteLanguages()) {
            articlesMap.put(language, articleService.getArticle(articles));
        }
        OutputService outService = new OutputService();
        outService.initOutputFile(export.getOutputFile());
        outService.appendStringToFile(export.getOutputFile(), export.toString());
        ArrayList<ContentBO> listeTopContents = new ArrayList<ContentBO>();
        for (int i = 1; i <= export.getNbPagesTopLevel(); ++i) {
            for (String language : export.getSiteLanguages()) {
                articlesMap.put(language, articleService.getArticle(articles));
            }
            ContentBO contentTopLevel = null;
            contentTopLevel = this.createNewContent(export, null, articlesMap, export.getNbSubLevels() + 1, this.createSubContents(export, articles, export.getNbSubLevels(), export.getMaxArticleIndex()));
            outService.appendContentToFile(export.getOutputFile(), contentTopLevel);
            listeTopContents.add(contentTopLevel);
        }
        LOGGER.info((CharSequence)"Contents path are being written to the map file");
        ContentBO rootContent = this.createNewContent(export, rootContentName, articlesMap, export.getNbSubLevels() + 1, listeTopContents);
        List<String> contentsPath = ContentService.getContentsPath(listeTopContents, "/sites/" + export.getSiteKey() + "/" + rootContent.getName());
        outService.appendPathToFile(export.getMapFile(), contentsPath);
        outService.appendStringToFile(export.getOutputFile(), rootContent.getJcrXml());
        Document document = new Document(rootContent.getElement());
        os.writeJdomDocumentToFile(document, export.getOutputFile());
    }

    public List<ContentBO> createSubContents(ExportBO export, List<ArticleBO> articles, Integer level, Integer maxArticleIndex) {
        ArticleService articleService = ArticleService.getInstance();
        ArrayList<ContentBO> listeContents = new ArrayList<ContentBO>();
        int nbFoldersPerLevel = export.getNbPagesPerLevel();
        listeContents.clear();
        if (level > 0) {
            for (int i = 0; i < nbFoldersPerLevel; ++i) {
                HashMap<String, ArticleBO> articlesMap = new HashMap<String, ArticleBO>();
                for (String language : export.getSiteLanguages()) {
                    articlesMap.put(language, articleService.getArticle(articles));
                }
                ContentBO content = this.createNewContent(export, null, articlesMap, level, this.createSubContents(export, articles, level - 1, maxArticleIndex + 1));
                listeContents.add(content);
            }
        }
        return listeContents;
    }

    public ContentBO createNewContent(ExportBO export, String contentName, Map<String, ArticleBO> articlesMap, int level, List<ContentBO> subContents) {
        ++ContentGeneratorService.currentPageIndex;
        String template = "events";
        int indexPagesWithList = export.getNbPagesWithTplList();
        int indexPagesWithQuery = indexPagesWithList + export.getNbPagesWithTplQuery();
        int remainingNbPages = export.getTotalPages() - (export.getNbPagesWithTplList() + export.getNbPagesWithTplQuery());
        int nbPagesWithExternalFileReference = export.isDisableExternalFileReference() ? 0 : Math.round((float)remainingNbPages * 0.25f);
        int indexPagesWithExternalFileReference = indexPagesWithQuery + nbPagesWithExternalFileReference;
        int nbPagesWithInternalFileReference = export.isDisableInternalFileReference() ? 0 : Math.round((float)remainingNbPages * 0.25f);
        int indexPagesWithInternalFileReference = indexPagesWithExternalFileReference + nbPagesWithInternalFileReference;
        if (ContentGeneratorService.currentPageIndex <= indexPagesWithList) {
            template = "qa-list";
        }
        if (ContentGeneratorService.currentPageIndex > indexPagesWithList && ContentGeneratorService.currentPageIndex <= indexPagesWithQuery) {
            template = "qa-query";
        }
        ArrayList<String> externalFilePaths = new ArrayList<String>();
        if (ContentGeneratorService.currentPageIndex > indexPagesWithQuery && ContentGeneratorService.currentPageIndex <= indexPagesWithExternalFileReference) {
            contentName = "qa-external" + ContentGeneratorService.currentPageIndex;
            externalFilePaths.add(this.getRandomCmisFilePath("pictures"));
            externalFilePaths.add(this.getRandomCmisFilePath("text"));
        }
        String fileName = null;
        if (ContentGeneratorService.currentPageIndex > indexPagesWithExternalFileReference && ContentGeneratorService.currentPageIndex <= indexPagesWithInternalFileReference) {
            contentName = "qa-internal" + ContentGeneratorService.currentPageIndex;
            FileService fileService = new FileService();
            fileName = fileService.getFileName(export.getFileNames());
        }
        if (contentName == null) {
            contentName = template + ContentGeneratorService.currentPageIndex;
        }
        LOGGER.debug((CharSequence)("Creating new content level " + level + ": " + contentName));
        HashMap<String, List<String>> acls = new HashMap<String, List<String>>();
        if ((double)this.random.nextFloat() < export.getGroupAclRatio() && export.getNumberOfGroups() > 0) {
            acls.put("g:group" + this.random.nextInt(export.getNumberOfGroups()), Arrays.asList("editor"));
        }
        if ((double)this.random.nextFloat() < export.getUsersAclRatio() && export.getNumberOfUsers() > 0) {
            acls.put("u:user" + this.random.nextInt(export.getNumberOfUsers()), Arrays.asList("editor"));
        }
        Integer idCategory = null;
        float firstThird = export.getTotalPages() / 3;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getNumberOfCategories() > 0) {
            idCategory = this.random.nextInt(export.getNumberOfCategories());
            LOGGER.debug((CharSequence)("Add " + contentName + " to category " + idCategory));
        }
        Integer idTag = null;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getNumberOfTags() > 0) {
            idTag = this.random.nextInt(export.getNumberOfTags());
            LOGGER.debug((CharSequence)("Tag " + contentName + " with tag " + idTag));
        }
        Boolean visibilityOnPage = Boolean.FALSE;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getVisibilityEnabled().booleanValue()) {
            visibilityOnPage = Boolean.TRUE;
            LOGGER.debug((CharSequence)"Visibility enabled");
        }
        String oftenKeywords = this.getOftenKeywords(export.getTotalPages());
        String seldomKeywords = this.getSeldomKeywords(export.getTotalPages());
        String description = oftenKeywords + " " + seldomKeywords;
        ContentBO content = null;
        content = export.getSiteType().equals("Headless") ? new FolderBO(contentName, articlesMap, subContents, export.getSiteKey(), fileName, export.getNumberOfBigTextPerPage(), acls, idCategory, idTag, visibilityOnPage, export.getVisibilityStartDate(), export.getVisibilityEndDate(), description, export.getCmisSiteName(), externalFilePaths, RandomUtils.isRandomOccurrence(export.getPcPersonalizedPages()), export.getMinPersonalizationVariants(), export.getMaxPersonalizationVariants()) : new PageBO(contentName, articlesMap, subContents, export.getPagesHaveVanity(), export.getSiteKey(), fileName, export.getNumberOfBigTextPerPage(), acls, idCategory, idTag, visibilityOnPage, export.getVisibilityStartDate(), export.getVisibilityEndDate(), description, template, export.getCmisSiteName(), externalFilePaths, RandomUtils.isRandomOccurrence(export.getPcPersonalizedPages()), export.getMinPersonalizationVariants(), export.getMaxPersonalizationVariants());
        return content;
    }

    public static List<String> getContentsPath(List<ContentBO> contents, String path) {
        ArrayList<String> siteMap = new ArrayList<String>();
        if (path == null) {
            path = "";
        }
        for (ContentBO content : contents) {
            String newPath = path + "/" + content.getName();
            siteMap.add(newPath);
            if (content.getSubContents() == null) continue;
            siteMap.addAll(ContentService.getContentsPath(content.getSubContents(), newPath));
        }
        return siteMap;
    }

    private String getOftenKeywords(int nbOfPagesToCreate) {
        Integer nbKeywordsAvailable = OFTEN_USED_DESCRIPTION_WORDS.size();
        double ratio = (double)ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS_COUNTER.intValue() * (double)nbKeywordsAvailable.intValue() / (double)nbOfPagesToCreate;
        double nbKeywordsToGet = (double)(ContentGeneratorService.currentPageIndex + 1) * ratio - (double)this.nbOftenKeywordsAlreadyAssigned;
        nbKeywordsToGet = Math.floor(nbKeywordsToGet);
        HashSet<Object> keywords = new HashSet();
        if ((double)nbKeywordsAvailable.intValue() <= nbKeywordsToGet) {
            keywords = new HashSet<String>(OFTEN_USED_DESCRIPTION_WORDS);
        } else {
            int i = 1;
            while ((double)i <= nbKeywordsToGet) {
                int randomId = this.random.nextInt(nbKeywordsAvailable - 1);
                boolean added = keywords.add(OFTEN_USED_DESCRIPTION_WORDS.get(randomId));
                if (!added) continue;
                ++i;
            }
        }
        StringBuffer sb = new StringBuffer();
        Iterator iterator = keywords.iterator();
        while (iterator.hasNext()) {
            sb = sb.append((String)iterator.next() + " ");
        }
        this.nbOftenKeywordsAlreadyAssigned += (int)nbKeywordsToGet;
        return sb.toString();
    }

    private String getSeldomKeywords(int nbOfPagesToCreate) {
        Integer nbKeywordsAvailable = SELDOM_USED_DESCRIPTION_WORDS.size();
        double ratio = (double)ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS_COUNTER.intValue() * (double)nbKeywordsAvailable.intValue() / (double)nbOfPagesToCreate;
        double nbKeywordsToGet = (double)(ContentGeneratorService.currentPageIndex + 1) * ratio - (double)this.nbSeldomKeywordsAlreadyAssigned;
        nbKeywordsToGet = Math.floor(nbKeywordsToGet);
        HashSet<Object> keywords = new HashSet();
        if ((double)nbKeywordsAvailable.intValue() <= nbKeywordsToGet) {
            keywords = new HashSet<String>(SELDOM_USED_DESCRIPTION_WORDS);
        } else {
            int i = 1;
            while ((double)i <= nbKeywordsToGet) {
                int randomId = this.random.nextInt(nbKeywordsAvailable - 1);
                boolean added = keywords.add(SELDOM_USED_DESCRIPTION_WORDS.get(randomId));
                if (!added) continue;
                ++i;
            }
        }
        StringBuffer sb = new StringBuffer();
        Iterator iterator = keywords.iterator();
        while (iterator.hasNext()) {
            sb = sb.append((String)iterator.next() + " ");
        }
        this.nbSeldomKeywordsAlreadyAssigned += (int)nbKeywordsToGet;
        return sb.toString();
    }

    private String getRandomCmisFilePath(String type) {
        List<CmisDirectoryPath> pathsList = this.cmisFilePaths.get(type);
        int randomPathIndex = this.random.nextInt(pathsList.size() - 1);
        CmisDirectoryPath pathObject = pathsList.get(randomPathIndex);
        int randomFileId = this.random.nextInt(pathObject.getNbFiles() - 1);
        String randomFileName = randomFileId + pathObject.getFileSuffix();
        String randomFilePath = pathObject.getDirectoryPath() + "/" + randomFileName;
        return randomFilePath;
    }

    private void initCmisFilePath() {
        ArrayList<CmisDirectoryPath> textPaths = new ArrayList<CmisDirectoryPath>();
        ArrayList<CmisDirectoryPath> picturesPaths = new ArrayList<CmisDirectoryPath>();
        int nbFiles = 100;
        for (int i = 0; i < 10; ++i) {
            textPaths.add(new CmisDirectoryPath("/text/directory-" + nbFiles + "-" + i, ".sample.txt", nbFiles));
            picturesPaths.add(new CmisDirectoryPath("/pictures/directory-" + nbFiles + "-" + i, ".sample.png", nbFiles));
        }
        nbFiles = 500;
        textPaths.add(new CmisDirectoryPath("/text/directory-" + nbFiles + "-0", ".sample.txt", nbFiles));
        picturesPaths.add(new CmisDirectoryPath("/pictures/directory-" + nbFiles + "-0", ".sample.png", nbFiles));
        nbFiles = 1000;
        textPaths.add(new CmisDirectoryPath("/text/directory-" + nbFiles + "-0", ".sample.txt", nbFiles));
        picturesPaths.add(new CmisDirectoryPath("/pictures/directory-" + nbFiles + "-0", ".sample.png", nbFiles));
        this.cmisFilePaths = new HashMap<String, List<CmisDirectoryPath>>();
        this.cmisFilePaths.put("pictures", textPaths);
        this.cmisFilePaths.put("text", picturesPaths);
    }

    private static class CmisDirectoryPath {
        private String directoryPath;
        private String fileSuffix;
        private int nbFiles;

        private CmisDirectoryPath(String directoryPath, String fileSuffix, int nbFiles) {
            this.directoryPath = "/documentLibrary" + directoryPath;
            this.fileSuffix = fileSuffix;
            this.nbFiles = nbFiles;
        }

        public String getDirectoryPath() {
            return this.directoryPath;
        }

        public String getFileSuffix() {
            return this.fileSuffix;
        }

        public int getNbFiles() {
            return this.nbFiles;
        }
    }
}

