/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class MountPointService {
    private Log logger = new SystemStreamLog();
    private String sep = System.getProperty("file.separator");

    public File createAndPopulateRepositoryFile(File tempOutputDir, File mountPointFile) throws IOException {
        File repositoryFile = new File(tempOutputDir, "repository.xml");
        FileOutputStream output = new FileOutputStream(repositoryFile, true);
        IOUtils.write((String)this.getHeader(), (OutputStream)output);
        if (mountPointFile != null) {
            IOUtils.copy((InputStream)new FileInputStream(mountPointFile), (OutputStream)output);
        }
        IOUtils.write((String)this.getFooter(), (OutputStream)output);
        return repositoryFile;
    }

    public String getHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n");
        sb.append("<content xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" xmlns:j=\"http://www.jahia.org/jahia/1.0\">\n");
        sb.append("<mounts jcr:primaryType=\"jnt:mounts\">\n");
        return sb.toString();
    }

    public String getFooter() {
        StringBuffer sb = new StringBuffer();
        sb.append("</mounts>\n");
        sb.append("</content>\n");
        return sb.toString();
    }
}

