/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.felix.bundleplugin.DependencyEmbedder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jahia.utils.maven.plugin.SLF4JLoggerToMojoLogBridge;
import org.jahia.utils.maven.plugin.osgi.ParsingContextCache;
import org.jahia.utils.maven.plugin.osgi.utils.CapabilityUtils;
import org.jahia.utils.maven.plugin.support.AetherHelper;
import org.jahia.utils.maven.plugin.support.AetherHelperFactory;
import org.jahia.utils.maven.plugin.support.ArtifactProcessor;
import org.jahia.utils.maven.plugin.support.MavenAetherHelperUtils;
import org.jahia.utils.osgi.BundleUtils;
import org.jahia.utils.osgi.ManifestValueClause;
import org.jahia.utils.osgi.PackageUtils;
import org.jahia.utils.osgi.PropertyFileUtils;
import org.jahia.utils.osgi.parsers.PackageInfo;
import org.jahia.utils.osgi.parsers.Parsers;
import org.jahia.utils.osgi.parsers.ParsingContext;
import org.slf4j.Logger;

public class DependenciesMojo
extends BundlePlugin {
    protected static final Set<String> SUPPORTED_FILE_EXTENSIONS_TO_SCAN = new HashSet<String>(Arrays.asList("jsp", "jspf", "tag", "tagf", "cnd", "drl", "xml", "groovy"));
    protected static final Set<String> DEPENDENCIES_SCAN_PACKAGING = new HashSet<String>(Arrays.asList("jar", "war"));
    protected static final Set<String> DEPENDENCIES_SCAN_SCOPES = new HashSet<String>(Arrays.asList("provided", "compile", "runtime"));
    private AetherHelper aetherHelper;
    protected PlexusContainer container;
    protected MavenSession mavenSession;
    protected MavenProject project;
    protected List<String> artifactExcludes = new ArrayList<String>();
    protected List<String> scanDirectories = new ArrayList<String>();
    protected List<String> excludeFromDirectoryScan = new ArrayList<String>();
    protected List<String> excludedJarEntries;
    protected List<Pattern> excludedJarEntryPatterns;
    protected String projectOutputDirectory;
    protected String projectBuildDirectory;
    protected File propertiesInputFile;
    protected File propertiesOutputFile;
    protected String systemExtraCapabilitiesPropertyName = "org.osgi.framework.system.capabilities.extra";
    protected boolean contentDefinitionCapabilitiesActivated = true;
    protected String existingImports = "";
    protected String dependencyParsingCacheDirectory = null;
    protected boolean jahiaDependsCapabilitiesActivated = true;
    protected String jahiaDependsCapabilitiesPrefix = ",";
    protected List<Pattern> artifactExclusionPatterns = new ArrayList<Pattern>();
    protected Logger logger = new SLF4JLoggerToMojoLogBridge(this.getLog());
    protected ParsingContextCache parsingContextCache;
    protected Collection<String> inlinedPaths = new LinkedHashSet<String>();
    protected Collection<Artifact> embeddedArtifacts = new LinkedHashSet<Artifact>();
    private static final String LOCAL_PACKAGES = "{local-packages}";

    protected AetherHelper getAetherHelper() throws MojoExecutionException {
        if (this.aetherHelper == null) {
            this.aetherHelper = AetherHelperFactory.create(this.container, this.project, this.mavenSession, this.getLog());
        }
        return this.aetherHelper;
    }

    public void setLog(Log log) {
        super.setLog(log);
        this.logger = new SLF4JLoggerToMojoLogBridge(log);
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException {
        this.setBuildDirectory(this.projectBuildDirectory);
        this.setOutputDirectory(new File(this.projectOutputDirectory));
        if (this.project.getGroupId().equals("org.jahia.modules") && this.project.getArtifactId().equals("jahia-modules") || !"jar".equals(this.project.getPackaging()) && !"bundle".equals(this.project.getPackaging()) && !"war".equals(this.project.getPackaging())) {
            return;
        }
        if (this.excludeFromDirectoryScan == null || this.excludeFromDirectoryScan.size() == 0) {
            this.excludeFromDirectoryScan.add("**/legacyMappings/*");
        }
        long startTime = System.currentTimeMillis();
        ParsingContext projectParsingContext = new ParsingContext(MavenAetherHelperUtils.getCoords(this.project.getArtifact()), 0L, 0L, this.project.getArtifactId(), this.project.getBasedir().getPath(), this.project.getVersion(), null);
        this.parsingContextCache = new ParsingContextCache(new File(this.dependencyParsingCacheDirectory), null);
        LinkedHashMap<String, String> originalInstructions = new LinkedHashMap<String, String>();
        if (this.project.getPlugin("org.apache.felix:maven-bundle-plugin") != null) {
            try {
                Xpp3Dom felixBundlePluginConfiguration = (Xpp3Dom)this.project.getPlugin("org.apache.felix:maven-bundle-plugin").getConfiguration();
                Xpp3Dom instructionsDom = felixBundlePluginConfiguration.getChild("instructions");
                for (Xpp3Dom xpp3Dom : instructionsDom.getChildren()) {
                    originalInstructions.put(xpp3Dom.getName(), xpp3Dom.getValue());
                }
                this.excludeDependencies = felixBundlePluginConfiguration.getChild("excludeDependencies").getValue();
            }
            catch (Exception felixBundlePluginConfiguration) {
                // empty catch block
            }
            Properties properties = new Properties();
            try {
                Builder builder = this.getOSGiBuilder(this.project, originalInstructions, properties, this.getClasspath(this.project));
                this.resolveEmbeddedDependencies(this.project, builder);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error trying to process bundle plugin instructions", e);
            }
        }
        if (this.project.getPackaging().equals("war")) {
            for (Artifact artifact : this.project.getArtifacts()) {
                if (artifact.getScope().toLowerCase().equals("provided") || artifact.getScope().toLowerCase().equals("test")) continue;
                this.embeddedArtifacts.add(artifact);
            }
        }
        List<PackageInfo> existingPackageImports = this.getExistingImportPackages(projectParsingContext);
        projectParsingContext.addAllPackageImports(existingPackageImports);
        this.buildExclusionPatterns();
        long timer = System.currentTimeMillis();
        try {
            this.scanClassesBuildDirectory(projectParsingContext);
            this.getLog().info((CharSequence)("Scanned classes directory in " + (System.currentTimeMillis() - timer) + " ms. Found " + projectParsingContext.getLocalPackages().size() + " project packages."));
            timer = System.currentTimeMillis();
            int scanned = this.scanDependencies(projectParsingContext);
            this.getLog().info((CharSequence)("Scanned " + scanned + " project dependencies in " + (System.currentTimeMillis() - timer) + " ms. Currently we have " + projectParsingContext.getLocalPackages().size() + " project packages."));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning dependencies", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error while scanning dependencies", (Exception)((Object)e));
        }
        if (this.scanDirectories.isEmpty()) {
            this.scanDirectories.add(this.project.getBasedir() + "/src/main/resources");
            this.scanDirectories.add(this.project.getBasedir() + "/src/main/import");
            this.scanDirectories.add(this.project.getBasedir() + "/src/main/webapp");
        }
        timer = System.currentTimeMillis();
        for (String scanDirectory : this.scanDirectories) {
            File file = new File(scanDirectory);
            if (!file.exists()) {
                this.getLog().debug((CharSequence)("Couldn't find directory " + file + ", skipping !"));
                continue;
            }
            try {
                this.getLog().info((CharSequence)("Scanning resource directory " + file + "..."));
                this.processDirectoryTlds(file, this.project.getVersion(), projectParsingContext);
                this.processDirectory(file, false, this.project.getVersion(), projectParsingContext);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error processing resource directory " + file, (Exception)e);
            }
        }
        this.getLog().info((CharSequence)("Scanned resource directories in " + (System.currentTimeMillis() - timer) + " ms. Currently we have " + projectParsingContext.getLocalPackages().size() + " project packages."));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Found project packages (potential exports) :");
            for (PackageInfo projectPackage : projectParsingContext.getLocalPackages()) {
                this.getLog().debug((CharSequence)("  " + projectPackage));
            }
        }
        projectParsingContext.postProcess();
        SortedSet childLocalPackagesToRemoveFromImport = projectParsingContext.getChildrenLocalPackagesToRemoveFromImports();
        for (PackageInfo packageInfo : childLocalPackagesToRemoveFromImport) {
            PackageUtils.removeMatchingVersions((Collection)projectParsingContext.getPackageImports(), (PackageInfo)packageInfo);
        }
        if (projectParsingContext.getUnresolvedTaglibUris().size() > 0) {
            for (Map.Entry entry : projectParsingContext.getUnresolvedTaglibUris().entrySet()) {
                for (String unresolvedUriForJsp : (Set)entry.getValue()) {
                    this.getLogger().warn("JSP " + (String)entry.getKey() + " has a reference to taglib " + unresolvedUriForJsp + " that is not in the project's dependencies !");
                }
            }
        }
        StringBuilder generatedPackageBuffer = new StringBuilder(256);
        boolean bl = false;
        Map<String, String> importOverrides = this.getPackageImportOverrides();
        if (importOverrides != null) {
            this.getLog().info((CharSequence)("Considering provided Import-Package-Override: " + StringUtils.join(importOverrides.values(), (String)", ")));
        }
        TreeSet<String> uniquePackageImports = new TreeSet<String>();
        for (PackageInfo packageImport : projectParsingContext.getPackageImports()) {
            void var10_26;
            String packageImportName = null;
            packageImportName = importOverrides != null && importOverrides.containsKey(packageImport.getName()) ? importOverrides.get(packageImport.getName()) : packageImport.toString(false);
            if (uniquePackageImports.contains(packageImport.getName())) continue;
            generatedPackageBuffer.append(packageImportName);
            if (var10_26 < projectParsingContext.getPackageImports().size() - 1) {
                generatedPackageBuffer.append(",\n");
            }
            uniquePackageImports.add(packageImport.getName());
            ++var10_26;
        }
        this.getLog().info((CharSequence)("Generated " + projectParsingContext.getPackageImports().size() + " package imports for project."));
        this.getLog().info((CharSequence)"Found referenced tag library URIs (from JSPs) :");
        for (Object taglibUri : projectParsingContext.getTaglibUris()) {
            boolean externalTagLib;
            boolean foundInDependencies = projectParsingContext.getTaglibPackages().containsKey(taglibUri);
            String foundMessage = "";
            if (!foundInDependencies) {
                foundMessage = "NOT FOUND";
            }
            if (foundInDependencies && (externalTagLib = ((Boolean)projectParsingContext.getExternalTaglibs().get(taglibUri)).booleanValue())) {
                foundMessage = foundMessage + " provided";
            }
            this.getLog().info((CharSequence)("  " + (String)taglibUri + " " + foundMessage));
        }
        StringBuilder contentTypeDefinitionsBuffer = new StringBuilder(256);
        if (projectParsingContext.getContentTypeDefinitions().size() > 0) {
            contentTypeDefinitionsBuffer.append("com.jahia.services.content; nodetypes:List<String>=\"");
            boolean bl2 = false;
            for (String contentTypeName : projectParsingContext.getContentTypeDefinitions()) {
                void var10_28;
                contentTypeDefinitionsBuffer.append(contentTypeName);
                if (var10_28 < projectParsingContext.getContentTypeDefinitions().size() - 1) {
                    contentTypeDefinitionsBuffer.append(",");
                }
                ++var10_28;
            }
            contentTypeDefinitionsBuffer.append("\"");
        }
        if (this.contentDefinitionCapabilitiesActivated) {
            this.getLog().info((CharSequence)("Found " + projectParsingContext.getContentTypeDefinitions().size() + " new content node type definitions in project."));
            this.getLog().debug((CharSequence)("Provide-Capability: " + contentTypeDefinitionsBuffer.toString()));
            this.project.getProperties().put("jahia.plugin.providedNodeTypes", contentTypeDefinitionsBuffer.toString());
        } else {
            this.project.getProperties().put("jahia.plugin.providedNodeTypes", "");
        }
        StringBuilder contentTypeReferencesBuffer = new StringBuilder();
        if (projectParsingContext.getContentTypeReferences().size() > 0) {
            boolean bl3 = false;
            for (String contentTypeReference : projectParsingContext.getContentTypeReferences()) {
                void var10_30;
                contentTypeReferencesBuffer.append("com.jahia.services.content; filter:=\"(nodetypes=").append(contentTypeReference).append(")\"");
                if (var10_30 < projectParsingContext.getContentTypeReferences().size() - 1) {
                    contentTypeReferencesBuffer.append(",");
                }
                ++var10_30;
            }
        }
        if (this.contentDefinitionCapabilitiesActivated) {
            this.getLog().info((CharSequence)("Found " + projectParsingContext.getContentTypeReferences().size() + " content node type definitions referenced in project."));
            this.getLog().debug((CharSequence)("Require-Capability: " + contentTypeReferencesBuffer.toString()));
            this.project.getProperties().put("jahia.plugin.requiredNodeTypes", contentTypeReferencesBuffer.toString());
        } else {
            this.project.getProperties().put("jahia.plugin.requiredNodeTypes", "");
        }
        if (this.jahiaDependsCapabilitiesActivated) {
            this.getLog().info((CharSequence)"Building OSGi capabilities for Jahia module dependencies...");
            String[] skipValues = StringUtils.split((String)((String)originalInstructions.get("Jahia-Depends-Skip-Require-Capability")), (String)", \n");
            HashSet<String> skipRequireDependencies = skipValues == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(skipValues));
            Object[] removeHeaders = StringUtils.split((String)((String)originalInstructions.get("_removeheaders")), (String)", \n");
            boolean skipJahiaDepends = ArrayUtils.contains((Object[])removeHeaders, (Object)"Jahia-Depends");
            String jahiaDependsValue = skipJahiaDepends ? "" : (String)originalInstructions.get("Jahia-Depends");
            try {
                CapabilityUtils.buildJahiaDependencies(this.project, jahiaDependsValue, skipRequireDependencies, this.jahiaDependsCapabilitiesPrefix);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error generating capabilities from Jahia-Depends", (Throwable)e);
            }
            this.getLog().debug((CharSequence)("Jahia-Depends Requires: " + this.project.getProperties().getProperty("jahia.plugin.requiredModulesCapabilities")));
            this.getLog().debug((CharSequence)("Jahia-Depends Provides: " + this.project.getProperties().getProperty("jahia.plugin.providedModulesCapabilities")));
        }
        String generatedPackageList = generatedPackageBuffer.toString();
        this.project.getProperties().put("jahia.plugin.projectPackageImport", generatedPackageList);
        this.getLog().debug((CharSequence)"Set project property jahia.plugin.projectPackageImport to package import list value: ");
        this.getLog().debug((CharSequence)generatedPackageList);
        if (this.propertiesOutputFile != null) {
            String[] extraCapabilitiesPropertyValue = new String[]{contentTypeDefinitionsBuffer.toString()};
            try {
                PropertyFileUtils.updatePropertyFile((File)this.propertiesInputFile, (File)this.propertiesOutputFile, (String)this.systemExtraCapabilitiesPropertyName, (String[])extraCapabilitiesPropertyValue, (Logger)new SLF4JLoggerToMojoLogBridge(this.getLog()));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Error saving extra system capabilities to file " + this.propertiesOutputFile));
            }
        }
        this.getLog().info((CharSequence)("Took " + (System.currentTimeMillis() - startTime) + " ms for the dependencies analysis"));
    }

    public List<PackageInfo> getExistingImportPackages(ParsingContext projectParsingContext) throws MojoExecutionException {
        ArrayList<PackageInfo> existingPackageImports = new ArrayList<PackageInfo>();
        if (this.existingImports != null) {
            try {
                List existingImportValueClauses = BundleUtils.getHeaderClauses((String)"Import-Package", (String)this.existingImports);
                for (ManifestValueClause existingImportValueClause : existingImportValueClauses) {
                    String clauseVersion = (String)existingImportValueClause.getAttributes().get("version");
                    String clauseResolution = (String)existingImportValueClause.getDirectives().get("resolution");
                    boolean optionalClause = false;
                    if ("optional".equals(clauseResolution)) {
                        optionalClause = true;
                    }
                    for (String existingImportPath : existingImportValueClause.getPaths()) {
                        existingPackageImports.add(new PackageInfo(existingImportPath, clauseVersion, optionalClause, "Maven plugin configuration", projectParsingContext));
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while parsing existing import clauses", (Exception)e);
            }
        }
        return existingPackageImports;
    }

    private Map<String, String> getPackageImportOverrides() {
        HashMap<String, String> overrides = null;
        String importPackageOverride = null;
        try {
            importPackageOverride = ((Xpp3Dom)this.project.getPlugin("org.apache.felix:maven-bundle-plugin").getConfiguration()).getChild("instructions").getChild("Import-Package-Override").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotEmpty(importPackageOverride)) {
            overrides = new HashMap<String, String>();
            for (String token : StringUtils.split((String)importPackageOverride, (String)",\n\r")) {
                if ((token = token.trim()).length() <= 0) continue;
                overrides.put(token.contains(";") ? StringUtils.substringBefore((String)token, (String)";").trim() : token, token);
            }
        }
        return overrides != null && !overrides.isEmpty() ? overrides : null;
    }

    protected void scanClassesBuildDirectory(ParsingContext parsingContext) throws IOException, DependencyResolutionRequiredException, MojoExecutionException {
        String[] includedFiles;
        File outputDirectoryFile = new File(this.projectOutputDirectory);
        if (!outputDirectoryFile.exists()) {
            this.getLog().warn((CharSequence)("Couldn't scan project output directory " + outputDirectoryFile + " because it doesn't exist !"));
            return;
        }
        this.getLog().info((CharSequence)("Scanning project build directory " + outputDirectoryFile.getCanonicalPath()));
        DirectoryScanner ds = new DirectoryScanner();
        String[] excludes = new String[]{"META-INF/**", "OSGI-INF/**", "OSGI-OPT/**", "WEB-INF/**"};
        ds.setExcludes(excludes);
        ds.setBasedir(outputDirectoryFile);
        ds.setCaseSensitive(true);
        ds.scan();
        for (String includedFile : includedFiles = ds.getIncludedFiles()) {
            this.processLocalPackageEntry(includedFile, File.separator, outputDirectoryFile.getCanonicalPath(), this.project.getVersion(), false, parsingContext);
        }
    }

    protected void buildExclusionPatterns() {
        if (this.artifactExcludes != null) {
            for (String artifactExclude : this.artifactExcludes) {
                String artifactPattern;
                int colonPos = artifactExclude.indexOf(":");
                String groupPattern = ".*";
                if (colonPos > -1) {
                    groupPattern = artifactExclude.substring(0, colonPos);
                    artifactPattern = artifactExclude.substring(colonPos + 1);
                } else {
                    artifactPattern = artifactExclude;
                }
                groupPattern = groupPattern.replaceAll("\\.", "\\\\.");
                groupPattern = groupPattern.replaceAll("\\*", ".*");
                artifactPattern = artifactPattern.replaceAll("\\.", "\\\\.");
                artifactPattern = artifactPattern.replaceAll("\\*", ".*");
                this.artifactExclusionPatterns.add(Pattern.compile(groupPattern + ":" + artifactPattern));
            }
        }
        if (this.artifactExclusionPatterns.size() > 0) {
            this.getLog().info((CharSequence)("Configured " + this.artifactExclusionPatterns.size() + " artifact exclusions for scanning project dependencies: " + Arrays.toString(this.artifactExclusionPatterns.toArray())));
        } else {
            this.getLog().info((CharSequence)"No artifact exclusions specified. Will scan all related dependencies of the project.");
        }
        this.excludedJarEntryPatterns = new LinkedList<Pattern>();
        this.excludedJarEntryPatterns.add(Pattern.compile(".*/legacyDefinitions/.*\\.cnd"));
        if (this.excludedJarEntries != null && this.excludedJarEntries.size() > 0) {
            for (String p : this.excludedJarEntries) {
                this.excludedJarEntryPatterns.add(Pattern.compile(p.trim()));
            }
        }
    }

    protected int scanDependencies(final ParsingContext projectParsingContext) throws IOException, MojoExecutionException {
        this.getLog().info((CharSequence)"Scanning project dependencies...");
        int scanned = 0;
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            if (artifact.isOptional()) {
                this.getLog().info((CharSequence)("Scanning optional dependency " + artifact + "..."));
            }
            if (!DEPENDENCIES_SCAN_PACKAGING.contains(artifact.getType()) || !DEPENDENCIES_SCAN_SCOPES.contains(artifact.getScope()) || this.isExcludedFromScan(artifact)) continue;
            final int scannedCopy = scanned++;
            final DependenciesMojo dependenciesMojo = this;
            this.getAetherHelper().processArtifactAndDependencies(artifact, artifact.isOptional(), new ArtifactProcessor(){

                @Override
                public boolean isExternal(Artifact artifact) {
                    for (String inlinedPath : DependenciesMojo.this.inlinedPaths) {
                        if (!inlinedPath.startsWith(artifact.getFile().getPath())) continue;
                        return false;
                    }
                    for (Artifact embeddedArtifact : DependenciesMojo.this.embeddedArtifacts) {
                        if (!artifact.equals(embeddedArtifact)) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public ParsingContext enterArtifact(Artifact artifact, boolean optional, boolean external, ParsingContext parentParsingContext, String logPrefix, int depth) throws MojoExecutionException {
                    try {
                        return dependenciesMojo.startProcessingArtifact(projectParsingContext, scannedCopy, artifact, external, optional, parentParsingContext, logPrefix, depth);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error processing artifact " + artifact, (Exception)e);
                    }
                }

                @Override
                public boolean exitArtifact(Artifact artifact, boolean optional, boolean external, String logPrefix, ParsingContext parsingContext, int depth) throws MojoExecutionException {
                    return dependenciesMojo.endProcessingArtifact(projectParsingContext, artifact, external, logPrefix, parsingContext, depth);
                }
            }, artifact.getArtifactHandler(), projectParsingContext);
        }
        projectParsingContext.removeLocalPackagesFromImports();
        return scanned;
    }

    protected ParsingContext startProcessingArtifact(ParsingContext projectParsingContext, int scanned, Artifact artifact, boolean externalDependency, boolean optional, ParsingContext parentParsingContext, String logPrefix, int depth) throws MojoExecutionException, IOException {
        ParsingContext parsingContext = this.parsingContextCache.get(artifact);
        if (parsingContext == null) {
            parsingContext = new ParsingContext(MavenAetherHelperUtils.getCoords(artifact), artifact.getFile().lastModified(), artifact.getFile().length(), artifact.getFile().getName(), artifact.getFile().getPath(), artifact.getVersion(), parentParsingContext);
            long timer = System.currentTimeMillis();
            int scannedInJar = this.scanJar(artifact.getFile(), externalDependency, "war".equals(artifact.getType()) ? "WEB-INF/classes/" : "", artifact.getVersion(), artifact.isOptional(), parsingContext, logPrefix);
            long took = System.currentTimeMillis() - timer;
            if (this.getLog().isInfoEnabled() && scannedInJar > 0) {
                this.getLog().info((CharSequence)(logPrefix + "Processed " + scannedInJar + (scanned == 1 ? " entry" : " entries") + " in " + (externalDependency ? "external" : "") + "dependency " + artifact + " in " + took + " ms"));
            }
        }
        if (parentParsingContext != null) {
            parentParsingContext.addChildJarParsingContext(parsingContext);
        }
        if (optional) {
            parsingContext.setOptional(true);
        } else {
            parsingContext.setOptional(false);
        }
        if (externalDependency) {
            parsingContext.setExternal(true);
        } else {
            parsingContext.setExternal(false);
        }
        return parsingContext;
    }

    protected boolean endProcessingArtifact(ParsingContext projectParsingContext, Artifact artifact, boolean externalDependency, String logPrefix, ParsingContext parsingContext, int depth) {
        if (artifact == null) {
            this.getLog().warn((CharSequence)(logPrefix + ": Artifact is null, will not put parsed JAR context " + parsingContext + " in cache !"));
            return false;
        }
        if (!artifact.getFile().getPath().equals(parsingContext.getFilePath())) {
            this.getLog().warn((CharSequence)(logPrefix + ": Artifact file path (" + artifact.getFile().getPath() + ") and jarParsingContext file path (" + parsingContext.getFilePath() + ") do not match, will not put parsed JAR context " + parsingContext + " in cache !"));
            return false;
        }
        parsingContext.postProcess();
        if (!parsingContext.isInCache()) {
            this.parsingContextCache.put(artifact, parsingContext);
        }
        return true;
    }

    protected boolean isExcludedFromScan(Artifact artifact) {
        String id = StringUtils.substringBeforeLast((String)artifact.toString(), (String)":");
        for (Pattern exclusionPattern : this.artifactExclusionPatterns) {
            Matcher exclusionMatcher = exclusionPattern.matcher(id = artifact.getGroupId() + ":" + artifact.getArtifactId());
            if (!exclusionMatcher.matches()) continue;
            this.getLog().info((CharSequence)("Ignoring artifact as the exclusion matched for " + id));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int scanJar(File jarFile, boolean externalDependency, String packageDirectory, String version, boolean optional, ParsingContext parsingContext, String logPrefix) throws IOException {
        ByteArrayOutputStream entryOutputStream;
        InputStream jarEntryInputStream;
        JarEntry jarEntry;
        JarFile jar;
        int scanned = 0;
        if (jarFile.isDirectory()) {
            this.getLog().debug((CharSequence)(logPrefix + "Processing dependency directory " + jarFile + "..."));
            this.processDirectoryTlds(jarFile, version, parsingContext);
            this.processDirectory(jarFile, false, version, parsingContext);
            return scanned;
        }
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));){
            Object jarEntry2 = null;
            this.getLog().debug((CharSequence)(logPrefix + "Processing JAR file " + jarFile + "..."));
            if (this.processJarManifest(jarFile, parsingContext, jarInputStream)) {
                this.getLog().debug((CharSequence)(logPrefix + "Used OSGi bundle manifest information, but scanning for additional resources (taglibs, CNDs, etc)... "));
            }
            scanned = this.processJarInputStream(jarFile.getPath(), externalDependency, packageDirectory, version, optional, parsingContext, logPrefix, scanned, jarInputStream);
        }
        if (parsingContext.getBundleClassPath().size() > 0) {
            this.getLog().debug((CharSequence)(logPrefix + "Processing embedded dependencies..."));
            jar = new JarFile(jarFile);
            for (String embeddedJar : parsingContext.getBundleClassPath()) {
                if (".".equals(embeddedJar)) continue;
                jarEntry = jar.getJarEntry(embeddedJar);
                if (jarEntry != null) {
                    this.getLog().debug((CharSequence)(logPrefix + "Processing embedded JAR..." + jarEntry));
                    jarEntryInputStream = jar.getInputStream(jarEntry);
                    entryOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)jarEntryInputStream, (OutputStream)entryOutputStream);
                    JarInputStream entryJarInputStream = new JarInputStream(new ByteArrayInputStream(entryOutputStream.toByteArray()));
                    this.processJarInputStream(jarFile.getPath() + "!" + jarEntry, externalDependency, packageDirectory, version, optional, parsingContext, logPrefix, scanned, entryJarInputStream);
                    IOUtils.closeQuietly((InputStream)jarEntryInputStream);
                    IOUtils.closeQuietly((InputStream)entryJarInputStream);
                    continue;
                }
                this.getLog().warn((CharSequence)(logPrefix + "Couldn't find embedded JAR to parse " + embeddedJar + " in JAR " + jarFile));
            }
        }
        if (parsingContext.getAdditionalFilesToParse().size() > 0) {
            this.getLog().debug((CharSequence)(logPrefix + "Processing additional files to parse..."));
            jar = new JarFile(jarFile);
            for (String fileToParse : parsingContext.getAdditionalFilesToParse()) {
                jarEntry = jar.getJarEntry(fileToParse);
                if (jarEntry != null) {
                    jarEntryInputStream = jar.getInputStream(jarEntry);
                    entryOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)jarEntryInputStream, (OutputStream)entryOutputStream);
                    if (this.processNonTldFile(jarEntry.getName(), new ByteArrayInputStream(entryOutputStream.toByteArray()), jarFile.getPath(), optional, version, parsingContext)) {
                        ++scanned;
                    }
                    IOUtils.closeQuietly((InputStream)jarEntryInputStream);
                    continue;
                }
                this.getLog().warn((CharSequence)(logPrefix + "Couldn't find additional file to parse " + fileToParse + " in JAR " + jarFile));
            }
            parsingContext.clearAdditionalFilesToParse();
        }
        return scanned;
    }

    protected int processJarInputStream(String jarFilePath, boolean externalDependency, String packageDirectory, String version, boolean optional, ParsingContext parsingContext, String logPrefix, int scanned, JarInputStream jarInputStream) throws IOException {
        JarEntry jarEntry;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            String packageName;
            if (jarEntry.isDirectory()) continue;
            String entryName = jarEntry.getName();
            if (entryName.startsWith(packageDirectory) && !(packageName = entryName.substring(packageDirectory.length())).contains("/.")) {
                this.processLocalPackageEntry(packageName, "/", jarFilePath, version, optional, parsingContext);
            }
            if (this.excludeJarEntry(entryName)) continue;
            ByteArrayOutputStream entryOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)jarInputStream, (OutputStream)entryOutputStream);
            if (Parsers.getInstance().canParseForPhase(0, jarEntry.getName())) {
                this.getLog().debug((CharSequence)(logPrefix + "  scanning JAR entry: " + jarEntry.getName()));
                Parsers.getInstance().parse(0, jarEntry.getName(), (InputStream)new ByteArrayInputStream(entryOutputStream.toByteArray()), jarFilePath, externalDependency, optional, version, this.getLogger(), parsingContext);
                ++scanned;
            }
            if (!Parsers.getInstance().canParseForPhase(1, jarEntry.getName())) continue;
            this.getLog().debug((CharSequence)(logPrefix + "  scanning JAR entry: " + jarEntry.getName()));
            if (!this.processNonTldFile(jarEntry.getName(), new ByteArrayInputStream(entryOutputStream.toByteArray()), jarFilePath, optional, version, parsingContext)) continue;
            ++scanned;
        }
        return scanned;
    }

    private boolean processJarManifest(File jarFile, ParsingContext parsingContext, JarInputStream jarInputStream) throws IOException {
        Attributes mainAttributes;
        String bundleSymbolicName;
        boolean processedBundleHeadersSuccessfully = false;
        Manifest jarManifest = jarInputStream.getManifest();
        if (jarManifest != null && jarManifest.getMainAttributes() != null && (bundleSymbolicName = (mainAttributes = jarManifest.getMainAttributes()).getValue("Bundle-SymbolicName")) != null) {
            String clauseVersion;
            String bundleVersion = mainAttributes.getValue("Bundle-Version");
            String bundleClassPath = mainAttributes.getValue("Bundle-ClassPath");
            if (bundleClassPath != null && !".".equals(bundleClassPath.trim())) {
                String[] bundleClassPathEntries;
                for (String bundleClassPathEntry : bundleClassPathEntries = bundleClassPath.split(",")) {
                    parsingContext.getBundleClassPath().add(bundleClassPathEntry.trim());
                }
            }
            this.getLog().debug((CharSequence)("OSGi bundle detected with symbolic name=" + bundleSymbolicName + " version=" + bundleVersion));
            parsingContext.setOsgiBundle(true);
            parsingContext.setVersion(bundleVersion);
            String importPackageHeaderValue = mainAttributes.getValue("Import-Package");
            String exportPackageHeaderValue = mainAttributes.getValue("Export-Package");
            String ignorePackageHeaderValue = mainAttributes.getValue("Ignore-Package");
            if (importPackageHeaderValue != null) {
                List importPackageClauses = BundleUtils.getHeaderClauses((String)"Import-Package", (String)importPackageHeaderValue);
                for (ManifestValueClause importPackageClause : importPackageClauses) {
                    for (String importPackagePath : importPackageClause.getPaths()) {
                        clauseVersion = (String)importPackageClause.getAttributes().get("version");
                        String clauseResolution = (String)importPackageClause.getDirectives().get("resolution");
                        boolean optionalClause = false;
                        if ("optional".equals(clauseResolution)) {
                            optionalClause = true;
                        }
                        PackageInfo importPackageInfo = new PackageInfo(importPackagePath, clauseVersion, optionalClause, jarFile.getPath(), parsingContext);
                        parsingContext.addPackageImport(importPackageInfo);
                    }
                }
            }
            if (exportPackageHeaderValue != null) {
                List exportPackageClauses = BundleUtils.getHeaderClauses((String)"Export-Package", (String)exportPackageHeaderValue);
                for (ManifestValueClause exportPackageClause : exportPackageClauses) {
                    for (String importPackagePath : exportPackageClause.getPaths()) {
                        clauseVersion = (String)exportPackageClause.getAttributes().get("version");
                        PackageInfo exportPackageInfo = new PackageInfo(importPackagePath, clauseVersion, false, jarFile.getPath(), parsingContext);
                        parsingContext.addPackageExport(exportPackageInfo);
                    }
                }
            }
            if (ignorePackageHeaderValue != null) {
                List ignorePackageClauses = BundleUtils.getHeaderClauses((String)"Ignore-Package", (String)ignorePackageHeaderValue);
                for (ManifestValueClause ignorePackageClause : ignorePackageClauses) {
                    for (String importPackagePath : ignorePackageClause.getPaths()) {
                        clauseVersion = (String)ignorePackageClause.getAttributes().get("version");
                        boolean optionalClause = true;
                        PackageInfo ignorePackageInfo = new PackageInfo(importPackagePath, clauseVersion, optionalClause, jarFile.getPath(), parsingContext);
                        parsingContext.addPackageImport(ignorePackageInfo);
                    }
                }
            }
            processedBundleHeadersSuccessfully = true;
        }
        return processedBundleHeadersSuccessfully;
    }

    private void processLocalPackageEntry(String entryName, String fileSeparator, String entryParent, String version, boolean optional, ParsingContext parsingContext) {
        int lastSlash = entryName.lastIndexOf(fileSeparator);
        if (lastSlash == -1) {
            return;
        }
        String entryPackage = StringUtils.replace((String)entryName.substring(0, lastSlash), (String)fileSeparator, (String)".");
        if (!(!StringUtils.isNotEmpty((String)entryPackage) || parsingContext.getLocalPackages().contains(new PackageInfo(entryPackage)) || entryPackage.startsWith("META-INF") || entryPackage.startsWith("OSGI-INF") || entryPackage.startsWith("OSGI-OPT") || entryPackage.startsWith("WEB-INF"))) {
            PackageInfo packageInfo = new PackageInfo(entryPackage, version, optional, entryParent + "/" + entryName, parsingContext);
            parsingContext.addLocalPackage(packageInfo);
            if (!parsingContext.isOsgiBundle()) {
                parsingContext.addPackageExport(packageInfo);
            }
        }
    }

    private boolean excludeJarEntry(String entryName) {
        if (this.excludedJarEntryPatterns != null) {
            for (Pattern p : this.excludedJarEntryPatterns) {
                if (!p.matcher(entryName).matches()) continue;
                this.getLog().debug((CharSequence)("Matched JAR entry exclusion pattern for entry " + entryName));
                return true;
            }
        }
        return false;
    }

    private void processDirectoryTlds(File directoryFile, String version, ParsingContext parsingContext) throws IOException {
        String[] includedFiles;
        DirectoryScanner ds = new DirectoryScanner();
        String[] excludes = this.excludeFromDirectoryScan.toArray(new String[this.excludeFromDirectoryScan.size()]);
        ds.setExcludes(excludes);
        ds.setIncludes(new String[]{"**/*.tld"});
        ds.setBasedir(directoryFile);
        ds.setCaseSensitive(true);
        ds.scan();
        for (String includedFile : includedFiles = ds.getIncludedFiles()) {
            Parsers.getInstance().parse(0, includedFile, (InputStream)new BufferedInputStream(new FileInputStream(new File(directoryFile, includedFile))), directoryFile.getPath(), false, false, version, this.getLogger(), parsingContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDirectory(File directoryFile, boolean optional, String version, ParsingContext parsingContext) throws IOException {
        String[] includedFiles;
        DirectoryScanner ds = new DirectoryScanner();
        String[] excludes = this.excludeFromDirectoryScan.toArray(new String[this.excludeFromDirectoryScan.size()]);
        ds.setExcludes(excludes);
        ds.setBasedir(directoryFile);
        ds.setCaseSensitive(true);
        ds.scan();
        for (String includedFile : includedFiles = ds.getIncludedFiles()) {
            String ext = FileUtils.getExtension((String)includedFile).toLowerCase();
            if (!SUPPORTED_FILE_EXTENSIONS_TO_SCAN.contains(ext)) continue;
            BufferedInputStream fileInputStream = null;
            try {
                fileInputStream = new BufferedInputStream(new FileInputStream(new File(directoryFile, includedFile)));
                this.processNonTldFile(includedFile, fileInputStream, directoryFile.getPath(), optional, version, parsingContext);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    private boolean processNonTldFile(String fileName, InputStream inputStream, String fileParent, boolean optional, String version, ParsingContext parsingContext) throws IOException {
        String ext = FileUtils.getExtension((String)fileName).toLowerCase();
        if (!SUPPORTED_FILE_EXTENSIONS_TO_SCAN.contains(ext)) {
            return false;
        }
        return Parsers.getInstance().parse(1, fileName, inputStream, fileParent, false, optional, version, this.getLogger(), parsingContext);
    }

    private Logger getLogger() {
        return this.logger;
    }

    protected void resolveEmbeddedDependencies(MavenProject currentProject, Builder builder) throws Exception {
        if (currentProject.getBasedir() != null) {
            DependenciesMojo.includeMavenResources((MavenProject)currentProject, (Analyzer)builder, (Log)this.getLog());
            DependenciesMojo.addLocalPackages(new File(this.projectOutputDirectory), (Analyzer)builder);
            DependenciesMojo.addMavenSourcePath((MavenProject)currentProject, (Analyzer)builder, (Log)this.getLog());
        }
        Collection embeddableArtifacts = this.getEmbeddableArtifacts(currentProject, (Analyzer)builder);
        DependencyEmbedder dependencyEmbedder = new DependencyEmbedder(this.getLog(), embeddableArtifacts);
        dependencyEmbedder.processHeaders((Analyzer)builder);
        this.inlinedPaths = dependencyEmbedder.getInlinedPaths();
        this.embeddedArtifacts = dependencyEmbedder.getEmbeddedArtifacts();
    }

    private static void addLocalPackages(File outputDirectory, Analyzer analyzer) throws IOException {
        Packages packages = new Packages();
        if (outputDirectory != null && outputDirectory.isDirectory()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(outputDirectory);
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.addDefaultExcludes();
            scanner.scan();
            String[] paths = scanner.getIncludedFiles();
            for (int i = 0; i < paths.length; ++i) {
                packages.put(analyzer.getPackageRef(DependenciesMojo.getPackageName(paths[i])));
            }
        }
        Packages exportedPkgs = new Packages();
        Packages privatePkgs = new Packages();
        boolean noprivatePackages = "!*".equals(analyzer.getProperty("Private-Package"));
        for (Descriptors.PackageRef pkg : packages.keySet()) {
            privatePkgs.put(pkg);
            String fqn = pkg.getFQN();
            if (!noprivatePackages && (".".equals(fqn) || fqn.contains(".internal") || fqn.contains(".impl"))) continue;
            exportedPkgs.put(pkg);
        }
        Properties properties = analyzer.getProperties();
        String exported = properties.getProperty("Export-Package");
        if (exported == null) {
            if (!properties.containsKey("-exportcontents")) {
                for (Object attrs : exportedPkgs.values()) {
                    attrs.put("-split-package:", "merge-first");
                }
                properties.setProperty("Export-Package", Processor.printClauses((Map)exportedPkgs));
            } else {
                properties.setProperty("Export-Package", "");
            }
        } else if (exported.indexOf(LOCAL_PACKAGES) >= 0) {
            String newExported = org.codehaus.plexus.util.StringUtils.replace((String)exported, (String)LOCAL_PACKAGES, (String)Processor.printClauses((Map)exportedPkgs));
            properties.setProperty("Export-Package", newExported);
        }
        String internal = properties.getProperty("Private-Package");
        if (internal == null) {
            if (!privatePkgs.isEmpty()) {
                for (Attrs attrs : privatePkgs.values()) {
                    attrs.put("-split-package:", "merge-first");
                }
                properties.setProperty("Private-Package", Processor.printClauses((Map)privatePkgs));
            } else {
                properties.setProperty("Private-Package", "!*");
            }
        } else if (internal.indexOf(LOCAL_PACKAGES) >= 0) {
            String newInternal = org.codehaus.plexus.util.StringUtils.replace((String)internal, (String)LOCAL_PACKAGES, (String)Processor.printClauses((Map)privatePkgs));
            properties.setProperty("Private-Package", newInternal);
        }
    }

    private static String getPackageName(String filename) {
        int n = filename.lastIndexOf(File.separatorChar);
        return n < 0 ? "." : filename.substring(0, n).replace(File.separatorChar, '.');
    }
}

