/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jahia.utils.maven.plugin.osgi.models.JahiaDepends;

public class CapabilityUtils {
    static final String DELIMITER = ";";

    public static void buildJahiaDependencies(MavenProject project, String jahiaDependsValue, Set<String> skipRequireDependencies, String prefix) throws MojoExecutionException {
        String requireCapabilities;
        Properties projectProp = project.getProperties();
        projectProp.put("jahia.plugin.requiredModulesCapabilities", "");
        projectProp.put("jahia.plugin.providedModulesCapabilities", "");
        if (StringUtils.isNotBlank((String)jahiaDependsValue) && !(requireCapabilities = Arrays.stream((jahiaDependsValue = CapabilityUtils.replaceDependsDelimiter(jahiaDependsValue)).split(DELIMITER)).map(moduleId -> CapabilityUtils.buildRequireCapabilities(moduleId, skipRequireDependencies)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","))).isEmpty()) {
            projectProp.put("jahia.plugin.requiredModulesCapabilities", prefix + requireCapabilities);
        }
        String version = JahiaDepends.toOsgiVersion(project.getVersion());
        String provideArtifactId = CapabilityUtils.buildProvideCapabilities(project.getArtifactId(), version);
        String provideProjectName = CapabilityUtils.buildProvideCapabilities(project.getName(), version);
        StringBuilder provideCapabilities = new StringBuilder(prefix).append(provideArtifactId);
        if (StringUtils.isNotEmpty((String)provideProjectName)) {
            provideCapabilities.append(',').append(provideProjectName);
        }
        projectProp.put("jahia.plugin.providedModulesCapabilities", provideCapabilities.toString());
    }

    public static String buildRequireCapabilities(String dependency, Set<String> skipRequireDependencies) {
        if (StringUtils.isBlank((String)dependency)) {
            return "";
        }
        JahiaDepends depends = new JahiaDepends(dependency);
        if (skipRequireDependencies.contains(depends.getModuleName())) {
            return "";
        }
        return "com.jahia.modules.dependencies" + ";filter:=\"" + depends.toFilterString() + "\"";
    }

    public static String buildProvideCapabilities(String dependency, String version) {
        if (StringUtils.isBlank((String)dependency)) {
            return "";
        }
        String prefix = String.format("%s;%s=\"", "com.jahia.modules.dependencies", "moduleIdentifier");
        StringBuilder strBuilder = new StringBuilder(prefix).append(dependency).append('\"');
        if (StringUtils.isNotEmpty((String)version)) {
            strBuilder.append(';').append("moduleVersion").append(":Version=").append(version.trim());
        }
        return strBuilder.toString();
    }

    public static String replaceDependsDelimiter(String dependsValue) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(dependsValue, ",");
        String nextToken = null;
        while (nextToken != null || tokens.hasMoreTokens()) {
            String token = nextToken != null ? nextToken : tokens.nextToken();
            String string = nextToken = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            if (!token.contains("=")) {
                result.add(token);
                continue;
            }
            String dependency = token;
            String[] deps = token.split("=");
            if (JahiaDepends.isOpenClause(deps[1])) {
                String nextTokenStr = nextToken != null ? nextToken : "";
                dependency = String.format("%s,%s", token, nextTokenStr);
                nextToken = null;
            }
            JahiaDepends.parse(dependency);
            result.add(dependency);
        }
        return String.join((CharSequence)DELIMITER, result);
    }
}

