/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.support;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.RepositorySystemSession;
import org.jahia.utils.maven.plugin.support.AetherHelper;
import org.jahia.utils.maven.plugin.support.Maven30AetherHelper;
import org.jahia.utils.maven.plugin.support.Maven31AetherHelper;
import org.sonatype.aether.RepositorySystem;

public final class AetherHelperFactory {
    public static AetherHelper create(PlexusContainer container, MavenProject project, MavenSession session, Log log) throws MojoExecutionException {
        block5: {
            try {
                Object repoSession;
                if (container.hasComponent("org.sonatype.aether.RepositorySystem")) {
                    log.info((CharSequence)"Using Aether helper for Maven 3.0.x");
                    AetherHelperFactory.warnMavenVersion(log);
                    return new Maven30AetherHelper((RepositorySystem)container.lookup(RepositorySystem.class), session.getRepositorySession(), project.getRemoteProjectRepositories(), log);
                }
                if (!container.hasComponent(org.eclipse.aether.RepositorySystem.class)) break block5;
                try {
                    repoSession = MavenSession.class.getMethod("getRepositorySession", new Class[0]).invoke((Object)session, new Object[0]);
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
                List remoteRepos = project.getRemoteProjectRepositories();
                log.info((CharSequence)"Using Aether helper for Maven 3.1+");
                return new Maven31AetherHelper((org.eclipse.aether.RepositorySystem)container.lookup(org.eclipse.aether.RepositorySystem.class), (RepositorySystemSession)repoSession, remoteRepos, log);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        throw new MojoExecutionException("Unable to find either Sonatype's Aether nor Eclipse's Aether implementations");
    }

    private static void warnMavenVersion(Log log) {
        log.warn((CharSequence)"");
        log.warn((CharSequence)"************************* DEPRECATION *************************");
        log.warn((CharSequence)"*                                                             *");
        log.warn((CharSequence)"* The version of Maven (3.0.x), you are using, is deprecated. *");
        log.warn((CharSequence)"* Please, switch to a more recent one (e.g. 3.3.x).           *");
        log.warn((CharSequence)"*                                                             *");
        log.warn((CharSequence)"***************************************************************");
        log.warn((CharSequence)"");
    }
}

