/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.support;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jahia.utils.maven.plugin.support.AetherHelper;
import org.jahia.utils.maven.plugin.support.ArtifactProcessor;
import org.jahia.utils.maven.plugin.support.MavenAetherHelperUtils;
import org.jahia.utils.osgi.parsers.ParsingContext;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.graph.selector.AndDependencySelector;
import org.sonatype.aether.util.graph.selector.ExclusionDependencySelector;
import org.sonatype.aether.util.graph.selector.OptionalDependencySelector;
import org.sonatype.aether.util.graph.selector.ScopeDependencySelector;

public class Maven30AetherHelper
implements AetherHelper {
    private Log log;
    private List<RemoteRepository> remoteRepos;
    private RepositorySystem repoSystem;
    private Map<String, DependencyNode> resolvedDependencyNodes = new HashMap<String, DependencyNode>();
    DefaultRepositorySystemSession moreDependenciesSession;

    public Maven30AetherHelper(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos, Log log) {
        this.repoSystem = repoSystem;
        this.moreDependenciesSession = new DefaultRepositorySystemSession(repoSession);
        AndDependencySelector andDependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new OptionalDependencySelector(), new ExclusionDependencySelector()});
        this.moreDependenciesSession.setDependencySelector((DependencySelector)andDependencySelector);
        this.remoteRepos = remoteRepos;
        this.log = log;
    }

    private Set<String> findInWarDependencies(org.apache.maven.artifact.Artifact warArtifact, final String artifactId) {
        final LinkedHashSet<String> versions = new LinkedHashSet<String>();
        String artifactCoords = warArtifact.getGroupId() + ":" + warArtifact.getArtifactId() + ":" + warArtifact.getType() + ":" + warArtifact.getBaseVersion();
        DependencyNode node = null;
        if (this.resolvedDependencyNodes.containsKey(artifactCoords)) {
            node = this.resolvedDependencyNodes.get(artifactCoords);
        }
        if (node == null) {
            try {
                this.log.info((CharSequence)("Resolving artifact " + artifactCoords + "..."));
                ArtifactRequest request = new ArtifactRequest();
                request.setArtifact((Artifact)new DefaultArtifact(artifactCoords));
                request.setRepositories(this.remoteRepos);
                Dependency dependency = new Dependency((Artifact)new DefaultArtifact(artifactCoords), "compile");
                CollectRequest collectRequest = new CollectRequest();
                collectRequest.setRoot(dependency);
                collectRequest.setRepositories(this.remoteRepos);
                node = this.repoSystem.collectDependencies((RepositorySystemSession)this.moreDependenciesSession, collectRequest).getRoot();
                DependencyRequest dependencyRequest = new DependencyRequest(node, null);
                this.repoSystem.resolveDependencies((RepositorySystemSession)this.moreDependenciesSession, dependencyRequest);
                this.resolvedDependencyNodes.put(artifactCoords, node);
            }
            catch (DependencyCollectionException e) {
                this.log.error((Throwable)e);
            }
            catch (DependencyResolutionException e) {
                this.log.error((Throwable)e);
            }
        }
        if (node != null) {
            node.accept(new DependencyVisitor(){

                public boolean visitEnter(DependencyNode node) {
                    if (node.getDependency().getArtifact().getFile().getName().equals(artifactId)) {
                        versions.add(node.getDependency().getArtifact().getBaseVersion());
                    }
                    return true;
                }

                public boolean visitLeave(DependencyNode node) {
                    return true;
                }
            });
        }
        return versions;
    }

    @Override
    public Map<String, List<String>> findPackages(MavenProject project, List<String> packageNames) throws MojoExecutionException {
        HashMap<String, List<String>> foundPackages = new HashMap<String, List<String>>();
        for (org.apache.maven.artifact.Artifact artifact : project.getArtifacts()) {
            if (artifact.isOptional()) {
                this.log.debug((CharSequence)("Processing optional dependency " + artifact + "..."));
            }
            if (!artifact.getType().equals("jar")) {
                this.log.warn((CharSequence)("Found non JAR artifact " + artifact));
            }
            for (String packageName : packageNames) {
                if (!MavenAetherHelperUtils.doesJarHavePackageName(artifact.getFile(), packageName, this.log)) continue;
                LinkedList<String> trail = new LinkedList<String>(artifact.getDependencyTrail());
                if (artifact.isOptional()) {
                    trail.add("[optional]");
                }
                this.log.info((CharSequence)("Found package " + packageName + " in " + MavenAetherHelperUtils.getTrail(trail)));
                foundPackages.put(packageName, trail);
            }
        }
        for (String packageName : packageNames) {
            if (foundPackages.containsKey(packageName)) continue;
            this.log.warn((CharSequence)("Couldn't find " + packageName + " in normal project dependencies, will now search optional (and excluded) dependencies"));
            for (org.apache.maven.artifact.Artifact artifact : project.getArtifacts()) {
                DependencyNode dependencyNode;
                if (artifact.isOptional()) {
                    this.log.debug((CharSequence)("Processing optional artifact " + artifact + "..."));
                }
                if ((dependencyNode = this.getDependencyNode(MavenAetherHelperUtils.getCoords(artifact))) == null) continue;
                LinkedList<String> trail = new LinkedList<String>(artifact.getDependencyTrail());
                dependencyNode.accept((DependencyVisitor)new PackagerFinderDependencyVisitor(packageName, foundPackages, false, trail, null));
            }
        }
        return foundPackages;
    }

    private DependencyNode getDependencyNode(String artifactCoords) {
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact aetherArtifact = new DefaultArtifact(artifactCoords);
        request.setArtifact((Artifact)aetherArtifact);
        request.setRepositories(this.remoteRepos);
        Dependency dependency = new Dependency((Artifact)aetherArtifact, "compile");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        collectRequest.setRepositories(this.remoteRepos);
        DependencyNode dependencyNode = null;
        try {
            dependencyNode = this.repoSystem.collectDependencies((RepositorySystemSession)this.moreDependenciesSession, collectRequest).getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest(dependencyNode, null);
            DependencyResult dependencyResult = this.repoSystem.resolveDependencies((RepositorySystemSession)this.moreDependenciesSession, dependencyRequest);
        }
        catch (DependencyCollectionException e) {
            this.log.error((CharSequence)("Error collecting dependencies for " + artifactCoords + ": " + e.getMessage()));
        }
        catch (DependencyResolutionException e) {
            this.log.error((CharSequence)("Error resolving dependencies for " + artifactCoords + ": " + e.getMessage()));
        }
        return dependencyNode;
    }

    @Override
    public List<String> getDependencyVersion(MavenProject project, String artifactFileName) throws MojoExecutionException {
        if (project == null || StringUtils.isEmpty((String)artifactFileName)) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        Set artifacts = project.getArtifacts();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            if (artifact.getType().equals("war")) {
                versions.addAll(this.findInWarDependencies(artifact, artifactFileName));
                continue;
            }
            if (!artifact.getFile().getName().equals(artifactFileName)) continue;
            versions.add(artifact.getBaseVersion());
        }
        return new LinkedList<String>(versions);
    }

    @Override
    public File resolveArtifactFile(String coords) throws MojoExecutionException {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)new DefaultArtifact(coords));
        request.setRepositories(this.remoteRepos);
        Artifact artifact = null;
        try {
            artifact = this.repoSystem.resolveArtifact((RepositorySystemSession)this.moreDependenciesSession, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return artifact != null ? artifact.getFile() : null;
    }

    @Override
    public void processArtifactAndDependencies(org.apache.maven.artifact.Artifact artifact, boolean optional, ArtifactProcessor artifactProcessor, ArtifactHandler artifactHandler, ParsingContext rootParsingContext) {
        DependencyNode dependencyNode = this.getDependencyNode(MavenAetherHelperUtils.getCoords(artifact));
        if (dependencyNode != null) {
            LinkedList<String> trail = new LinkedList<String>(artifact.getDependencyTrail());
            dependencyNode.setScope(artifact.getScope());
            dependencyNode.accept((DependencyVisitor)new PackageCollectorDependencyVisitor(artifactProcessor, artifactHandler, trail, rootParsingContext));
        }
    }

    private DependencyNode resolveExclusion(DependencyNode dependencyNode, Exclusion exclusion) {
        if (dependencyNode.getDependency().getArtifact().getGroupId().equals(exclusion.getGroupId()) && dependencyNode.getDependency().getArtifact().getArtifactId().equals(exclusion.getArtifactId())) {
            return dependencyNode;
        }
        for (DependencyNode childNode : dependencyNode.getChildren()) {
            DependencyNode childDependency = this.resolveExclusion(childNode, exclusion);
            if (childDependency == null) continue;
            return childDependency;
        }
        return null;
    }

    class PackageCollectorDependencyVisitor
    implements DependencyVisitor {
        private ArtifactProcessor artifactProcessor;
        private ArtifactHandler artifactHandler;
        private Deque<String> curTrail = null;
        private Deque<org.apache.maven.artifact.Artifact> artifactStack = new ArrayDeque<org.apache.maven.artifact.Artifact>();
        private Deque<ParsingContext> parsingContextStack = new ArrayDeque<ParsingContext>();
        private Deque<String> loopCheckTrail = new ArrayDeque<String>();
        private int depth = 0;

        public PackageCollectorDependencyVisitor(ArtifactProcessor artifactProcessor, ArtifactHandler artifactHandler, List<String> dependencyTrail, ParsingContext rootParsingContext) {
            this.artifactProcessor = artifactProcessor;
            this.artifactHandler = artifactHandler;
            this.curTrail = new ArrayDeque<String>(dependencyTrail);
            this.parsingContextStack.push(rootParsingContext);
        }

        public boolean visitEnter(DependencyNode node) {
            ++this.depth;
            org.apache.maven.artifact.DefaultArtifact mavenArtifact = new org.apache.maven.artifact.DefaultArtifact(node.getDependency().getArtifact().getGroupId(), node.getDependency().getArtifact().getArtifactId(), node.getDependency().getArtifact().getVersion(), node.getDependency().getScope(), node.getDependency().getArtifact().getExtension(), StringUtils.isBlank((String)node.getDependency().getArtifact().getClassifier()) ? null : node.getDependency().getArtifact().getClassifier(), this.artifactHandler);
            boolean visitChildren = true;
            String trailSuffix = "";
            if (node.getDependency().isOptional()) {
                trailSuffix = "[optional]";
            }
            this.curTrail.push(node.toString() + trailSuffix);
            String trail = MavenAetherHelperUtils.getTrailPadding(this.curTrail);
            if (!this.loopCheckTrail.contains(node.toString())) {
                this.loopCheckTrail.push(node.toString());
            } else {
                Maven30AetherHelper.this.log.warn((CharSequence)("Already visited dependency " + node.toString() + "!!!"));
                visitChildren = false;
            }
            if (node.getDependency().getArtifact().getFile() == null) {
                Maven30AetherHelper.this.log.warn((CharSequence)(trail + "No local file for artifact " + node.getDependency().getArtifact()));
                Maven30AetherHelper.this.log.info((CharSequence)(trail + "Resolving artifact " + node.getDependency().getArtifact() + "..."));
                ArtifactRequest request = new ArtifactRequest();
                request.setArtifact(node.getDependency().getArtifact());
                request.setRepositories(Maven30AetherHelper.this.remoteRepos);
                try {
                    ArtifactResult artifactResult = Maven30AetherHelper.this.repoSystem.resolveArtifact((RepositorySystemSession)Maven30AetherHelper.this.moreDependenciesSession, request);
                    node.getDependency().getArtifact().setFile(artifactResult.getArtifact().getFile());
                }
                catch (ArtifactResolutionException e) {
                    Maven30AetherHelper.this.log.warn((CharSequence)(trail + "Error resolving artifact " + node.getDependency().getArtifact() + ": " + e.getMessage()));
                    visitChildren = false;
                }
            }
            mavenArtifact.setFile(node.getDependency().getArtifact().getFile());
            mavenArtifact.setOptional(node.getDependency().isOptional());
            this.artifactStack.push((org.apache.maven.artifact.Artifact)mavenArtifact);
            ParsingContext parsingContext = null;
            ParsingContext parentParsingContext = null;
            if (this.parsingContextStack.size() > 0) {
                parentParsingContext = this.parsingContextStack.peek();
            }
            if (mavenArtifact.getFile() != null) {
                boolean external = this.artifactProcessor.isExternal((org.apache.maven.artifact.Artifact)mavenArtifact);
                try {
                    parsingContext = this.artifactProcessor.enterArtifact((org.apache.maven.artifact.Artifact)mavenArtifact, node.getDependency().isOptional(), external, parentParsingContext, trail, this.depth);
                }
                catch (MojoExecutionException e) {
                    e.printStackTrace();
                    visitChildren = false;
                }
                this.parsingContextStack.push(parsingContext);
            }
            return visitChildren;
        }

        public boolean visitLeave(DependencyNode node) {
            --this.depth;
            boolean visitSiblings = true;
            String trail = MavenAetherHelperUtils.getTrailPadding(this.curTrail);
            org.apache.maven.artifact.Artifact mavenArtifact = null;
            if (node.getDependency().getArtifact().getArtifactId().equals(this.artifactStack.peek().getArtifactId())) {
                mavenArtifact = this.artifactStack.pop();
            } else {
                Maven30AetherHelper.this.log.warn((CharSequence)(trail + "Expected artifact " + node.getDependency().getArtifact().getArtifactId() + " on artifact stack but got " + this.artifactStack.peek().getArtifactId()));
            }
            if (mavenArtifact != null && mavenArtifact.getFile() != null) {
                try {
                    boolean external = false;
                    if ("provided".equals(node.getDependency().getScope())) {
                        external = true;
                    }
                    this.artifactProcessor.exitArtifact(mavenArtifact, node.getDependency().isOptional(), external, trail, this.parsingContextStack.peek(), this.depth);
                }
                catch (MojoExecutionException e) {
                    e.printStackTrace();
                }
                this.parsingContextStack.pop();
            }
            this.curTrail.pop();
            this.loopCheckTrail.pop();
            return visitSiblings;
        }
    }

    class PackagerFinderDependencyVisitor
    implements DependencyVisitor {
        private List<String> dependencyTrail = null;
        private boolean excludedDependency = false;
        private Map<String, List<String>> foundPackages;
        private String packageName;
        private Deque<String> loopCheckTrail = null;

        public PackagerFinderDependencyVisitor(String packageName, Map<String, List<String>> foundPackages, boolean excludedDependency, List<String> dependencyTrail, Deque<String> loopCheckTrail) {
            this.packageName = packageName;
            this.foundPackages = foundPackages;
            this.excludedDependency = excludedDependency;
            this.dependencyTrail = new LinkedList<String>(dependencyTrail);
            this.loopCheckTrail = loopCheckTrail == null ? new ArrayDeque<String>() : loopCheckTrail;
        }

        public boolean visitEnter(DependencyNode node) {
            if (this.loopCheckTrail.contains(node.toString())) {
                Maven30AetherHelper.this.log.warn((CharSequence)("Already visited dependency " + node.toString() + "!!!"));
                this.loopCheckTrail.push(node.toString());
                return false;
            }
            this.loopCheckTrail.push(node.toString());
            if (node.getDependency().getArtifact().getFile() == null) {
                Maven30AetherHelper.this.log.warn((CharSequence)("No local file for artifact " + node.getDependency().getArtifact()));
                return true;
            }
            if (node.getDependency().isOptional()) {
                Maven30AetherHelper.this.log.debug((CharSequence)("Processing optional file " + node.getDependency().getArtifact().getFile() + "..."));
            }
            LinkedList<String> curTrail = new LinkedList<String>(this.dependencyTrail);
            String trailSuffix = "";
            if (!this.excludedDependency) {
                if (node.getDependency().isOptional()) {
                    trailSuffix = "[optional]";
                }
            } else {
                trailSuffix = node.getDependency().isOptional() ? "[excluded+optional]" : "[excluded]";
            }
            curTrail.add(node.toString() + trailSuffix);
            String trail = MavenAetherHelperUtils.getTrail(this.dependencyTrail);
            if (MavenAetherHelperUtils.doesJarHavePackageName(node.getDependency().getArtifact().getFile(), this.packageName, Maven30AetherHelper.this.log)) {
                if (!this.excludedDependency) {
                    if (node.getDependency().isOptional()) {
                        Maven30AetherHelper.this.log.info((CharSequence)(trail + ": Found package " + this.packageName + " in optional artifact " + node.getDependency().getArtifact().getFile()));
                    } else {
                        Maven30AetherHelper.this.log.info((CharSequence)(trail + ": Found package " + this.packageName + " in artifact " + node.getDependency().getArtifact().getFile()));
                    }
                } else if (node.getDependency().isOptional()) {
                    Maven30AetherHelper.this.log.warn((CharSequence)(trail + ": Found package " + this.packageName + " in optional excluded artifact " + node.getDependency().getArtifact().getFile()));
                } else {
                    Maven30AetherHelper.this.log.warn((CharSequence)(trail + ": Found package " + this.packageName + " in excluded artifact " + node.getDependency().getArtifact().getFile()));
                }
                this.foundPackages.put(this.packageName, curTrail);
            } else {
                for (Exclusion exclusion : node.getDependency().getExclusions()) {
                    Maven30AetherHelper.this.log.debug((CharSequence)(trail + ": Processing exclusion " + exclusion + " of artifact " + node.getDependency().getArtifact()));
                    DependencyNode exclusionNode = Maven30AetherHelper.this.resolveExclusion(node, exclusion);
                    if (exclusionNode == null) continue;
                    exclusionNode.accept((DependencyVisitor)new PackagerFinderDependencyVisitor(this.packageName, this.foundPackages, true, new LinkedList<String>(curTrail), this.loopCheckTrail));
                }
            }
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            this.loopCheckTrail.pop();
            return true;
        }
    }
}

