/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class ContextServerDeployMojo
extends AbstractMojo {
    protected ArtifactResolver artifactResolver;
    protected ArtifactRepository localRepository;
    protected MavenProject project;
    protected File targetServerDirectory;

    private void doDeploy(File deployDir) {
        Artifact artifact = this.project.getArtifact();
        try {
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            this.getLog().info((CharSequence)("Deploying jar file " + artifact.getFile().getName() + " to " + deployDir));
            FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)deployDir);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while deploying JAR project", (Throwable)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.targetServerDirectory == null) {
            this.getLog().warn((CharSequence)"No context server target directory set for deployment. Skipping.");
            return;
        }
        File deployDir = new File(this.targetServerDirectory, "deploy");
        if (!deployDir.isDirectory()) {
            this.getLog().warn((CharSequence)("No context server deploy directory found under " + deployDir + " + . Skipping."));
            return;
        }
        if (!this.project.getPackaging().equals("bundle")) {
            this.getLog().warn((CharSequence)"Project does not have the \"bundle\" packaging. Skipping.");
            return;
        }
        this.doDeploy(deployDir);
    }
}

