/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class CopyJahiaWarMojo
extends AbstractMojo {
    protected File output;
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Artifact dependencyFile : this.project.getDependencyArtifacts()) {
            if (!"org.jahia.server".equals(dependencyFile.getGroupId()) || !"jahia-war".equals(dependencyFile.getArtifactId())) continue;
            try {
                ZipEntry entry;
                File webappDir = new File(this.output, "config/WEB-INF/jahia");
                ZipInputStream z = new ZipInputStream(new FileInputStream(dependencyFile.getFile()));
                int cnt = 0;
                while ((entry = z.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    File target = new File(webappDir, entry.getName());
                    if (entry.getTime() <= target.lastModified()) continue;
                    target.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(target);
                    IOUtils.copy((InputStream)z, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    ++cnt;
                }
                z.close();
                this.getLog().info((CharSequence)("Copied " + cnt + " files."));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error when copying file");
            }
        }
    }
}

