/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.bo.CategoryBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class CategoryService {
    private Log logger = new SystemStreamLog();
    private int counterCategories;

    private Element addCategory(int level, List<String> siteLanguages) {
        CategoryBO category = new CategoryBO(this.counterCategories, siteLanguages);
        Element categoryElement = category.getCategoryElement();
        --this.counterCategories;
        if (--level > 0 && this.counterCategories > 0) {
            categoryElement.addContent((Content)this.addCategory(level, siteLanguages));
        }
        return categoryElement;
    }

    public Element createCategories(Integer nbCategories, Integer nbLevelsCategories, ExportBO export) {
        this.logger.info((CharSequence)("Creation of " + nbCategories + " categories on " + nbLevelsCategories + " levels"));
        this.counterCategories = nbCategories - 1;
        Element categories = new Element("categories");
        List<String> siteLanguages = export.getSiteLanguages();
        while (this.counterCategories >= 0) {
            int level = nbLevelsCategories;
            Element category = this.addCategory(level, siteLanguages);
            categories.addContent((Content)category);
        }
        return categories;
    }

    public Document insertCategoriesIntoSiteRepository(Document repository, Element categories) {
        this.logger.info((CharSequence)"Add categories to the system site repository");
        Element systemSite = repository.getRootElement().getChild("sites").getChild("systemsite");
        systemSite.addContent((Content)categories);
        return repository;
    }
}

