/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.properties.DatabaseProperties;

public final class DatabaseService {
    private static DatabaseService instance;
    private static Connection dbConnection;
    private static final Log logger;

    private DatabaseService() {
    }

    public static DatabaseService getInstance() {
        if (instance == null) {
            instance = new DatabaseService();
        }
        return instance;
    }

    public Connection getConnection() {
        if (dbConnection == null) {
            try {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                StringBuffer sbConnection = new StringBuffer("jdbc:mysql://");
                sbConnection.append(DatabaseProperties.HOSTNAME).append(":").append(DatabaseProperties.PORT).append("/").append(DatabaseProperties.DATABASE).append("?user=").append(DatabaseProperties.USER).append("&password=").append(DatabaseProperties.PASSWORD);
                logger.info((CharSequence)("Connecting to " + sbConnection));
                dbConnection = DriverManager.getConnection(sbConnection.toString());
                logger.info((CharSequence)"MySQL connection established.");
            }
            catch (InstantiationException e) {
                logger.error((CharSequence)"Error during MySQL connection instantiation", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((CharSequence)"Error during MySQL connection", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error((CharSequence)"Error during MySQL connection instantiation", (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((CharSequence)"Error during MySQL connection instantiation", (Throwable)e);
            }
        }
        return dbConnection;
    }

    public void closeConnection() {
        if (null != dbConnection) {
            try {
                dbConnection.close();
                dbConnection = null;
            }
            catch (SQLException e) {
                logger.error((CharSequence)"Error during connection close", (Throwable)e);
            }
        }
    }

    public List<ArticleBO> selectArticles(ExportBO export, Integer numberOfArticles) {
        Integer querySize = this.getRecordSetsSize(export, numberOfArticles);
        ArrayList<ArticleBO> articlesContent = new ArrayList<ArticleBO>();
        List<Integer> articlesId = this.getArticlesIds(querySize);
        try {
            articlesContent.addAll(this.getArticlesContent(articlesId));
        }
        catch (SQLException e) {
            logger.error((CharSequence)"Error during articles content selection", (Throwable)e);
        }
        this.closeConnection();
        return articlesContent;
    }

    public List<Integer> getArticlesIds(Integer recordSetSize) {
        logger.debug((CharSequence)("Selecting " + recordSetSize + " ID's from database"));
        Statement stmt = null;
        ArrayList<Integer> idList = new ArrayList<Integer>();
        try {
            stmt = this.getConnection().createStatement();
            StringBuffer sbQuery = new StringBuffer("SELECT a.id_article FROM ");
            sbQuery.append(DatabaseProperties.TABLE + " a ");
            sbQuery.append(" ORDER BY RAND() ");
            sbQuery.append(" LIMIT 0," + recordSetSize);
            logger.debug((CharSequence)("SQL Query: " + sbQuery.toString()));
            boolean resultStmt = stmt.execute(sbQuery.toString());
            ResultSet results = null;
            if (resultStmt) {
                results = stmt.getResultSet();
                while (results.next()) {
                    idList.add(results.getInt("id_article"));
                }
            }
        }
        catch (SQLException e) {
            logger.error((CharSequence)"Error while requesting articles ID", (Throwable)e);
        }
        return idList;
    }

    public List<ArticleBO> getArticlesContent(List<Integer> articlesId) throws SQLException {
        logger.info((CharSequence)("Selecting " + articlesId.size() + " record(s) from database"));
        Statement stmt = null;
        stmt = this.getConnection().createStatement();
        StringBuffer sbIdCommaSeparated = new StringBuffer();
        for (Integer id : articlesId) {
            sbIdCommaSeparated.append(id + ",");
        }
        String idCommaSeparated = sbIdCommaSeparated.substring(0, sbIdCommaSeparated.length() - 1);
        StringBuffer sbQuery = new StringBuffer("SELECT a.id_article, a.title,a.content FROM ");
        sbQuery.append(DatabaseProperties.TABLE + " a ");
        sbQuery.append(" WHERE ");
        sbQuery.append(" a.id_article IN (" + idCommaSeparated + ")");
        logger.debug((CharSequence)("SQL Query: " + sbQuery.toString()));
        boolean resultStmt = stmt.execute(sbQuery.toString());
        ResultSet results = null;
        List<ArticleBO> articlesList = null;
        if (resultStmt) {
            results = stmt.getResultSet();
            articlesList = this.getArticleCollectionFromResultSet(results);
        }
        return articlesList;
    }

    private Integer getRecordSetsSize(ExportBO export, Integer numberOfArticles) {
        Integer totalRecords = null;
        totalRecords = numberOfArticles.compareTo(ContentGeneratorCst.SQL_RECORDSET_SIZE) < 0 ? numberOfArticles : ContentGeneratorCst.SQL_RECORDSET_SIZE;
        export.setMaxArticleIndex(totalRecords - 1);
        return totalRecords;
    }

    private List<ArticleBO> getArticleCollectionFromResultSet(ResultSet articles) throws SQLException {
        ArrayList<ArticleBO> listeArticles = new ArrayList<ArticleBO>();
        ArticleBO article = null;
        while (articles.next()) {
            Integer idArticle = articles.getInt("id_article");
            String title = articles.getString("title");
            String content = articles.getString("content");
            article = new ArticleBO(idArticle, title, content);
            listeArticles.add(article);
        }
        return listeArticles;
    }

    static {
        logger = new SystemStreamLog();
    }
}

